/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class PushbackReader
extends FilterReader {
    private char[] buf;
    private int pos;

    public PushbackReader(Reader reader, int n) {
        super(reader);
        this.buf = new char[n];
        this.pos = this.buf.length;
    }

    public PushbackReader(Reader reader) {
        this(reader, 1);
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n;
            try {
                if (this.pos < this.buf.length) {
                    char c = this.buf[this.pos++];
                    Object var4_4 = null;
                    return c;
                }
                n = super.read();
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                throw throwable;
            }
            Object var4_5 = null;
            return n;
        }
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                int n3;
                int n4 = 0;
                while (this.pos < this.buf.length && n2 > 0) {
                    cArray[n++] = this.buf[this.pos++];
                    --n2;
                    ++n4;
                }
                if (n2 > 0) {
                    n3 = super.read(cArray, n, n2);
                    if (n3 == -1) {
                        if (n4 == 0) {
                            n4 = -1;
                        }
                    } else {
                        n4 += n3;
                    }
                }
                n3 = n4;
                Object var8_7 = null;
                return n3;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                throw throwable;
            }
        }
    }

    public void unread(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.pos == 0) {
                    throw new IOException("pushback buffer is full");
                }
                --this.pos;
                this.buf[this.pos] = (char)n;
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    public void unread(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.pos < n2) {
                    throw new IOException("pushback buffer is too full");
                }
                this.pos -= n2;
                System.arraycopy(cArray, n, this.buf, this.pos, n2);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                throw throwable;
            }
        }
    }

    public void unread(char[] cArray) throws IOException {
        this.unread(cArray, 0, cArray.length);
    }

    public boolean ready() throws IOException {
        return this.pos < this.buf.length ? true : super.ready();
    }

    public boolean markSupported() {
        return false;
    }

    public void close() throws IOException {
        super.close();
    }
}

