/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedOutputStream;

public class PipedInputStream
extends InputStream {
    private PipedOutputStream src = null;
    protected static final int PIPE_SIZE = 512;
    protected byte[] pipe = new byte[512];
    protected int out = 0;
    protected int in = 0;
    private boolean closed = true;

    public PipedInputStream() {
    }

    public PipedInputStream(PipedOutputStream pipedOutputStream) throws IOException {
        this.connect(pipedOutputStream);
    }

    public void close() throws IOException {
        this.out = 0;
        this.in = 0;
        this.closed = true;
    }

    public void connect(PipedOutputStream pipedOutputStream) throws IOException {
        if (this.src == null) {
            this.src = pipedOutputStream;
            this.closed = false;
            pipedOutputStream.connect(this);
        }
    }

    public synchronized int read() throws IOException {
        while (this.out == this.in) {
            if (this.closed) {
                return -1;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        byte by = this.pipe[this.out];
        this.out = (this.out + 1) % 512;
        this.notifyAll();
        return by & 0xFF;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        return super.read(byArray, n, n2);
    }

    protected synchronized void receive(int n) {
        while (this.out == this.in + 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.pipe[this.in] = (byte)n;
        this.in = (this.in + 1) % 512;
        this.notifyAll();
    }

    protected void receivedLast() {
        this.closed = true;
    }
}

