/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentEvent;

public class WindowEvent
extends ComponentEvent {
    public static final int WINDOW_FIRST = 200;
    public static final int WINDOW_OPENED = 200;
    public static final int WINDOW_CLOSING = 201;
    public static final int WINDOW_CLOSED = 202;
    public static final int WINDOW_ICONIFIED = 203;
    public static final int WINDOW_DEICONIFIED = 204;
    public static final int WINDOW_ACTIVATED = 205;
    public static final int WINDOW_DEACTIVATED = 206;
    public static final int WINDOW_LAST = 206;

    public WindowEvent(Window window, int n) {
        super(window, n);
    }

    protected void dispatch() {
        if (this.id == 202) {
            ((Component)this.source).removeNotify();
        }
        AWTEvent.processWindowEvent(this);
        this.recycle();
    }

    public Window getWindow() {
        return (Window)this.source;
    }

    static WindowEvent getWindowEvent(int n, int n2) {
        return AWTEvent.getWindowEvent((Window)AWTEvent.sources[n], n2);
    }

    public String paramString() {
        switch (this.id) {
            case 200: {
                return "WINDOW_OPENED";
            }
            case 201: {
                return "WINDOW_CLOSING";
            }
            case 202: {
                return "WINDOW_CLOSED";
            }
            case 203: {
                return "WINDOW_ICONIFIED";
            }
            case 204: {
                return "WINDOW_DEICONIFIED";
            }
            case 205: {
                return "WINDOW_ACTIVATED";
            }
            case 206: {
                return "WINDOW_DEACTIVATED";
            }
        }
        return "?";
    }

    protected void recycle() {
        Object object = AWTEvent.evtLock;
        synchronized (object) {
            try {
                this.source = null;
                this.next = AWTEvent.wndEvtCache;
                AWTEvent.wndEvtCache = this;
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }
    }
}

