/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Vector
implements Cloneable,
Serializable {
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;

    public Vector() {
        this(10, 0);
    }

    public Vector(int n) {
        this(n, 0);
    }

    public Vector(int n, int n2) {
        this.elementData = new Object[n];
        this.elementCount = 0;
        this.capacityIncrement = n2;
    }

    public final synchronized void addElement(Object object) {
        if (this.elementCount == this.elementData.length) {
            this.ensureCapacity(this.elementCount + 1);
        }
        this.elementData[this.elementCount++] = object;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public synchronized Object clone() {
        Vector vector = new Vector(this.elementData.length, this.capacityIncrement);
        System.arraycopy(this.elementData, 0, vector.elementData, 0, this.elementCount);
        vector.elementCount = this.elementCount;
        return vector;
    }

    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public final synchronized void copyInto(Object[] objectArray) {
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
    }

    public final synchronized Object elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.elementData[n];
    }

    public final synchronized Enumeration elements() {
        return new Enumerator();
    }

    public final synchronized void ensureCapacity(int n) {
        if (this.elementData.length < n) {
            int n2 = this.elementData.length + (this.capacityIncrement > 0 ? this.capacityIncrement : this.elementData.length);
            if (n2 < n) {
                n2 = n;
            }
            Object[] objectArray = this.elementData;
            this.elementData = new Object[n2];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final synchronized Object firstElement() {
        if (this.elementCount <= 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public final synchronized int indexOf(Object object, int n) {
        for (int i = n; i < this.elementCount; ++i) {
            if (!object.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public final synchronized void insertElementAt(Object object, int n) {
        if (this.elementCount == this.elementData.length) {
            this.ensureCapacity(this.elementCount + 1);
        }
        if (n > this.elementCount || n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n < this.elementCount) {
            System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        }
        this.elementData[n] = object;
        ++this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final synchronized Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.size() - 1);
    }

    public final synchronized int lastIndexOf(Object object, int n) {
        for (int i = n; i >= 0; --i) {
            if (!object.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public final synchronized void removeAllElements() {
        for (int i = this.elementCount - 1; i >= 0; --i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    public final synchronized boolean removeElement(Object object) {
        if (this.contains(object)) {
            this.removeElementAt(this.indexOf(object));
            return true;
        }
        return false;
    }

    public final synchronized void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        System.arraycopy(this.elementData, n + 1, this.elementData, n, this.elementCount - n - 1);
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public final synchronized void setElementAt(Object object, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.elementData[n] = object;
    }

    public final synchronized void setSize(int n) {
        this.ensureCapacity(n);
        this.elementCount = n;
    }

    public final int size() {
        return this.elementCount;
    }

    public final synchronized String toString() {
        String string = new String();
        for (int i = 0; i < this.size(); ++i) {
            string = String.valueOf(string).concat(String.valueOf(this.elementData[i].toString()));
        }
        return string;
    }

    public final synchronized void trimToSize() {
        this.setSize(this.size());
    }

    class Enumerator
    implements Enumeration {
        int index;

        public boolean hasMoreElements() {
            return this.index < Vector.this.elementCount;
        }

        public Object nextElement() {
            if (this.index >= Vector.this.elementCount) {
                throw new NoSuchElementException();
            }
            return Vector.this.elementData[this.index++];
        }

        Enumerator() {
        }
    }
}

