/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashtableEntry;
import java.util.HashtableEnumeration;
import java.util.Vector;

public class Hashtable
extends Dictionary
implements Cloneable,
Serializable {
    private transient HashtableEntry[] bucket;
    private transient float loadFactor;
    private int numberOfKeys;
    private static final int DEFAULTCAPACITY = 16;
    private static final long serialVersionUID = 1421746759512286392L;

    public Hashtable(int n, float f) {
        if (n <= 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.bucket = new HashtableEntry[n];
        this.numberOfKeys = 0;
    }

    public Hashtable(int n) {
        this(n, 1.0f);
    }

    public Hashtable() {
        this(16, 1.0f);
    }

    public int size() {
        return this.numberOfKeys;
    }

    public boolean isEmpty() {
        return this.numberOfKeys == 0;
    }

    public synchronized Enumeration keys() {
        Vector vector = new Vector();
        for (int i = 0; i < this.bucket.length; ++i) {
            HashtableEntry hashtableEntry = this.bucket[i];
            while (hashtableEntry != null) {
                vector.addElement(hashtableEntry.getKey());
                hashtableEntry = hashtableEntry.next;
            }
        }
        return new HashtableEnumeration(vector);
    }

    public synchronized Enumeration elements() {
        Vector vector = new Vector();
        for (int i = 0; i < this.bucket.length; ++i) {
            HashtableEntry hashtableEntry = this.bucket[i];
            while (hashtableEntry != null) {
                vector.addElement(hashtableEntry.getData());
                hashtableEntry = hashtableEntry.next;
            }
        }
        return new HashtableEnumeration(vector);
    }

    public synchronized boolean contains(Object object) {
        for (int i = 0; i < this.bucket.length; ++i) {
            HashtableEntry hashtableEntry = this.bucket[i];
            while (hashtableEntry != null) {
                if (object.equals(hashtableEntry.getData())) {
                    return true;
                }
                hashtableEntry = hashtableEntry.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    public synchronized Object get(Object object) {
        int n = this.calculateBucket(object);
        HashtableEntry hashtableEntry = this.bucket[n];
        while (hashtableEntry != null) {
            if (object.equals(hashtableEntry.getKey())) {
                return hashtableEntry.getData();
            }
            hashtableEntry = hashtableEntry.next;
        }
        return null;
    }

    private int calculateBucket(Object object) {
        int n = object.hashCode() % this.bucket.length;
        if (n < 0) {
            return -n;
        }
        return n;
    }

    protected synchronized void rehash() {
        int n = this.bucket.length * 2;
        HashtableEntry[] hashtableEntryArray = this.bucket;
        this.bucket = new HashtableEntry[n];
        this.numberOfKeys = 0;
        for (int i = 0; i < hashtableEntryArray.length; ++i) {
            HashtableEntry hashtableEntry = hashtableEntryArray[i];
            while (hashtableEntry != null) {
                this.put(hashtableEntry.getKey(), hashtableEntry.getData());
                hashtableEntry = hashtableEntry.next;
            }
        }
    }

    public synchronized Object put(Object object, Object object2) {
        if ((double)this.loadFactor == 0.0) {
            throw new Error("Load Factor is 0.0");
        }
        if (this.size() > (int)(this.loadFactor * (float)this.bucket.length)) {
            this.rehash();
        }
        int n = this.calculateBucket(object);
        HashtableEntry hashtableEntry = this.bucket[n];
        while (hashtableEntry != null) {
            if (object.equals(hashtableEntry.getKey())) {
                Object object3 = hashtableEntry.getData();
                hashtableEntry.data = object2;
                return object3;
            }
            hashtableEntry = hashtableEntry.next;
        }
        HashtableEntry hashtableEntry2 = new HashtableEntry(object, object2);
        hashtableEntry2.next = this.bucket[n];
        this.bucket[n] = hashtableEntry2;
        ++this.numberOfKeys;
        return null;
    }

    public synchronized Object remove(Object object) {
        int n = this.calculateBucket(object);
        HashtableEntry hashtableEntry = this.bucket[n];
        if (hashtableEntry == null) {
            return null;
        }
        if (object.equals(hashtableEntry.getKey())) {
            --this.numberOfKeys;
            this.bucket[n] = hashtableEntry.next;
            return hashtableEntry.getData();
        }
        while (hashtableEntry.next != null) {
            if (object.equals(hashtableEntry.next.getKey())) {
                --this.numberOfKeys;
                HashtableEntry hashtableEntry2 = hashtableEntry.next;
                hashtableEntry.next = hashtableEntry2.next;
                return hashtableEntry2.getData();
            }
            hashtableEntry = hashtableEntry.next;
        }
        return null;
    }

    public synchronized void clear() {
        this.numberOfKeys = 0;
        for (int i = 0; i < this.bucket.length; ++i) {
            this.bucket[i] = null;
        }
    }

    public synchronized Object clone() {
        Hashtable hashtable = null;
        try {
            hashtable = (Hashtable)super.clone();
            hashtable.numberOfKeys = 0;
            hashtable.loadFactor = this.loadFactor;
            hashtable.bucket = new HashtableEntry[this.bucket.length];
            for (int i = 0; i < this.bucket.length; ++i) {
                HashtableEntry hashtableEntry = this.bucket[i];
                while (hashtableEntry != null) {
                    hashtable.put(hashtableEntry.getKey(), hashtableEntry.getData());
                    hashtableEntry = hashtableEntry.next;
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return hashtable;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.loadFactor = objectInputStream.readFloat();
        if ((double)this.loadFactor == 0.0) {
            throw new Error("Load Factor is 0.0");
        }
        this.bucket = new HashtableEntry[objectInputStream.readInt()];
        int n = this.numberOfKeys;
        this.numberOfKeys = 0;
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            this.put(object, objectInputStream.readObject());
        }
        if (this.numberOfKeys != n) {
            throw new IOException(String.valueOf(String.valueOf(String.valueOf("read ").concat(String.valueOf(this.numberOfKeys))).concat(String.valueOf(" expected "))).concat(String.valueOf(n)));
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeFloat(this.loadFactor);
        objectOutputStream.writeInt(this.bucket.length);
        for (int i = 0; i < this.bucket.length; ++i) {
            HashtableEntry hashtableEntry = this.bucket[i];
            while (hashtableEntry != null) {
                objectOutputStream.writeObject(hashtableEntry.getKey());
                objectOutputStream.writeObject(hashtableEntry.getData());
                hashtableEntry = hashtableEntry.next;
            }
        }
    }

    public synchronized String toString() {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        for (int i = 0; i < this.bucket.length; ++i) {
            HashtableEntry hashtableEntry = this.bucket[i];
            while (hashtableEntry != null) {
                if (!bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = false;
                }
                stringBuffer = stringBuffer.append(String.valueOf(String.valueOf(hashtableEntry.getKey()).concat(String.valueOf("="))).concat(String.valueOf(hashtableEntry.getData())));
                hashtableEntry = hashtableEntry.next;
            }
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

