/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Locale;
import kaffe.util.NotImplemented;

public class MessageFormat
extends Format {
    private Locale loc = Locale.getDefault();
    private String[] strs;
    private Format[] forms;
    private int[] argno;

    public MessageFormat(String string) {
        this.applyPattern(string);
    }

    public void applyPattern(String string) {
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != '{') continue;
            ++n2;
            while (string.charAt(i) != '}' && i < n) {
                ++i;
            }
        }
        this.forms = new Format[n2];
        this.strs = new String[n2 + 1];
        this.argno = new int[n2];
        n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != '{') continue;
            this.strs[n2] = string.substring(n3, i);
            n3 = ++i;
            while (string.charAt(i) != '}' && i < n) {
                ++i;
            }
            this.parseFormat(string.substring(n3, i), n2);
            ++n2;
            n3 = i + 1;
        }
        this.strs[n2] = string.substring(n3, n);
    }

    private void parseFormat(String string, int n) {
        int n2;
        int n3 = string.indexOf(44);
        int n4 = n3 + 1;
        if (n3 == -1) {
            n4 = n3 = string.length();
        }
        int n5 = string.indexOf(44, n3 + 1);
        int n6 = n5 + 1;
        if (n5 == -1) {
            n6 = n5 = string.length();
        }
        try {
            n2 = Integer.parseInt(string.substring(0, n3));
        }
        catch (NumberFormatException numberFormatException) {
            n2 = -1;
        }
        String string2 = string.substring(n4, n5);
        String string3 = string.substring(n6, string.length());
        this.argno[n] = n2;
        if (string2.equals("time")) {
            this.forms[n] = string3.equals("") ? DateFormat.getTimeInstance(2, this.loc) : (string3.equals("short") ? DateFormat.getTimeInstance(3, this.loc) : (string3.equals("medium") ? DateFormat.getTimeInstance(2, this.loc) : (string3.equals("long") ? DateFormat.getTimeInstance(1, this.loc) : (string3.equals("full") ? DateFormat.getTimeInstance(0, this.loc) : new SimpleDateFormat(string3, this.loc)))));
        } else if (string2.equals("date")) {
            this.forms[n] = string3.equals("") ? DateFormat.getDateInstance(2, this.loc) : (string3.equals("short") ? DateFormat.getDateInstance(3, this.loc) : (string3.equals("medium") ? DateFormat.getDateInstance(2, this.loc) : (string3.equals("long") ? DateFormat.getDateInstance(1, this.loc) : (string3.equals("full") ? DateFormat.getDateInstance(0, this.loc) : new SimpleDateFormat(string3, this.loc)))));
        } else if (string2.equals("number")) {
            this.forms[n] = string3.equals("currency") ? NumberFormat.getCurrencyInstance(this.loc) : (string3.equals("percent") ? NumberFormat.getPercentageInstance(this.loc) : (string3.equals("integer") ? NumberFormat.getNumberInstance(this.loc) : new DecimalFormat(string3, this.loc)));
        } else if (string2.equals("choice")) {
            this.forms[n] = new ChoiceFormat(string3);
        }
    }

    public Object clone() {
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.loc = this.loc;
        messageFormat.strs = this.strs;
        messageFormat.forms = this.forms;
        messageFormat.argno = this.argno;
        return messageFormat;
    }

    public boolean equals(Object object) {
        try {
            MessageFormat messageFormat = (MessageFormat)object;
            if (this.loc != messageFormat.loc) {
                return false;
            }
            for (int i = 0; i < this.forms.length; ++i) {
                if (!this.forms[i].equals(messageFormat.forms[i])) {
                    return false;
                }
                if (this.strs[i].equals(messageFormat.strs[i])) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public static String format(String string, Object[] objectArray) {
        return new MessageFormat(string).format(objectArray, new StringBuffer(), (FieldPosition)null).toString();
    }

    public final StringBuffer format(Object[] objectArray, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        FieldPosition fieldPosition2 = new FieldPosition(0);
        for (int i = 0; i < this.forms.length; ++i) {
            stringBuffer.append(this.strs[i]);
            if (this.forms[i] == null) {
                stringBuffer.append((String)objectArray[this.argno[i]]);
                continue;
            }
            this.forms[i].format(objectArray[this.argno[i]], stringBuffer, fieldPosition2);
        }
        stringBuffer.append(this.strs[this.strs.length - 1]);
        return stringBuffer;
    }

    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        Object[] objectArray = new Object[]{object};
        return this.format(objectArray, stringBuffer, fieldPosition);
    }

    public Format[] getFormats() {
        return this.forms;
    }

    public Locale getLocale() {
        return this.loc;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Object[] parse(String string, ParsePosition parsePosition) {
        throw new NotImplemented();
    }

    public Object[] parse(String string) throws ParseException {
        return this.parse(string, new ParsePosition(0));
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        Object[] objectArray = this.parse(string, parsePosition);
        return objectArray;
    }

    public void setFormat(int n, Format format) {
        this.forms[n] = format;
    }

    public void setFormats(Format[] formatArray) {
        this.forms = formatArray;
    }

    public void setLocale(Locale locale2) {
        this.loc = locale2;
    }

    public String toPattern() {
        throw new NotImplemented();
    }
}

