/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import kaffe.net.DefaultURLStreamHandlerFactory;

public final class URL
implements Serializable {
    private static URLStreamHandlerFactory defaultFactory = new DefaultURLStreamHandlerFactory();
    private static URLStreamHandlerFactory factory;
    private URLStreamHandler handler;
    private String protocol;
    private String host;
    private int port;
    private String file;
    private String ref;
    private URLConnection conn;

    public URL(String string, String string2, String string3) throws MalformedURLException {
        this(string, string2, -1, string3);
    }

    public URL(String string, String string2, int n, String string3) throws MalformedURLException {
        this.protocol = string;
        this.host = string2;
        this.file = string3;
        if (n == -1) {
            n = URL.getDefaultPort(string);
        }
        this.port = n;
    }

    public URL(String string) throws MalformedURLException {
        int n;
        int n2 = string.indexOf(58, 0);
        if (n2 == -1) {
            throw new MalformedURLException("no protocol");
        }
        this.protocol = string.substring(0, n2);
        int n3 = n2 + 3;
        if (string.substring(n2 + 1, n3).equals("//")) {
            n = string.indexOf(58, n3);
            if (n == -1) {
                n = string.indexOf(47, n3);
                if (n == -1) {
                    throw new MalformedURLException("no host");
                }
                this.host = string.substring(n3, n);
                this.port = URL.getDefaultPort(this.protocol);
            } else {
                this.host = string.substring(n3, n);
                int n4 = n + 1;
                int n5 = string.indexOf(47, n4);
                this.port = Integer.parseInt(string.substring(n4, n5));
            }
        } else {
            this.host = "";
            this.port = URL.getDefaultPort(this.protocol);
        }
        n = string.indexOf(47, n3);
        this.file = n != -1 ? string.substring(n + 1) : "";
    }

    public URL(URL uRL, String string) throws MalformedURLException {
        this(String.valueOf(uRL.toString()).concat(String.valueOf(string)));
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof URL)) {
            return false;
        }
        URL uRL = (URL)object;
        return this.protocol == uRL.protocol && this.host == uRL.host && this.port == uRL.port && this.file == uRL.file && this.ref == uRL.ref;
    }

    public final Object getContent() throws IOException {
        this.openConnection();
        this.conn.connect();
        return this.conn.getContent();
    }

    public String getFile() {
        return this.file;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRef() {
        return this.ref;
    }

    public int hashCode() {
        return this.protocol.hashCode() ^ this.host.hashCode() ^ this.file.hashCode();
    }

    public URLConnection openConnection() throws IOException {
        if (this.conn == null) {
            if (this.handler == null) {
                this.handler = URL.getURLStreamHandler(this.protocol);
            }
            this.conn = this.handler.openConnection(this);
        }
        return this.conn;
    }

    public InputStream openStream() throws IOException {
        if (this.conn == null) {
            this.openConnection();
            this.conn.connect();
        }
        return this.conn.getInputStream();
    }

    public boolean sameFile(URL uRL) {
        return this.protocol == uRL.protocol && this.host == uRL.host && this.port == uRL.port && this.file == uRL.file;
    }

    protected void set(String string, String string2, int n, String string3, String string4) {
        this.protocol = string;
        this.host = string2;
        this.port = n;
        this.file = string3;
        this.ref = string4;
    }

    public static synchronized void setURLStreamHandlerFactory(URLStreamHandlerFactory uRLStreamHandlerFactory) {
        if (factory != null) {
            throw new Error("factory already set");
        }
        factory = uRLStreamHandlerFactory;
    }

    public String toExternalForm() {
        return this.toString();
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.protocol).concat(String.valueOf("://"))).concat(String.valueOf(this.host))).concat(String.valueOf(":"))).concat(String.valueOf(this.port))).concat(String.valueOf("/"))).concat(String.valueOf(this.file));
    }

    private static URLStreamHandler getURLStreamHandler(String string) throws MalformedURLException {
        URLStreamHandler uRLStreamHandler = null;
        if (factory != null && (uRLStreamHandler = factory.createURLStreamHandler(string)) != null) {
            return uRLStreamHandler;
        }
        uRLStreamHandler = defaultFactory.createURLStreamHandler(string);
        if (uRLStreamHandler != null) {
            return uRLStreamHandler;
        }
        throw new MalformedURLException("failed to find handler");
    }

    private static int getDefaultPort(String string) {
        int n = string == "ftp" ? 21 : (string == "telnet" ? 23 : (string == "gopher" ? 70 : (string == "http" ? 80 : (string == "news" ? 119 : 0))));
        return n;
    }
}

