/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.PlainSocketImpl;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;

public final class ServerSocket {
    private static SocketImplFactory factory = null;
    private SocketImpl impl = factory == null ? new PlainSocketImpl() : factory.createSocketImpl();

    ServerSocket() {
    }

    public ServerSocket(int n) throws IOException {
        this(n, 50);
    }

    public ServerSocket(int n, int n2) throws IOException {
        this();
        System.getSecurityManager().checkListen(n);
        this.impl.create(true);
        this.impl.bind(InetAddress.anyLocalAddress, n);
        this.impl.listen(n2);
    }

    public Socket accept() throws IOException {
        Socket socket = new Socket();
        socket.impl.fd = new FileDescriptor();
        socket.impl.address = new InetAddress();
        this.impl.accept(socket.impl);
        System.getSecurityManager().checkAccept(socket.getInetAddress().getHostName(), socket.getPort());
        return socket;
    }

    public void close() throws IOException {
        this.impl.close();
    }

    public InetAddress getInetAddress() {
        return this.impl.getInetAddress();
    }

    public int getLocalPort() {
        return this.impl.getLocalPort();
    }

    public SocketImpl newSocketImpl() {
        return this.impl;
    }

    public static synchronized void setSocketFactory(SocketImplFactory socketImplFactory) throws IOException {
        if (factory != null) {
            throw new SocketException();
        }
        factory = socketImplFactory;
    }

    public String toString() {
        return this.impl.toString();
    }
}

