/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Integer
extends Number {
    private int value;
    public static final Class TYPE = Class.getPrimitiveClass("int");
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;

    public Integer(String string) throws NumberFormatException {
        this(Integer.parseInt(string));
    }

    public Integer(int n) {
        this.value = n;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public static Integer decode(String string) throws NumberFormatException {
        if (string.startsWith("0x")) {
            return Integer.valueOf(string.substring(2), 16);
        }
        if (string.startsWith("#")) {
            return Integer.valueOf(string.substring(1), 16);
        }
        if (string.startsWith("0")) {
            return Integer.valueOf(string.substring(1), 8);
        }
        return Integer.valueOf(string.substring(1), 10);
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Integer) {
            return this.intValue() == ((Integer)object).intValue();
        }
        return false;
    }

    public float floatValue() {
        return this.value;
    }

    public static Integer getInteger(String string) {
        return Integer.getInteger(string, null);
    }

    public static Integer getInteger(String string, Integer n) {
        String string2 = n == null ? null : n.toString();
        String string3 = System.getProperty(string, string2);
        try {
            if (string3 == null) {
                return n;
            }
            if (string3.startsWith("0x")) {
                return Integer.valueOf(string3.substring(2), 16);
            }
            if (string3.startsWith("#")) {
                return Integer.valueOf(string3.substring(1), 16);
            }
            if (string3.startsWith("0")) {
                return Integer.valueOf(string3.substring(1), 8);
            }
            return new Integer(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static Integer getInteger(String string, int n) {
        return Integer.getInteger(string, new Integer(n));
    }

    public int hashCode() {
        return this;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public static int parseInt(String string) throws NumberFormatException {
        return Integer.parseInt(string, 10);
    }

    public static int parseInt(String string, int n) throws NumberFormatException {
        if (string.length() <= 0) {
            throw new NumberFormatException();
        }
        if (string.charAt(0) == '-') {
            return Integer.parseInt(string.substring(1), n) * -1;
        }
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            int n3 = Character.digit(string.charAt(i), n);
            if (n3 == -1) {
                throw new NumberFormatException();
            }
            n2 = n2 * n + n3;
        }
        return n2;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public static String toBinaryString(int n) {
        return Integer.toString(n, 2);
    }

    public static String toHexString(int n) {
        return Integer.toString(n, 16);
    }

    public static String toOctalString(int n) {
        return Integer.toString(n, 8);
    }

    public String toString() {
        return Integer.toString(this);
    }

    public static String toString(int n) {
        return Integer.toString(n, 10);
    }

    public static String toString(int n, int n2) {
        if (n == 0) {
            return "0";
        }
        if (n2 < 2 || n2 > 36) {
            n2 = 10;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 1;
        if (n < 0) {
            n3 = -1;
        }
        while (n != 0) {
            char c = Character.forDigit(Math.abs(n % n2), n2);
            n /= n2;
            stringBuffer.append(c);
        }
        if (n3 == -1) {
            stringBuffer.append('-');
        }
        stringBuffer.reverse();
        return stringBuffer.toString();
    }

    public static Integer valueOf(String string) throws NumberFormatException {
        return Integer.valueOf(string, 10);
    }

    public static Integer valueOf(String string, int n) throws NumberFormatException {
        return new Integer(Integer.parseInt(string, n));
    }
}

