/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.SystemClassLoader;

public final class Class {
    private static ClassLoader systemLoader = new SystemClassLoader();

    public static native Class forName(String var0) throws ClassNotFoundException;

    public ClassLoader getClassLoader() {
        return this.getClassLoader0();
    }

    private native ClassLoader getClassLoader0();

    public Class[] getClasses() {
        return this.getClasses0(false);
    }

    private native Class[] getClasses0(boolean var1);

    public native Class getComponentType();

    public Constructor getConstructor(Class[] classArray) throws NoSuchMethodException, SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 1);
        return this.getConstructor0(classArray, false);
    }

    private native Constructor getConstructor0(Class[] var1, boolean var2);

    public Constructor[] getConstructors() throws SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 1);
        return this.getConstructors0(false);
    }

    private native Constructor[] getConstructors0(boolean var1);

    public Class[] getDeclaredClasses() throws SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 2);
        return this.getClasses0(true);
    }

    public Constructor getDeclaredConstructor(Class[] classArray) throws NoSuchMethodException, SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 2);
        return this.getConstructor0(classArray, true);
    }

    public Constructor[] getDeclaredConstructors() throws SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 2);
        return this.getConstructors0(true);
    }

    public Field getDeclaredField(String string) throws NoSuchFieldException, SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 2);
        return this.getField0(string, true);
    }

    public Field[] getDeclaredFields() throws SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 2);
        return this.getFields0(true);
    }

    public Method getDeclaredMethod(String string, Class[] classArray) throws NoSuchMethodException, SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 2);
        return this.getMethod0(string, classArray, true);
    }

    public Method[] getDeclaredMethods() throws SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 2);
        return this.getMethods0(true);
    }

    public Class getDeclaringClass() {
        return null;
    }

    public Field getField(String string) throws NoSuchFieldException, SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 1);
        return this.getField0(string, false);
    }

    private native Field getField0(String var1, boolean var2);

    public Field[] getFields() throws SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 1);
        return this.getFields0(false);
    }

    private native Field[] getFields0(boolean var1);

    public native Class[] getInterfaces();

    public Method getMethod(String string, Class[] classArray) throws NoSuchMethodException, SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 1);
        return this.getMethod0(string, classArray, false);
    }

    private native Method getMethod0(String var1, Class[] var2, boolean var3);

    public Method[] getMethods() throws SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 1);
        return this.getMethods0(false);
    }

    private native Method[] getMethods0(boolean var1);

    public native int getModifiers();

    public native String getName();

    public static native Class getPrimitiveClass(String var0);

    public URL getResource(String string) {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader != null) {
            return classLoader.getResource(this.fullResourceName(string));
        }
        return systemLoader.getResource(this.fullResourceName(string));
    }

    public InputStream getResourceAsStream(String string) {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader != null) {
            return classLoader.getResourceAsStream(this.fullResourceName(string));
        }
        return systemLoader.getResourceAsStream(this.fullResourceName(string));
    }

    private String fullResourceName(String string) {
        if (string.charAt(0) != '/') {
            String string2 = this.getName();
            StringBuffer stringBuffer = new StringBuffer();
            int n = string2.lastIndexOf(46);
            if (n != -1) {
                stringBuffer.append(string2.substring(0, n).replace('.', '/'));
            }
            stringBuffer.append('/');
            stringBuffer.append(string);
            string = stringBuffer.toString();
        }
        return string;
    }

    public native Object[] getSigners();

    public native Class getSuperclass();

    public native boolean isArray();

    public native boolean isAssignableFrom(Class var1);

    public native boolean isInstance(Object var1);

    public native boolean isInterface();

    public native boolean isPrimitive();

    public native Object newInstance() throws InstantiationException, IllegalAccessException;

    public String toString() {
        Class clazz = this;
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isPrimitive()) {
            if (this.isInterface()) {
                stringBuffer.append("interface ");
            } else {
                stringBuffer.append("class ");
            }
        }
        stringBuffer.append(clazz.getName());
        return stringBuffer.toString();
    }
}

