/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.InputStream;

public class StringBufferInputStream
extends InputStream {
    protected String buffer;
    protected int pos;
    protected int count;

    public StringBufferInputStream(String string) {
        this.buffer = string;
        this.count = string.length();
        this.reset();
    }

    public synchronized int available() {
        return this.count - this.pos;
    }

    public synchronized int read() {
        if (this.pos < this.count) {
            return this.buffer.charAt(this.pos++) & 0xFF;
        }
        return -1;
    }

    public synchronized int read(byte[] byArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            int n3 = this.read();
            if (n3 == -1) {
                if (i - n == 0) {
                    return -1;
                }
                return i - n;
            }
            byArray[i] = (byte)n3;
        }
        return n2;
    }

    public synchronized void reset() {
        this.pos = 0;
    }

    public synchronized long skip(long l) {
        long l2 = Math.min((long)this.available(), l);
        this.pos += (int)l2;
        return l2;
    }
}

