/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BufferedOutputStream
extends FilterOutputStream {
    protected byte[] buf;
    protected int count;
    private static final int DEFAULTBUFFER = 2048;

    public BufferedOutputStream(OutputStream outputStream) {
        this(outputStream, 2048);
    }

    public BufferedOutputStream(OutputStream outputStream, int n) {
        super(outputStream);
        this.buf = new byte[n];
        this.count = 0;
    }

    public void finalize() throws IOException {
        this.flush();
    }

    public synchronized void flush() throws IOException {
        super.write(this.buf, 0, this.count);
        super.flush();
        this.count = 0;
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n + n2) {
            if (this.count == this.buf.length) {
                this.flush();
            }
            this.buf[this.count++] = byArray[n3++];
        }
    }

    public synchronized void write(int n) throws IOException {
        if (this.count == this.buf.length) {
            this.flush();
        }
        this.buf[this.count++] = (byte)n;
    }
}

