/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;

public class DirectColorModel
extends ColorModel {
    int rmask;
    int gmask;
    int bmask;
    int amask;
    int shift_alpha;
    int shift_red;
    int shift_green;
    int shift_blue;

    public DirectColorModel(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 0);
    }

    public DirectColorModel(int n, int n2, int n3, int n4, int n5) {
        super(n);
        this.rmask = n2;
        this.gmask = n3;
        this.bmask = n4;
        this.amask = n5;
        this.shift_alpha = DirectColorModel.getOffset(n5) - 8;
        this.shift_red = DirectColorModel.getOffset(n2) - 8;
        this.shift_green = DirectColorModel.getOffset(n3) - 8;
        this.shift_blue = DirectColorModel.getOffset(n4) - 8;
    }

    public final int getAlpha(int n) {
        return (n & this.amask) >>> this.shift_alpha;
    }

    public final int getAlphaMask() {
        return this.amask;
    }

    public final int getBlue(int n) {
        return (n & this.bmask) >>> this.shift_blue;
    }

    public final int getBlueMask() {
        return this.bmask;
    }

    public final int getGreen(int n) {
        return (n & this.gmask) >>> this.shift_green;
    }

    public final int getGreenMask() {
        return this.gmask;
    }

    static int getOffset(int n) {
        int n2 = 0;
        while ((n & 1) == 0) {
            n >>>= 1;
            ++n2;
        }
        while ((n & 1) != 0) {
            n >>>= 1;
            ++n2;
        }
        return n2;
    }

    public final int getRGB(int n) {
        if (this == ColorModel.defaultCM) {
            return n;
        }
        return (n & this.amask) << 24 - this.shift_alpha | (n & this.rmask) << 16 - this.shift_red | (n & this.gmask) << 8 - this.shift_green | (n & this.bmask) << this.shift_blue;
    }

    public final int getRed(int n) {
        return (n & this.rmask) >>> this.shift_red;
    }

    public final int getRedMask() {
        return this.rmask;
    }
}

