/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.InputEvent;

public class MouseEvent
extends InputEvent {
    protected int x;
    protected int y;
    protected int clickCount;
    protected boolean isPopupTrigger;
    int button;
    public static final int MOUSE_FIRST = 500;
    public static final int MOUSE_LAST = 506;
    public static final int MOUSE_CLICKED = 500;
    public static final int MOUSE_PRESSED = 501;
    public static final int MOUSE_RELEASED = 502;
    public static final int MOUSE_MOVED = 503;
    public static final int MOUSE_ENTERED = 504;
    public static final int MOUSE_EXITED = 505;
    public static final int MOUSE_DRAGGED = 506;
    static long lastPressed;
    static int clicks;

    public MouseEvent(Component component, int n, long l, int n2, int n3, int n4, int n5, boolean bl) {
        super(component, n);
        this.when = this.when;
        this.modifiers = n2;
        this.x = n3;
        this.y = n4;
        this.clickCount = n5;
        this.isPopupTrigger = bl;
    }

    protected void dispatch() {
        if (AWTEvent.buttonPressed) {
            Object object = this.source;
            int n = this.x;
            int n2 = this.y;
            this.x -= AWTEvent.xMouseTgt;
            this.y -= AWTEvent.yMouseTgt;
            this.source = AWTEvent.mouseTgt;
            if (this.id == 503) {
                this.id = 506;
                AWTEvent.mouseDragged = true;
                AWTEvent.processMouseMotionEvent(this);
            } else if (this.id == 502) {
                AWTEvent.accelHint = false;
                MouseEvent.updateInputModifier(this.button, false);
                if (AWTEvent.mouseDragged) {
                    AWTEvent.buttonPressed = false;
                    AWTEvent.processMouseEvent(this);
                    AWTEvent.mouseDragged = false;
                    this.x = n;
                    this.y = n2;
                    Component component = AWTEvent.computeMouseTarget((Container)object, this.x, this.y);
                    if (component != AWTEvent.mouseTgt) {
                        this.x -= AWTEvent.xMouseTgt;
                        this.y -= AWTEvent.yMouseTgt;
                        AWTEvent.transferMouse(this, AWTEvent.mouseTgt, AWTEvent.mousePos.x, AWTEvent.mousePos.y, component, this.x, this.y);
                        AWTEvent.mouseTgt = component;
                    }
                } else {
                    this.clickCount = clicks;
                    MouseEvent.postMouseClicked(object, this.when, this.x + AWTEvent.xMouseTgt, this.y + AWTEvent.yMouseTgt, this.modifiers, this.clickCount, this.button);
                    AWTEvent.processMouseEvent(this);
                }
            } else if (this.id == 500) {
                AWTEvent.checkPopup(object);
                AWTEvent.buttonPressed = false;
                this.clickCount = clicks;
                AWTEvent.processMouseEvent(this);
                if (this.isPopupTrigger) {
                    AWTEvent.triggerPopup(this);
                }
            }
        } else {
            Component component;
            if (this.source instanceof Container && this.source != AWTEvent.root) {
                component = this.id == 505 ? null : AWTEvent.computeMouseTarget((Container)this.source, this.x, this.y);
                this.source = component;
                this.x -= AWTEvent.xMouseTgt;
                this.y -= AWTEvent.yMouseTgt;
            } else {
                Component component2 = component = this.id == 505 ? null : (Component)this.source;
            }
            if (component != AWTEvent.mouseTgt) {
                AWTEvent.transferMouse(this, AWTEvent.mouseTgt, AWTEvent.mousePos.x, AWTEvent.mousePos.y, component, this.x, this.y);
            }
            AWTEvent.mouseTgt = component;
            if (component == null) {
                AWTEvent.mousePos.y = 0;
                AWTEvent.mousePos.x = 0;
                this.source = null;
                return;
            }
            if (this.id == 503) {
                AWTEvent.processMouseMotionEvent(this);
            } else if (this.id == 501) {
                if (AWTEvent.mouseTgt != AWTEvent.keyTgt) {
                    AWTEvent.sendFocusEvent(component, true, true);
                }
                AWTEvent.buttonPressed = true;
                this.modifiers = MouseEvent.updateInputModifier(this.button, true);
                clicks = this.when - lastPressed < (long)AWTEvent.clickInterval ? ++clicks : 1;
                this.clickCount = clicks;
                lastPressed = this.when;
                AWTEvent.processMouseEvent(this);
            }
        }
        AWTEvent.mousePos.x = this.x;
        AWTEvent.mousePos.y = this.y;
        this.recycle();
    }

    public int getClickCount() {
        return this.clickCount;
    }

    static MouseEvent getMouseEvent(int n, int n2, int n3, int n4, int n5) {
        MouseEvent mouseEvent;
        Component component = AWTEvent.sources[n];
        long l = System.currentTimeMillis();
        Object object = AWTEvent.evtLock;
        synchronized (object) {
            try {
                if (AWTEvent.mouseEvtCache == null) {
                    mouseEvent = new MouseEvent(component, n2, l, AWTEvent.inputModifier, n4, n5, 0, n3 == 3);
                } else {
                    mouseEvent = AWTEvent.mouseEvtCache;
                    AWTEvent.mouseEvtCache = (MouseEvent)mouseEvent.next;
                    mouseEvent.next = null;
                    mouseEvent.source = component;
                    mouseEvent.id = n2;
                    mouseEvent.when = l;
                    mouseEvent.modifiers = AWTEvent.inputModifier;
                    mouseEvent.x = n4;
                    mouseEvent.y = n5;
                    mouseEvent.clickCount = 0;
                    mouseEvent.isPopupTrigger = n3 == 3;
                }
                Object var11_9 = null;
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                throw throwable;
            }
        }
        mouseEvent.button = n3;
        return mouseEvent;
    }

    public Point getPoint() {
        return new Point(this.x, this.y);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isPopupTrigger() {
        return this.isPopupTrigger;
    }

    public String paramString() {
        String string;
        switch (this.id) {
            case 501: {
                string = "MOUSE_PRESSED";
                break;
            }
            case 502: {
                string = "MOUSE_RELEASED";
                break;
            }
            case 500: {
                string = "MOUSE_CLICKED";
                break;
            }
            case 504: {
                string = "MOUSE_ENTERED";
                break;
            }
            case 505: {
                string = "MOUSE_EXITED";
                break;
            }
            case 503: {
                string = "MOUSE_MOVED";
                break;
            }
            case 506: {
                string = "MOUSE_DRAGGED";
                break;
            }
            default: {
                string = "unknown type";
            }
        }
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(string).concat(String.valueOf(",("))).concat(String.valueOf(this.x))).concat(String.valueOf(","))).concat(String.valueOf(this.y))).concat(String.valueOf(")"))).concat(String.valueOf(",mods="))).concat(String.valueOf(this.modifiers))).concat(String.valueOf(",clickCount="))).concat(String.valueOf(this.clickCount));
    }

    static void postMouseClicked(Object object, long l, int n, int n2, int n3, int n4, int n5) {
        MouseEvent mouseEvent = AWTEvent.getMouseEvent((Component)object, 500, l, n3, n, n2, n4, n5 == 3);
        mouseEvent.button = n5;
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(mouseEvent);
    }

    protected void recycle() {
        Object object = AWTEvent.evtLock;
        synchronized (object) {
            try {
                this.source = null;
                this.next = AWTEvent.mouseEvtCache;
                AWTEvent.mouseEvtCache = this;
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }
    }

    protected void setMouseEvent(long l, int n, int n2, int n3, int n4, boolean bl) {
        this.when = l;
        this.modifiers = n;
        this.x = n2;
        this.y = n3;
        this.clickCount = n4;
        this.isPopupTrigger = bl;
    }

    protected void setXY(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void translatePoint(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    static int updateInputModifier(int n, boolean bl) {
        if (bl) {
            switch (n) {
                case 1: {
                    AWTEvent.inputModifier |= 0x10;
                    break;
                }
                case 2: {
                    AWTEvent.inputModifier |= 8;
                    break;
                }
                case 3: {
                    AWTEvent.inputModifier |= 4;
                }
            }
        } else {
            switch (n) {
                case 1: {
                    AWTEvent.inputModifier &= 0xFFFFFFEF;
                    break;
                }
                case 2: {
                    AWTEvent.inputModifier &= 0xFFFFFFF7;
                    break;
                }
                case 3: {
                    AWTEvent.inputModifier &= 0xFFFFFFFB;
                }
            }
        }
        return AWTEvent.inputModifier;
    }
}

