/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Cursor;
import java.awt.Defaults;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.TextBuffer;
import java.awt.TextComponent;
import java.awt.TextCursor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class TextField
extends TextComponent
implements MouseMotionListener,
KeyListener,
FocusListener,
MouseListener {
    char echoChar;
    ActionListener aListener;
    int cols;
    FontMetrics fm;
    TextCursor tCursor = new TextCursor();
    static int xOffs = 2;
    int selStart;
    int selEnd;
    TextBuffer textBuf = new TextBuffer();
    TextBuffer hiddenBuf;
    int first;

    public TextField() {
        this("", 1);
    }

    public TextField(String string) {
        this(string, string != null ? string.length() : 1);
    }

    public TextField(String string, int n) {
        this.cols = n;
        this.cursor = Cursor.getPredefinedCursor(2);
        this.setFont(Defaults.TextFieldFont);
        this.setBackground(Defaults.TextFieldBgClr);
        this.setForeground(Defaults.TextFieldTxtClr);
        this.setText(string);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public TextField(int n) {
        this("", n);
    }

    public void addActionListener(ActionListener actionListener) {
        this.aListener = AWTEventMulticaster.add(this.aListener, actionListener);
        this.eventMask |= 0x80;
    }

    void blankSelection() {
        if (this.selStart != this.selEnd) {
            this.setTextCursor(this.selStart, true, false);
        }
    }

    public void deleteSelection() {
        if (this.selStart != this.selEnd) {
            this.textBuf.remove(this.selStart, this.selEnd - this.selStart);
            if (this.hiddenBuf != null) {
                this.hiddenBuf.remove(this.selStart, this.selEnd - this.selStart);
            }
            this.setTextCursor(this.selStart, true, false);
        }
    }

    public boolean echoCharIsSet() {
        return this.echoChar != '\u0000';
    }

    void extendSelectionTo(int n, boolean bl) {
        if (n < 0) {
            n = 0;
        } else if (n > this.textBuf.len) {
            n = this.textBuf.len;
        }
        if (n == this.tCursor.index) {
            return;
        }
        if (n < this.selStart) {
            this.selStart = n;
        } else if (n > this.selEnd) {
            this.selEnd = n;
        } else if (bl) {
            this.tCursor.index = this.selStart;
            this.selStart = n;
        } else {
            this.selEnd = n;
        }
        this.setTextCursor(n, false, true);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paintBorder(graphics);
            if (Defaults.ShowInactiveCursor) {
                this.paintInactiveCursor(graphics);
            } else {
                this.repaint(graphics, 0);
            }
            graphics.dispose();
        }
        if (this.selStart < this.selEnd) {
            this.copyToClipboard();
        }
    }

    TextBuffer getBuffer() {
        return this.hiddenBuf != null ? this.hiddenBuf : this.textBuf;
    }

    public int getCaretPosition() {
        return this.tCursor.index;
    }

    public int getColumns() {
        return this.cols;
    }

    int getCursorPos(TextBuffer textBuffer, int n) {
        if (n < 0) {
            n = 0;
        } else if (n > this.textBuf.len) {
            n = this.textBuf.len;
        }
        return 2 + xOffs + textBuffer.getWidth(this.first, n);
    }

    public char getEchoChar() {
        return this.echoChar;
    }

    public Dimension getMinimumSize(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        int n2 = n * fontMetrics.charWidth('x');
        int n3 = fontMetrics.getHeight() * 3 / 2;
        return new Dimension(n2, n3);
    }

    public Dimension getPreferredSize() {
        int n = 50;
        int n2 = 20;
        if (this.font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.font);
            n2 = Math.max(n2, 3 * fontMetrics.getHeight() / 2);
        }
        return new Dimension(n, n2);
    }

    public String getSelectedText() {
        if (this.selStart != this.selEnd) {
            return this.textBuf.getString(this.selStart, this.selEnd - this.selStart);
        }
        return null;
    }

    public int getSelectionEnd() {
        return this.selEnd;
    }

    public int getSelectionStart() {
        return this.selStart;
    }

    public String getText() {
        return this.textBuf.toString();
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        boolean bl = keyEvent.isShiftDown();
        int n2 = keyEvent.getKeyCode();
        if (this.handleClipboard(keyEvent)) {
            keyEvent.consume();
            return;
        }
        if (n != 0 && n != 1) {
            return;
        }
        switch (n2) {
            case 10: {
                this.notifyAction();
                break;
            }
            case 27: {
                this.setText("");
                break;
            }
            case 36: {
                if (bl) {
                    this.extendSelectionTo(0, false);
                    break;
                }
                this.setTextCursor(0, true, false);
                break;
            }
            case 35: {
                if (bl) {
                    this.extendSelectionTo(this.textBuf.len, true);
                    break;
                }
                this.setTextCursor(this.textBuf.len, true, false);
                break;
            }
            case 37: {
                if (bl) {
                    this.extendSelectionTo(this.tCursor.index - 1, false);
                    break;
                }
                this.shiftTextCursor(-1, true);
                break;
            }
            case 39: {
                if (bl) {
                    this.extendSelectionTo(this.tCursor.index + 1, true);
                    break;
                }
                this.shiftTextCursor(1, true);
                break;
            }
            case 8: {
                if (this.selStart != this.selEnd) {
                    this.deleteSelection();
                    break;
                }
                if (this.tCursor.index <= 0) break;
                this.textBuf.remove(this.tCursor.index - 1, 1);
                this.shiftTextCursor(-1, true);
                break;
            }
            case 127: {
                if (this.selStart != this.selEnd) {
                    this.deleteSelection();
                    break;
                }
                if (this.tCursor.index >= this.textBuf.len) break;
                this.textBuf.remove(this.tCursor.index, 1);
                this.repaintTrailing();
                break;
            }
            default: {
                return;
            }
        }
        keyEvent.consume();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (!this.isEditable || !this.isPrintableTyped(keyEvent)) {
            return;
        }
        char c = keyEvent.getKeyChar();
        if (this.selStart != this.selEnd) {
            this.textBuf.replace(this.selStart, this.selEnd - this.selStart, c);
            if (this.hiddenBuf != null) {
                this.hiddenBuf.replace(this.selStart, this.selEnd - this.selStart, this.echoChar);
            }
            this.setTextCursor(this.selStart + 1, true, false);
        } else {
            this.textBuf.insert(this.tCursor.index, c);
            if (this.hiddenBuf != null) {
                this.hiddenBuf.insert(this.tCursor.index, this.echoChar);
            }
            this.shiftTextCursor(1, true);
        }
        if (this.textListener != null) {
            TextComponent.tEvt.setSource(this);
            this.processTextEvent(TextComponent.tEvt);
        }
    }

    void makeVisible(int n) {
        int n2 = 2;
        TextBuffer textBuffer = this.getBuffer();
        int n3 = this.first;
        if (n < 0) {
            n = 0;
        } else if (n > textBuffer.len) {
            n = textBuffer.len;
        }
        if (n < this.first) {
            this.first = n;
        } else {
            int n4 = textBuffer.getPos(n);
            if (this.width > 0) {
                int n5 = this.width - 2 * n2 - 2 * xOffs - this.tCursor.width;
                while (n5 < n4 - textBuffer.getPos(this.first)) {
                    ++this.first;
                }
            }
        }
        if (this.first != n3) {
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        TextBuffer textBuffer = this.getBuffer();
        this.extendSelectionTo(n, (n = textBuffer.getIdxFrom(this.first, mouseEvent.getX() - xOffs - 2)) > this.tCursor.index);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        TextBuffer textBuffer = this.getBuffer();
        int n = textBuffer.getIdxFrom(this.first, mouseEvent.getX() - xOffs - 2);
        this.blankSelection();
        this.setTextCursor(n, true, false);
        this.requestFocus();
        if (mouseEvent.getModifiers() == 8) {
            this.pasteFromClipboard();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    void notifyAction() {
        if (this.hasToNotify(128, this.aListener)) {
            ActionEvent actionEvent = AWTEvent.getActionEvent(this, 1001);
            ((AWTEvent)actionEvent).setActionEvent(this.getText(), 0);
            Toolkit.eventQueue.postEvent(actionEvent);
        }
    }

    public void paint(Graphics graphics) {
        int n = 2;
        this.paintBorder(graphics);
        graphics.setColor(this.bgClr);
        graphics.fillRect(n, n, this.width - 2 * n, this.height - 2 * n);
        this.repaint(graphics, 0);
    }

    void paintInactiveCursor(Graphics graphics) {
        graphics.setColor(Defaults.TextCursorInactiveClr);
        this.tCursor.blank(graphics);
    }

    protected String paramString() {
        return super.paramString();
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        this.aListener.actionPerformed(actionEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (this.hasToNotify(128, this.aListener)) {
            this.processActionEvent((ActionEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.aListener = AWTEventMulticaster.remove(this.aListener, actionListener);
    }

    void repaint(Graphics graphics, TextBuffer textBuffer, int n, int n2, boolean bl) {
        int n3 = 2;
        if (n < this.first) {
            n = this.first;
        }
        int n4 = n3 + xOffs + textBuffer.getWidth(this.first, n);
        int n5 = n4 + textBuffer.getWidth(n, n2);
        if (bl) {
            graphics.setColor(Defaults.TextFieldSelBgClr);
            if (n2 == textBuffer.len) {
                n5 += this.tCursor.width;
            }
            graphics.fill3DRect(n4, this.tCursor.y, n5 - n4, this.tCursor.height + 1, true);
            graphics.setColor(Defaults.TextFieldSelTxtClr);
        } else {
            graphics.setColor(this.bgClr);
            if (n2 == textBuffer.len) {
                n5 = this.width - n3 - xOffs;
            }
            graphics.fillRect(n4, this.tCursor.y, n5 - n4, this.tCursor.height + 1);
            graphics.setColor(this.fgClr);
        }
        textBuffer.paintFrom(graphics, n3 + xOffs, 0, this.height, this.first, n, n2 - n);
    }

    void repaint(Graphics graphics, int n) {
        int n2 = 2;
        TextBuffer textBuffer = this.getBuffer();
        graphics.clipRect(n2 + xOffs, n2, this.width - 2 * n2 - 2 * xOffs, this.height - 2 * n2);
        graphics.setFont(this.font);
        if (n > 0) {
            --n;
        }
        if (this.selStart == this.selEnd || n > this.selEnd) {
            this.repaint(graphics, textBuffer, n, textBuffer.len, false);
        } else {
            if (this.selStart > n) {
                this.repaint(graphics, textBuffer, n, this.selStart, false);
            }
            if (this.selEnd > n) {
                this.repaint(graphics, textBuffer, Math.max(this.selStart, n), this.selEnd, true);
            }
            if (this.textBuf.len > this.selEnd) {
                this.repaint(graphics, textBuffer, this.selEnd, this.textBuf.len, false);
            }
        }
        if (AWTEvent.keyTgt == this) {
            this.tCursor.paint(graphics);
        } else if (Defaults.ShowInactiveCursor) {
            this.paintInactiveCursor(graphics);
        }
    }

    void repaint(int n) {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.repaint(graphics, n);
            graphics.dispose();
        }
    }

    void repaintTrailing() {
        this.repaint(this.tCursor.index);
    }

    void replaceSelectionWith(String string) {
        this.deleteSelection();
        this.textBuf.insert(this.selEnd, string);
        this.selEnd = this.selStart = this.selEnd + string.length();
        this.setCaretPosition(this.selStart);
        this.repaint();
    }

    void resetSelIdxs(int n) {
        this.selStart = n;
        this.selEnd = n;
    }

    public void select(int n, int n2) {
        this.selStart = n;
        this.selEnd = n2;
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void selectAll() {
        this.select(0, this.textBuf.len);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        int n5 = this.fm.getHeight();
        this.tCursor.setPos((n4 - n5) / 2, n5);
        super.setBounds(n, n2, n3, n4);
    }

    public void setCaretPosition(int n) {
        this.setTextCursor(n, true, false);
    }

    public void setColumns(int n) {
        if (this.cols != n) {
            this.cols = n;
        }
    }

    public void setEchoChar(char c) {
        this.echoChar = c;
        if (c != '\u0000') {
            if (this.hiddenBuf == null) {
                this.hiddenBuf = new TextBuffer();
                this.hiddenBuf.setMetrics(this.fm, 20);
            }
            this.hiddenBuf.set(c, this.textBuf.len);
        } else {
            this.hiddenBuf = null;
        }
        this.setTextCursor(this.tCursor.index, false, true);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(font);
        this.textBuf.setMetrics(this.fm, 20);
        if (this.hiddenBuf != null) {
            this.hiddenBuf.setMetrics(this.fm, 20);
        }
        int n = this.fm.getHeight();
        TextBuffer textBuffer = this.hiddenBuf != null ? this.hiddenBuf : this.textBuf;
        this.tCursor.setPos((this.height - n) / 2, n);
        this.tCursor.setIndex(this.tCursor.index, this.getCursorPos(textBuffer, this.tCursor.index));
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void setSelectionEnd(int n) {
        this.select(this.selStart, n);
    }

    public void setSelectionStart(int n) {
        this.select(n, this.selEnd);
    }

    public void setText(String string) {
        this.textBuf.set(string);
        if (this.hiddenBuf != null) {
            this.hiddenBuf.set(this.echoChar, string.length());
        }
        this.setTextCursor(0, true, false);
    }

    protected void setTextCursor(int n, boolean bl, boolean bl2) {
        int n2 = 0;
        int n3 = 2;
        TextBuffer textBuffer = this.getBuffer();
        if (n > textBuffer.len) {
            n = textBuffer.len;
        } else if (n < 0) {
            n = 0;
        }
        this.makeVisible(n);
        if (bl) {
            n2 = Math.min(this.selStart, n);
            this.resetSelIdxs(n);
        } else if (!bl2) {
            n2 = Math.min(n, this.tCursor.index);
        }
        this.tCursor.setIndex(n, this.getCursorPos(textBuffer, n));
        this.repaint(n2);
    }

    protected void shiftTextCursor(int n, boolean bl) {
        if (this.tCursor.index + n < 0) {
            this.setTextCursor(0, bl, false);
        } else if (this.tCursor.index + n > this.textBuf.len) {
            this.setTextCursor(this.textBuf.len, bl, false);
        } else {
            this.setTextCursor(this.tCursor.index + n, bl, false);
        }
    }
}

