/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Defaults;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.EventListener;
import java.util.Vector;

public class MenuItem
extends MenuComponent {
    MenuShortcut shortcut;
    String label;
    ActionListener aListener;
    String aCmd;
    boolean isEnabled = true;
    static MenuItem separator = new MenuItem("-");

    public MenuItem() {
        this(null, null);
    }

    public MenuItem(String string) {
        this(string, null);
    }

    public MenuItem(String string, MenuShortcut menuShortcut) {
        this.setShortcut(menuShortcut);
        this.setLabel(string);
        this.setFont(MenuComponent.defFnt);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (!this.isSeparator()) {
            this.aListener = AWTEventMulticaster.add(this.aListener, actionListener);
        }
    }

    public void addNotify() {
    }

    Vector addShortcuts(Vector vector) {
        if (this.shortcut != null) {
            vector.addElement(this.shortcut);
        }
        return vector;
    }

    public void deleteShortcut() {
        this.shortcut = null;
    }

    public String getActionCommand() {
        return this.aCmd != null ? this.aCmd : this.label;
    }

    int getHeight() {
        return this.isSeparator() ? 4 : this.fm.getHeight() + 4;
    }

    public String getLabel() {
        return this.label;
    }

    public MenuShortcut getShortcut() {
        return this.shortcut;
    }

    MenuItem getShortcutMenuItem(MenuShortcut menuShortcut) {
        if (menuShortcut.equals(this.shortcut)) {
            return this;
        }
        return null;
    }

    int getWidth() {
        return this.fm.stringWidth(this.label);
    }

    boolean handleShortcut(KeyEvent keyEvent) {
        if (this.shortcut == null) {
            return false;
        }
        if (this.shortcut.key != keyEvent.getKeyChar() + 96) {
            return false;
        }
        this.process();
        return true;
    }

    boolean hasToNotify(EventListener eventListener) {
        return this.isEnabled && eventListener != null;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isSeparator() {
        return separator == this;
    }

    int paint(Graphics graphics, int n, int n2, int n3, Color color, Color color2, boolean bl) {
        int n4 = this.getHeight();
        int n5 = this.fm.getAscent();
        if (separator == this) {
            int n6 = n2 + n4 / 2;
            graphics.setColor(color);
            graphics.draw3DRect(5, n6 - 1, n3 - 10, 1, false);
        } else {
            graphics.setFont(this.fnt);
            if (this.isEnabled) {
                if (Defaults.MenuTxtCarved) {
                    graphics.setColor(Color.white);
                    graphics.drawString(this.label, n + 1, n2 + n5 + 1);
                }
                graphics.setColor(bl ? Defaults.FocusClr : color2);
            } else {
                graphics.setColor(color.darker());
            }
            graphics.drawString(this.label, n, n2 + n5);
        }
        return n4;
    }

    public String paramString() {
        return String.valueOf(String.valueOf(String.valueOf(this.getClass().getName()).concat(String.valueOf("[Label: "))).concat(String.valueOf(this.label))).concat(String.valueOf("]"));
    }

    void process() {
        if (this.hasToNotify(this.aListener)) {
            ActionEvent actionEvent = AWTEvent.getActionEvent(this, 1001);
            ((AWTEvent)actionEvent).setActionEvent(this.getActionCommand(), 0);
            Toolkit.eventQueue.postEvent(actionEvent);
        } else if (this.parent instanceof Menu) {
            Menu menu = (Menu)this.parent;
            while (menu != null) {
                if (menu.hasToNotify(menu.aListener)) {
                    ActionEvent actionEvent = AWTEvent.getActionEvent(menu, 1001);
                    ((AWTEvent)actionEvent).setActionEvent(this.getActionCommand(), 0);
                    Toolkit.eventQueue.postEvent(actionEvent);
                    return;
                }
                menu = (Menu)menu.parent;
            }
        }
    }

    void processActionEvent(ActionEvent actionEvent) {
        this.aListener.actionPerformed(actionEvent);
    }

    void processActionEvent_X(ActionEvent actionEvent) {
        ActionListener actionListener = this.aListener;
        if (actionListener == null) {
            MenuContainer menuContainer = this.parent;
            while (actionListener == null && menuContainer instanceof Menu) {
                Menu menu = (Menu)menuContainer;
                actionListener = menu.aListener;
                menuContainer = menu.parent;
            }
        }
        if (actionListener != null) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.aListener = AWTEventMulticaster.remove(this.aListener, actionListener);
    }

    public void setActionCommand(String string) {
        this.aCmd = string;
    }

    public synchronized void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public synchronized void setLabel(String string) {
        this.label = string;
    }

    public void setShortcut(MenuShortcut menuShortcut) {
        if (!this.isSeparator()) {
            this.shortcut = menuShortcut;
        }
    }
}

