/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTrackerEntry;
import java.io.Serializable;

public class MediaTracker
implements Serializable {
    private MediaTrackerEntry images;
    public static final int LOADING = 1;
    public static final int ABORTED = 2;
    public static final int ERRORED = 4;
    public static final int COMPLETED = 8;
    static final int LOADED = 160;

    public MediaTracker(Component component) {
    }

    public void addImage(Image image, int n) {
        this.addImage(image, n, -1, -1);
    }

    public synchronized void addImage(Image image, int n, int n2, int n3) {
        MediaTrackerEntry mediaTrackerEntry = new MediaTrackerEntry(image, n, n2, n3);
        mediaTrackerEntry.next = this.images;
        this.images = mediaTrackerEntry;
    }

    public boolean checkAll() {
        return this.checkAll(false);
    }

    public synchronized boolean checkAll(boolean bl) {
        MediaTrackerEntry mediaTrackerEntry = this.images;
        while (mediaTrackerEntry != null) {
            if ((Image.checkImage(mediaTrackerEntry.img, mediaTrackerEntry.w, mediaTrackerEntry.h, mediaTrackerEntry, bl) & 0xA0) == 0) {
                return false;
            }
            mediaTrackerEntry = mediaTrackerEntry.next;
        }
        return true;
    }

    public boolean checkID(int n) {
        return this.checkID(n, false);
    }

    public synchronized boolean checkID(int n, boolean bl) {
        MediaTrackerEntry mediaTrackerEntry = this.getNextEntry(n, null);
        while (mediaTrackerEntry != null) {
            if ((Image.checkImage(mediaTrackerEntry.img, mediaTrackerEntry.w, mediaTrackerEntry.h, mediaTrackerEntry, bl) & 0xA0) == 0) {
                return false;
            }
            mediaTrackerEntry = this.getNextEntry(n, mediaTrackerEntry);
        }
        return true;
    }

    public synchronized Object[] getErrorsAny() {
        return null;
    }

    public synchronized Object[] getErrorsID(int n) {
        return null;
    }

    MediaTrackerEntry getNextEntry(int n, MediaTrackerEntry mediaTrackerEntry) {
        MediaTrackerEntry mediaTrackerEntry2;
        MediaTrackerEntry mediaTrackerEntry3 = mediaTrackerEntry2 = mediaTrackerEntry != null ? mediaTrackerEntry.next : this.images;
        while (mediaTrackerEntry2 != null) {
            if (mediaTrackerEntry2.id == n) {
                return mediaTrackerEntry2;
            }
            mediaTrackerEntry2 = mediaTrackerEntry2.next;
        }
        return null;
    }

    public synchronized boolean isErrorAny() {
        return false;
    }

    public synchronized boolean isErrorID(int n) {
        return false;
    }

    public synchronized void removeImage(Image image) {
        MediaTrackerEntry mediaTrackerEntry = null;
        MediaTrackerEntry mediaTrackerEntry2 = this.images;
        while (mediaTrackerEntry2 != null) {
            if (mediaTrackerEntry2.img == image) {
                if (mediaTrackerEntry != null) {
                    mediaTrackerEntry.next = mediaTrackerEntry2.next;
                    continue;
                }
                this.images = mediaTrackerEntry2.next;
                continue;
            }
            mediaTrackerEntry = mediaTrackerEntry2;
            mediaTrackerEntry2 = mediaTrackerEntry2.next;
        }
    }

    public synchronized void removeImage(Image image, int n) {
        MediaTrackerEntry mediaTrackerEntry = null;
        MediaTrackerEntry mediaTrackerEntry2 = this.images;
        while (mediaTrackerEntry2 != null) {
            if (mediaTrackerEntry2.img == image && mediaTrackerEntry2.id == n) {
                if (mediaTrackerEntry != null) {
                    mediaTrackerEntry.next = mediaTrackerEntry2.next;
                    continue;
                }
                this.images = mediaTrackerEntry2.next;
                continue;
            }
            mediaTrackerEntry = mediaTrackerEntry2;
            mediaTrackerEntry2 = mediaTrackerEntry2.next;
        }
    }

    public synchronized void removeImage(Image image, int n, int n2, int n3) {
        MediaTrackerEntry mediaTrackerEntry = null;
        MediaTrackerEntry mediaTrackerEntry2 = this.images;
        while (mediaTrackerEntry2 != null) {
            if (mediaTrackerEntry2.img == image && mediaTrackerEntry2.id == n && mediaTrackerEntry2.w == n2 && mediaTrackerEntry2.h == n3) {
                if (mediaTrackerEntry != null) {
                    mediaTrackerEntry.next = mediaTrackerEntry2.next;
                    continue;
                }
                this.images = mediaTrackerEntry2.next;
                continue;
            }
            mediaTrackerEntry = mediaTrackerEntry2;
            mediaTrackerEntry2 = mediaTrackerEntry2.next;
        }
    }

    public synchronized int statusAll(boolean bl) {
        int n = 0;
        MediaTrackerEntry mediaTrackerEntry = this.images;
        while (mediaTrackerEntry != null) {
            int n2 = Image.checkImage(mediaTrackerEntry.img, mediaTrackerEntry.w, mediaTrackerEntry.h, mediaTrackerEntry, bl);
            if ((n2 & 0x20) != 0) {
                n |= 8;
            } else if ((n2 & 0x80) != 0) {
                n |= 2;
            } else if ((n2 & 0x100) != 0) {
                n |= 1;
            }
            if ((n2 & 0x40) != 0) {
                n |= 4;
            }
            mediaTrackerEntry = mediaTrackerEntry.next;
        }
        return n;
    }

    public synchronized int statusID(int n, boolean bl) {
        int n2 = 0;
        MediaTrackerEntry mediaTrackerEntry = this.getNextEntry(n, null);
        while (mediaTrackerEntry != null) {
            int n3 = Image.checkImage(mediaTrackerEntry.img, mediaTrackerEntry.w, mediaTrackerEntry.h, mediaTrackerEntry, bl);
            if ((n3 & 0x20) != 0) {
                n2 |= 8;
            } else if ((n3 & 0x80) != 0) {
                n2 |= 2;
            } else if ((n3 & 0x100) != 0) {
                n2 |= 1;
            }
            if ((n3 & 0x40) != 0) {
                n2 |= 4;
            }
            mediaTrackerEntry = this.getNextEntry(n, mediaTrackerEntry);
        }
        return n2;
    }

    public synchronized void waitForAll() throws InterruptedException {
        MediaTrackerEntry mediaTrackerEntry = this.images;
        while (mediaTrackerEntry != null) {
            if ((Image.checkImage(mediaTrackerEntry.img, mediaTrackerEntry.w, mediaTrackerEntry.h, mediaTrackerEntry, true) & 0xA0) == 0) {
                MediaTrackerEntry mediaTrackerEntry2 = mediaTrackerEntry;
                synchronized (mediaTrackerEntry2) {
                    Object var4_3;
                    try {
                        mediaTrackerEntry.wait();
                        var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        var4_3 = null;
                        throw throwable;
                    }
                }
            }
            mediaTrackerEntry = mediaTrackerEntry.next;
        }
    }

    public synchronized boolean waitForAll(long l) throws InterruptedException {
        long l2 = System.currentTimeMillis();
        long l3 = l2 + l;
        MediaTrackerEntry mediaTrackerEntry = this.images;
        while (mediaTrackerEntry != null) {
            if (l2 > l3) {
                return false;
            }
            if ((Image.checkImage(mediaTrackerEntry.img, mediaTrackerEntry.w, mediaTrackerEntry.h, mediaTrackerEntry, true) & 0xA0) == 0) {
                MediaTrackerEntry mediaTrackerEntry2 = mediaTrackerEntry;
                synchronized (mediaTrackerEntry2) {
                    Object var10_6;
                    try {
                        mediaTrackerEntry.wait(l);
                        var10_6 = null;
                    }
                    catch (Throwable throwable) {
                        var10_6 = null;
                        throw throwable;
                    }
                }
            }
            l2 = System.currentTimeMillis();
            mediaTrackerEntry = mediaTrackerEntry.next;
        }
        return true;
    }

    public synchronized void waitForID(int n) throws InterruptedException {
        MediaTrackerEntry mediaTrackerEntry = this.getNextEntry(n, null);
        while (mediaTrackerEntry != null) {
            if ((Image.checkImage(mediaTrackerEntry.img, mediaTrackerEntry.w, mediaTrackerEntry.h, mediaTrackerEntry, true) & 0xA0) == 0) {
                MediaTrackerEntry mediaTrackerEntry2 = mediaTrackerEntry;
                synchronized (mediaTrackerEntry2) {
                    Object var5_4;
                    try {
                        mediaTrackerEntry.wait();
                        var5_4 = null;
                    }
                    catch (Throwable throwable) {
                        var5_4 = null;
                        throw throwable;
                    }
                }
            }
            mediaTrackerEntry = this.getNextEntry(n, mediaTrackerEntry);
        }
    }

    public synchronized boolean waitForID(int n, long l) throws InterruptedException {
        long l2 = System.currentTimeMillis();
        long l3 = l2 + l;
        MediaTrackerEntry mediaTrackerEntry = this.getNextEntry(n, null);
        while (mediaTrackerEntry != null) {
            if (l2 > l3) {
                return false;
            }
            if ((Image.checkImage(mediaTrackerEntry.img, mediaTrackerEntry.w, mediaTrackerEntry.h, mediaTrackerEntry, true) & 0xA0) == 0) {
                MediaTrackerEntry mediaTrackerEntry2 = mediaTrackerEntry;
                synchronized (mediaTrackerEntry2) {
                    Object var11_7;
                    try {
                        mediaTrackerEntry.wait(l);
                        var11_7 = null;
                    }
                    catch (Throwable throwable) {
                        var11_7 = null;
                        throw throwable;
                    }
                }
            }
            l2 = System.currentTimeMillis();
            mediaTrackerEntry = this.getNextEntry(n, mediaTrackerEntry);
        }
        return true;
    }
}

