/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class GridLayout
implements LayoutManager {
    int cols;
    int rows;
    int hgap;
    int vgap;

    public GridLayout() {
        this(1, 1, 0, 0);
    }

    public GridLayout(int n, int n2) {
        this(n, n2, 0, 0);
    }

    public GridLayout(int n, int n2, int n3, int n4) {
        this.rows = n;
        this.cols = n2;
        this.hgap = n3;
        this.vgap = n4;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    Dimension adjustDim(Container container) {
        Dimension dimension = new Dimension(this.cols, this.rows);
        boolean bl = true;
        while (container.nChildren > dimension.width * dimension.height) {
            if (bl) {
                ++dimension.width;
            } else {
                ++dimension.height;
            }
            bl = !bl;
        }
        return dimension;
    }

    public int getColumns() {
        return this.cols;
    }

    public int getHgap() {
        return this.hgap;
    }

    Dimension getLayoutSize(Container container, boolean bl) {
        Object object;
        int n = 0;
        int n2 = 0;
        Dimension dimension = this.adjustDim(container);
        for (int i = 0; i < container.nChildren; ++i) {
            object = container.children[i];
            Dimension dimension2 = bl ? ((Component)object).getPreferredSize() : ((Component)object).getMinimumSize();
            n = Math.max(n, dimension2.width);
            n2 = Math.max(n2, dimension2.height);
        }
        object = container.insets;
        return new Dimension(((Insets)object).left + ((Insets)object).right + n * dimension.width + this.hgap * (dimension.width + 1), ((Insets)object).top + ((Insets)object).bottom + n2 * dimension.height + this.vgap * (dimension.height + 1));
    }

    public int getRows() {
        return this.rows;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void layoutContainer(Container container) {
        int n;
        Insets insets = container.insets;
        int n2 = container.width - insets.left - insets.right - this.hgap;
        int n3 = container.height - insets.top - insets.bottom - this.vgap;
        Dimension dimension = this.adjustDim(container);
        int n4 = n2 / dimension.width;
        int n5 = n3 / dimension.height;
        int n6 = n = insets.left + this.hgap;
        int n7 = insets.top + this.vgap;
        int n8 = 0;
        for (int i = 0; i < container.nChildren; ++i) {
            Component component = container.children[i];
            component.setBounds(n6, n7, n4 - this.hgap, n5 - this.hgap);
            if (n8 == dimension.width - 1) {
                n8 = 0;
                n6 = n;
                n7 += n5;
                continue;
            }
            ++n8;
            n6 += n4;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(container, false);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(container, true);
    }

    public void removeLayoutComponent(Component component) {
    }

    public void setColumns(int n) {
        this.cols = n;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public void setRows(int n) {
        this.rows = n;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("GridLayout: rows: ").concat(String.valueOf(this.rows))).concat(String.valueOf(",cols: "))).concat(String.valueOf(this.cols))).concat(String.valueOf(",hgap: "))).concat(String.valueOf(this.hgap))).concat(String.valueOf(",vgap: "))).concat(String.valueOf(this.vgap));
    }
}

