/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Defaults;
import java.awt.Toolkit;
import java.awt.peer.FontPeer;
import java.util.Hashtable;
import kaffe.util.Ptr;

public class Font {
    Ptr nativeData;
    protected String name;
    protected int style;
    protected int size;
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    static Hashtable nativeSpecs = new Hashtable();

    public Font(String string, int n, int n2) {
        this.name = string;
        this.style = n;
        this.size = n2;
        Object object = nativeSpecs.get(this.name);
        String string2 = object != null ? (String)object : this.name;
        this.nativeData = Toolkit.fntInitFont(string2, this.style, this.size);
    }

    public static Font decode(String string) {
        int n = 0;
        int n2 = 12;
        int n3 = 0;
        String string2 = string;
        int n4 = string.indexOf(45);
        if (n4 >= 0) {
            string2 = string.substring(0, n4);
            if (string.regionMatches(true, ++n4, "bold-", 0, 5)) {
                n = 1;
                n3 = 5;
            } else if (string.regionMatches(true, n4, "italic-", 0, 7)) {
                n = 2;
                n3 = 7;
            } else if (string.regionMatches(true, n4, "bolditalic-", 0, 11)) {
                n = 3;
                n3 = 11;
            }
            if (n3 > 0) {
                char c;
                n4 += 11;
                n2 = 0;
                int n5 = string.length();
                while (n4 < n5 && (c = string.charAt(n4)) >= '0' && c <= '9') {
                    n2 = n2 * 10 + (c - 48);
                    ++n4;
                }
            }
        }
        Font font = new Font(string2, n, n2);
        return font;
    }

    public boolean equals(Object object) {
        if (object instanceof Font) {
            Font font = (Font)object;
            if (!font.name.equals(this.name)) {
                return false;
            }
            if (font.style != this.style) {
                return false;
            }
            return font.size == this.size;
        }
        return false;
    }

    protected void finalize() {
        if (this.nativeData != null) {
            Toolkit.fntFreeFont(this.nativeData);
            this.nativeData = null;
        }
    }

    public String getFamily() {
        return null;
    }

    public static Font getFont(String string) {
        return Font.getFont(string, null);
    }

    public static Font getFont(String string, Font font) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            return Font.decode(string2);
        }
        return font;
    }

    public String getName() {
        return this.name;
    }

    public FontPeer getPeer() {
        return null;
    }

    public int getSize() {
        return this.size;
    }

    public int getStyle() {
        return this.style;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.style ^ this.size;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public String toString() {
        String string = "";
        if (this.style == 0) {
            string = "plain";
        } else {
            if ((this.style & 1) != 0) {
                string = "bold";
            }
            if ((this.style & 2) != 0) {
                string = String.valueOf(string).concat(String.valueOf("italic"));
            }
        }
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.getClass().getName()).concat(String.valueOf(" ["))).concat(String.valueOf(this.name))).concat(String.valueOf(','))).concat(String.valueOf(string))).concat(String.valueOf(','))).concat(String.valueOf(this.size))).concat(String.valueOf(']'));
    }

    static {
        nativeSpecs.put("Default", Defaults.FsDefault);
        nativeSpecs.put("Monospaced", Defaults.FsMonospaced);
        nativeSpecs.put("SansSerif", Defaults.FsSansSerif);
        nativeSpecs.put("Serif", Defaults.FsSerif);
        nativeSpecs.put("Dialog", Defaults.FsDialog);
        nativeSpecs.put("DialogInput", Defaults.FsDialogInput);
        nativeSpecs.put("ZapfDingbats", Defaults.FsZapfDingbats);
        nativeSpecs.put("Helvetica", Defaults.FsSansSerif);
        nativeSpecs.put("TimesRoman", Defaults.FsSerif);
        nativeSpecs.put("Courier", Defaults.FsMonospaced);
    }
}

