/* machine.h
 *
 * Copyright (c) 1996, 1997
 *	Transvirtual Technologies, Inc.  All rights reserved.
 *
 * See the file "license.terms" for information on usage and redistribution 
 * of this file. 
 */

#ifndef __machine_h
#define __machine_h

/* -------------------------------------------------------------------- */

/* Instructions */
#define	define_insn(code)	break;					\
				case code :
#define	define_insn_alias(code)	case code :
#define	define_wide_insn(code)	break;					\
				case code :

/* Stack */
#define	push(_i)		stackno -= (_i)
#define	pop(_i)			lastuse_slot(stack(0), (_i));		\
				stackno += (_i)

/* PC */
#define	getopcode()		((int)base[pc])
#define	getpc(_p)		base[pc+1+(_p)]
#define	getcode(_p)		base[(_p)]
#define	adjustpc(_p)		npc = pc + (_p)

#define current_class()		(xmeth->class)

/* -------------------------------------------------------------------- */
/* Methods */

#define	get_method_info_noerror(IDX) \
	getMethodSignatureClass(IDX, xmeth->class, true, 0, &cinfo, einfo)

#define get_special_method_info_noerror(IDX) \
	getMethodSignatureClass(IDX, xmeth->class, true, 1, &cinfo, einfo)

#define	get_interface_method_info_noerror(IDX) \
	getMethodSignatureClass(IDX, xmeth->class, true, 2, &cinfo, einfo)

#define	get_method_info(IDX) \
	if (getMethodSignatureClass(IDX, xmeth->class, true, 0, &cinfo, einfo) == false) { success = false; goto done; }

#define get_special_method_info(IDX) \
	if (getMethodSignatureClass(IDX, xmeth->class, true, 1, &cinfo, einfo) == false) { success = false; goto done; }

#define	get_interface_method_info(IDX) \
	if (getMethodSignatureClass(IDX, xmeth->class, true, 2, &cinfo, einfo) == false) { success = false; goto done; }

#define	method_name()	(cinfo.name)
#define	method_sig()	(cinfo.signature)
#define	method_idx()	(cinfo.method->idx)
#define method_method()	(cinfo.method)
#define method_class()  (cinfo.class)
#define method_classname()  (cinfo.cname)
#define	get_dispatch_table(mtable)				\
			move_ref_const(mtable, cinfo.class->dtable)

#define	method_nargs()		(cinfo.in)
#define	method_dtable_offset	(OBJECT_DTABLE_OFFSET)
#define	method_returntype()	(cinfo.rettype)

/* -------------------------------------------------------------------- */
/* Fields */

#define	get_field_info(IDX) \
	if (getField((constIndex)(IDX), xmeth->class, false, &finfo, einfo) == false) { \
		success = false ; goto done; \
	}

#define	get_static_field_info(IDX) \
	if (getField((constIndex)(IDX), xmeth->class, true, &finfo, einfo) == false) { \
		success = false ; goto done; \
	}

#define field_class()		(finfo.class)
#define field_field()		(finfo.field)
#define field_name()		(finfo.name)
#define field_classname()	(finfo.cname)
#define field_sig()		(finfo.signature)
#define field_static_data()	((finfo.class)->sdata)

/* -------------------------------------------------------------------- */
/* Classes */

#define	get_class_info_noerror(IDX) \
	crinfo = getClass((IDX), xmeth->class, einfo)

#define	get_class_info(IDX) \
	crinfo = getClass((IDX), xmeth->class, einfo); \
	if (crinfo == 0) { \
		success = false; goto done; \
	}

#define	class_object()		(crinfo)
#define class_name(IDX)		(WORD2UTF(xmeth->class->constants.data[IDX]))

/* -------------------------------------------------------------------- */
/* Objects */

#define	object_array_offset	(ARRAY_DATA_OFFSET)
#define	object_array_length	(ARRAY_SIZE_OFFSET)

/* -------------------------------------------------------------------- */
/* Switches */

#define	switchpair_size		8
#define	switchpair_addr		4
#define	switchtable_shift	2

/* Provide write barrier support for incremental GC */
#if defined(GC_INCREMENTAL)
#define	SOFT_ADDREFERENCE(_f, _t)	 softcall_writeref(_f, _t)
#define	SOFT_ADDREFERENCE_STATIC(_f, _t) softcall_writeref_static(_f, _t)
#else
#define	SOFT_ADDREFERENCE(_f, _t)
#define	SOFT_ADDREFERENCE_STATIC(_f, _t)
#endif

typedef struct {
	bool ANY;
        bool BADARRAYINDEX;
} jitflags;

#include "locks.h"
extern iLock* translatorlock;

#define	enterTranslator()	lockStaticMutex(&translatorlock)
#define	leaveTranslator()	unlockStaticMutex(&translatorlock)

extern jitflags willcatch;
extern struct codeinfo* codeInfo;
#if defined(KAFFE_PROFILER)
extern int profFlag;
extern Method* globalMethod;
#endif

typedef struct _nativeCodeInfo {
	void*   mem;
	int     memlen;
	void*   code;
	int     codelen;
} nativeCodeInfo;

#define	willCatch(FLAG)	willcatch.##FLAG = true
#define	canCatch(FLAG)	willcatch.##FLAG

void setupGlobalRegisters(void);
void setupArgumentRegisters(void);

/* Desktop edition */
#define	compile_time_error(EINFO) { \
	*einfo = (EINFO); \
	success = false ; \
	goto done; \
}

/*
 * Various methods exported by machine.c
 */
struct SlotData;
struct _label_;
struct _sequence;
struct _errorInfo;
extern jboolean initInsnSequence(Method *meth, int codesize, int localsz, int stacksz, struct _errorInfo *einfo);
extern jboolean finishInsnSequence(void*, nativeCodeInfo*, struct _errorInfo*);
extern void     installMethodCode(void*, Method*, nativeCodeInfo*);
extern struct _label_* newFakeCall(void*, uintp);
extern void 	doSpill(struct _sequence*);
extern void 	doReload(struct _sequence*);
extern struct SlotData** createSpillMask(void);
extern void     slotAlias(struct _sequence*);
extern void     startInsn(struct _sequence*);
extern jboolean translate(Method* xmeth, struct _errorInfo* einfo);

/*
 * Some global variables used by the translater which we must export.
 */
extern uint32 pc;
extern uint32 npc;
extern int maxPush;
extern int maxArgs;
extern int maxTemp;
extern int maxLocal;
extern int maxStack;
extern int isStatic;
extern nativecode* codeblock;
extern uintp CODEPC;

#if GUARANA
#define	softcall_new(r, t)			softcall_new_((r), (t), xmeth)
#define	softcall_newarray(r, s, t)		softcall_newarray_((r), (s), (t), xmeth)
#define	softcall_anewarray(r, s, t)		softcall_anewarray_((r), (s), (t), xmeth)
#define	softcall_multianewarray(r, z, s, t)	softcall_multianewarray_((r), (z), (s), (t), xmeth)

#define build_call_frame(sig, obj, sp) build_call_frame_guarana((sig), (obj), (sp), 0)

#if defined(PUSHARG_FORWARDS)
#define push_args_for_reify_method_invocation(method) do { \
  if (method_method()->accflags & ACC_STATIC) { \
    pusharg_ref((method), 0); \
    pusharg_ref_const(0, 1); \
    build_call_frame_guarana(method_sig(), 0, idx, 2); \
  } else { \
    pusharg_ref((method), 0); \
    build_call_frame_guarana(method_sig(), stack(idx), idx, 1); \
  } \
} while (0)
#else  
#define push_args_for_reify_method_invocation(method) do { \
  if (method_method()->accflags & ACC_STATIC) { \
    build_call_frame_guarana(method_sig(), 0, idx, 2); \
    pusharg_ref_const(0, 1); \
    pusharg_ref((method), 0); \
  } else { \
    build_call_frame_guarana(method_sig(), stack(idx), idx, 1); \
    pusharg_ref((method), 0); \
  } \
} while (0)
#endif

#define softcall_reify_method_invocation(method) do { \
  begin_func_sync(); \
  push_args_for_reify_method_invocation(method); \
  switch (low) { \
  case 'V': \
    call_soft(jvoid_reify_method_invocation); \
    break; \
  case 'L': \
  case '[': \
    call_soft(jref_reify_method_invocation); \
    break; \
  case 'Z': \
    call_soft(jboolean_reify_method_invocation); \
    break; \
  case 'C': \
    call_soft(jchar_reify_method_invocation); \
    break; \
  case 'B': \
    call_soft(jbyte_reify_method_invocation); \
    break; \
  case 'S': \
    call_soft(jshort_reify_method_invocation); \
    break; \
  case 'I': \
    call_soft(jint_reify_method_invocation); \
    break; \
  case 'J': \
    call_soft(jlong_reify_method_invocation); \
    break; \
  case 'F': \
    call_soft(jfloat_reify_method_invocation); \
    break; \
  case 'D': \
    call_soft(jdouble_reify_method_invocation); \
    break; \
  default: \
    ABORT(); \
  } \
  popargs(); \
  end_func_sync(); \
} while (0)

#if defined(PUSHARG_FORWARDS)
#define push_arg_for_reify_field_load(obj) do { \
  pusharg_ref((obj), 0); \
  pusharg_ref_const(finfo.class, 1); \
  pusharg_ref_const(finfo.field, 2); \
} while (0)
#else
#define push_arg_for_reify_field_load(obj) do { \
  pusharg_ref_const(finfo.field, 2); \
  pusharg_ref_const(finfo.class, 1); \
  pusharg_ref((obj), 0); \
} while (0)
#endif

#define softcall_reify_field_load(obj) do { \
  void *func = 0; SlotInfo *slot = 0; void (*retfunc)(SlotInfo *) = 0; \
  begin_func_sync(); \
  push_arg_for_reify_field_load(obj); \
  if (!FIELD_ISPRIM(finfo.field)) { \
    func = jref_reify_field_load; slot = wstack(0); retfunc = return_ref; \
  } else switch (CLASS_PRIM_SIG(FIELD_TYPE(finfo.field))) { \
  case 'Z': \
    func = jboolean_reify_field_load; slot = wstack(0); retfunc = return_int; \
    break; \
  case 'C': \
    func = jchar_reify_field_load; slot = wstack(0); retfunc = return_int; \
    break; \
  case 'B': \
    func = jbyte_reify_field_load; slot = wstack(0); retfunc = return_int; \
    break; \
  case 'S': \
    func = jshort_reify_field_load;  slot = wstack(0); retfunc = return_int; \
    break; \
  case 'I': \
    func = jint_reify_field_load; slot = wstack(0); retfunc = return_int; \
    break; \
  case 'J': \
    func = jlong_reify_field_load; push(1); slot = stack_long(0); retfunc = return_long; \
    break; \
  case 'F': \
    func = jfloat_reify_field_load; slot = wstack(0); retfunc = return_float; \
    break; \
  case 'D': \
    func = jdouble_reify_field_load; push(1); slot = stack_double(0); retfunc = return_double; \
    break; \
  default: \
    ABORT(); \
  } \
  call_soft(func); \
  popargs(); \
  end_func_sync(); \
  return_ref(slot); \
} while (0)

#ifndef pusharg_char
#define pusharg_char pusharg_int
#endif
#ifndef pusharg_bool
#define pusharg_bool pusharg_int
#endif
#ifndef pusharg_byte
#define pusharg_byte pusharg_int
#endif
#ifndef pusharg_short
#define pusharg_short pusharg_int
#endif
#ifndef return_byte
#define return_byte return_int
#endif
#ifndef return_char
#define return_char return_int
#endif
#ifndef return_short
#define return_short return_int
#endif

#if defined(PUSHARG_FORWARDS)
#define push_arg_reify_field_store_before(obj, class, field) do { \
  pusharg_ref((obj), 0); \
  pusharg_ref_const((class), 1); \
  pusharg_ref_const((field), 2); \
} while (0)
#define push_arg_reify_field_store_after(obj, class, field)
#else
#define push_arg_reify_field_store_before(obj, class, field)
#define push_arg_reify_field_store_after(obj, class, field) do { \
  pusharg_ref_const((field), 2); \
  pusharg_ref_const((class), 1); \
  pusharg_ref((obj), 0); \
} while (0)
#endif 

#define softcall_reify_field_store(obj) do { \
  void *func = 0; \
  push_arg_reify_field_store_before(obj, finfo.class, finfo.field); \
  if (!FIELD_ISPRIM(finfo.field)) { \
    pusharg_ref(rstack(0), 3); pop(1); func = jref_reify_field_store; \
  } else switch (CLASS_PRIM_SIG(FIELD_TYPE(finfo.field))) { \
  case 'Z': \
    pusharg_bool(rstack(0), 3); pop(1); func = jboolean_reify_field_store; \
    break; \
  case 'C': \
    pusharg_char(rstack(0), 3); pop(1); func = jchar_reify_field_store; \
    break; \
  case 'B': \
    pusharg_byte(rstack(0), 3); pop(1); func = jbyte_reify_field_store; \
    break; \
  case 'S': \
    pusharg_short(rstack(0), 3); pop(1); func = jshort_reify_field_store; \
    break; \
  case 'I': \
    pusharg_int(rstack(0), 3); pop(1); func = jint_reify_field_store; \
    break; \
  case 'J': \
    pusharg_long(stack_long(0), 3); pop(2); func = jlong_reify_field_store; \
    break; \
  case 'F': \
    pusharg_float(rstack(0), 3); pop(1); func = jfloat_reify_field_store; \
    break; \
  case 'D': \
    pusharg_double(stack_double(0), 3); pop(2); func = jdouble_reify_field_store; \
    break; \
  default: \
    ABORT(); \
  } \
  push_arg_reify_field_store_after((obj), finfo.class, finfo.field); \
  begin_func_sync(); \
  call_soft(func); \
  end_func_sync(); \
  popargs(); \
} while (0)

#if defined(PUSHARG_FORWARDS)
#define push_arg_reify_array_load(obj, index) do { \
  pusharg_ref((obj), 0); \
  pusharg_int((index), 1); \
} while(0)
#else
#define push_arg_reify_array_load(obj, index) do { \
  pusharg_int((index), 1); \
  pusharg_ref((obj), 0); \
} while(0)
#endif

#define softcall_reify_array_load(obj, index, type, retto) do { \
  begin_func_sync(); \
  push_arg_reify_array_load((obj), (index)); \
  call_soft(j##type##_reify_array_load); \
  popargs(); \
  end_func_sync(); \
  return_##type(retto); \
} while (0)

#if defined(PUSHARG_FORWARDS)
#define push_arg_reify_array_store(obj, index, type, value) do { \
  pusharg_ref((obj), 0); \
  pusharg_int((index), 1); \
  pusharg_##type((value), 2); \
} while(0)
#else
#define push_arg_reify_array_store(obj, index, type, value) do { \
  pusharg_##type((value), 2); \
  pusharg_int((index), 1); \
  pusharg_ref((obj), 0); \
} while(0)
#endif

#define softcall_reify_array_store(obj, index, type, value) do { \
  begin_func_sync(); \
  push_arg_reify_array_store((obj), (index), type, (value)); \
  call_soft(j##type##_reify_array_store); \
  popargs(); \
  end_func_sync(); \
} while(0)

#define softcall_reify_arraylength(to, from) do { \
  begin_func_sync(); \
  pusharg_ref((from), 0); \
  call_soft(guarana_reify_arraylength); \
  popargs(); \
  end_func_sync(); \
  return_int((to)); \
} while (0)

#endif /* GUARANA */

#endif
