/*
 * Decompiled with CFR 0.152.
 */
package kaffe.net.www.protocol.http;

import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

public class HttpURLConnection
extends java.net.HttpURLConnection {
    private static String proxyHost;
    private static int proxyPort;
    private static boolean useProxy;
    private Vector headerFields = new Vector(0);
    private Socket sock;
    private InputStream in;
    private DataOutputStream out;
    private boolean redir = java.net.HttpURLConnection.getFollowRedirects();

    public void connect() throws IOException {
        while (true) {
            String string;
            String string2;
            int n;
            this.responseCode = -1;
            this.responseMessage = null;
            this.headerFields = new Vector();
            if (useProxy) {
                n = proxyPort;
                string2 = proxyHost;
            } else {
                n = this.url.getPort();
                string2 = this.url.getHost();
            }
            if (n == -1) {
                n = 80;
            }
            this.sock = new Socket(string2, n);
            this.in = new BufferedInputStream(this.sock.getInputStream());
            this.out = new DataOutputStream(this.sock.getOutputStream());
            if (useProxy) {
                string = this.url.toString();
            } else {
                string = this.url.getFile();
                if (string.equals("")) {
                    string = "/";
                }
            }
            this.out.writeBytes(this.method + " " + string + " HTTP/1.0\r\n");
            n = this.url.getPort();
            if (n == -1 || n == 80) {
                this.out.writeBytes("Host: " + this.url.getHost() + "\r\n");
            } else {
                this.out.writeBytes("Host: " + this.url.getHost() + ":" + n + "\r\n");
            }
            this.out.writeBytes("\r\n");
            this.out.flush();
            DataInputStream dataInputStream = new DataInputStream(this.in);
            String string3 = dataInputStream.readLine();
            if (string3 == null || !string3.startsWith("HTTP/")) break;
            int n2 = string3.indexOf(47);
            int n3 = string3.indexOf(32);
            String string4 = string3.substring(n2 + 1, n3);
            int n4 = string3.indexOf(32, ++n3);
            try {
                this.responseCode = Integer.parseInt(string3.substring(n3, n4));
            }
            catch (NumberFormatException numberFormatException) {
                break;
            }
            this.responseMessage = string3.substring(n4 + 1);
            this.headerFields.addElement(null);
            this.headerFields.addElement(string3);
            while ((string3 = dataInputStream.readLine()) != null && !string3.equals("")) {
                int n5 = string3.indexOf(58);
                if (n5 <= 0) continue;
                String string5 = string3.substring(0, n5);
                ++n5;
                while (Character.isWhitespace(string3.charAt(n5))) {
                    ++n5;
                }
                String string6 = string3.substring(n5);
                this.setHeaderField(string5, string6);
            }
            String string7 = this.getHeaderField("Location");
            if (!this.redir || this.responseCode < 300 || this.responseCode > 305 || string7 == null) break;
            this.url = new URL(string7);
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    public String getHeaderField(String string) {
        int n = this.headerFields.size() - 2;
        while (n > 0) {
            if (((String)this.headerFields.elementAt(n)).equalsIgnoreCase(string)) {
                return (String)this.headerFields.elementAt(n + 1);
            }
            n -= 2;
        }
        return null;
    }

    public String getHeaderField(int n) {
        if (n < 0 || n >= this.headerFields.size() >> 1) {
            return null;
        }
        return (String)this.headerFields.elementAt((n << 1) + 1);
    }

    public String getHeaderFieldKey(int n) {
        if (n < 0 || n >= this.headerFields.size() >> 1) {
            return null;
        }
        return (String)this.headerFields.elementAt(n << 1);
    }

    protected void setHeaderField(String string, String string2) {
        int n = this.headerFields.size() - 2;
        while (n > 0) {
            if (((String)this.headerFields.elementAt(n)).equalsIgnoreCase(string)) {
                this.headerFields.setElementAt(string2, n + 1);
                return;
            }
            n -= 2;
        }
        this.headerFields.addElement(string);
        this.headerFields.addElement(string2);
    }

    public Object getContent() throws IOException {
        String string = this.getContentType();
        if (string == null) {
            return this.in;
        }
        if (string.startsWith("image/")) {
            return Toolkit.getDefaultToolkit().getImage(this.url).getSource();
        }
        return this.in;
    }

    protected void setContentTypeFromName() {
        String string = URLConnection.getFileNameMap().getContentTypeFor(this.url.getFile());
        this.setHeaderField("Content-Type", string);
    }

    public void disconnect() {
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.sock = null;
    }

    public boolean usingProxy() {
        return useProxy;
    }

    public void setInstanceFollowRedirects(boolean bl) {
        this.redir = bl;
    }

    public HttpURLConnection(URL uRL) {
        super(uRL);
    }

    static {
        proxyPort = -1;
        useProxy = false;
        proxyHost = System.getProperty("http.proxyHost");
        if (proxyHost != null) {
            useProxy = true;
            String string = System.getProperty("http.proxyPort");
            if (string != null) {
                proxyPort = Integer.parseInt(string);
            }
        }
    }
}

