/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;

public class PushbackReader
extends FilterReader {
    private static final int DEFAULT_PUSHBACK_BUFFER_SIZE = 1;
    private PushbackBuffer pbuf;

    private void checkIfStillOpen() throws IOException {
        if (this.pbuf == null) {
            throw new IOException("Stream closed");
        }
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.pbuf = null;
        }
        super.close();
    }

    public void mark(int n) throws IOException {
        PushbackReader.throwMarkException();
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            if (this.pbuf.isEmpty()) {
                int n = super.read();
                Object var2_4 = null;
                return n;
            }
            char c = this.pbuf.read();
            Object var2_5 = null;
            return c;
        }
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = 0;
        if (!PushbackReader.validArguments(cArray, n, n2)) {
            throw new IndexOutOfBoundsException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            n3 += this.pbuf.read(cArray, n, n2);
            n += n3;
            if ((n2 -= n3) > 0) {
                n4 = super.read(cArray, n, n2);
            }
        }
        if (n4 == -1) {
            if (n3 == 0) {
                n3 = -1;
            }
        } else {
            n3 += n4;
        }
        return n3;
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            boolean bl = !this.pbuf.isEmpty() || super.ready();
            Object var2_3 = null;
            return bl;
        }
    }

    public void reset() throws IOException {
        PushbackReader.throwMarkException();
    }

    private static void throwMarkException() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public void unread(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            this.pbuf.unread((char)n);
        }
    }

    public void unread(char[] cArray, int n, int n2) throws IOException {
        if (!PushbackReader.validArguments(cArray, n, n2)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            this.pbuf.unread(cArray, n, n2);
        }
    }

    public void unread(char[] cArray) throws IOException {
        this.unread(cArray, 0, cArray.length);
    }

    private static boolean validArguments(char[] cArray, int n, int n2) {
        return n >= 0 && n < cArray.length && n2 >= 0 && n2 <= cArray.length - n;
    }

    public PushbackReader(Reader reader, int n) {
        super(reader);
        if (n <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        PushbackReader pushbackReader = this;
        if (pushbackReader == null) {
            throw null;
        }
        this.pbuf = pushbackReader.new PushbackBuffer(null, n);
    }

    public PushbackReader(Reader reader) {
        this(reader, 1);
    }

    private class PushbackBuffer {
        private char[] buf;
        private int pos;

        private int capacity() {
            return this.pos;
        }

        private boolean isEmpty() {
            return this.capacity() == this.buf.length;
        }

        private boolean isFull() {
            return this.capacity() == 0;
        }

        private int length() {
            return this.buf.length - this.capacity();
        }

        private char read() {
            return this.buf[this.pos++];
        }

        private int read(char[] cArray, int n, int n2) {
            n2 = Math.min(n2, this.length());
            System.arraycopy(this.buf, this.pos, cArray, n, n2);
            this.pos += n2;
            return n2;
        }

        private void throwOverflowException() throws IOException {
            throw new IOException("Pushback buffer overflow");
        }

        private void unread(char c) throws IOException {
            if (this.isFull()) {
                this.throwOverflowException();
            }
            this.buf[--this.pos] = c;
        }

        private void unread(char[] cArray, int n, int n2) throws IOException {
            if (n2 > this.capacity()) {
                this.throwOverflowException();
            }
            this.pos -= n2;
            System.arraycopy(cArray, n, this.buf, this.pos, n2);
        }

        private PushbackBuffer(int n) {
            this.buf = new char[n];
            this.pos = this.buf.length;
        }

        /* synthetic */ PushbackBuffer(1 var2_2, int n) {
            this(n);
        }
    }
}

