/*
 * Decompiled with CFR 0.152.
 */
import java.awt.CheckboxMenuItem;
import java.awt.Menu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

class TabMan
implements ItemListener,
ActionListener {
    private int tabSize = 4;
    private TextEdit textEdit;
    private TabDialog tab;
    private CheckboxMenuItem tab4;
    private CheckboxMenuItem tab8;
    private CheckboxMenuItem tabOther;
    private String otherString = new String("Other");

    public TabMan(TextEdit textEdit) {
        this.textEdit = textEdit;
    }

    public void addItems(Menu menu) {
        this.tab4 = new CheckboxMenuItem(new String("4"));
        this.tab4.addItemListener(this);
        menu.add(this.tab4);
        this.tab4.setState(true);
        this.tab8 = new CheckboxMenuItem(new String("8"));
        this.tab8.addItemListener(this);
        menu.add(this.tab8);
        this.tabOther = new CheckboxMenuItem(new String("Other"));
        this.tabOther.addItemListener(this);
        menu.add(this.tabOther);
    }

    public void setCheck(int n) {
        this.tab4.setState(false);
        this.tab8.setState(false);
        this.tabOther.setState(false);
        switch (n) {
            case 4: {
                this.tab4.setState(true);
                return;
            }
            case 8: {
                this.tab8.setState(true);
                return;
            }
        }
        this.tabOther.setState(true);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)itemEvent.getItem();
        if (this.otherString.equals(string)) {
            this.tab = new TabDialog(this.textEdit, this);
            this.tab.show();
        } else {
            this.tabSize = new Integer(string);
            this.textEdit.setTabSize(this.tabSize);
        }
        this.setCheck(this.tabSize);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = true;
        String string = actionEvent.getActionCommand();
        if (string.equals("Ok")) {
            int n = 4;
            try {
                n = new Integer(this.tab.getTabs());
                this.textEdit.setTabSize(n);
            }
            catch (Exception exception) {
                this.textEdit.getToolkit().beep();
                bl = false;
            }
            if (bl) {
                this.tabSize = n;
                this.tab.dispose();
                return;
            }
        } else if (string.equals("Cancel")) {
            this.tab.dispose();
        }
    }
}

