/*
 * object.c
 * Handle create and subsequent garbage collection of objects.
 *
 * Copyright (c) 1996, 1997
 *	Transvirtual Technologies, Inc.  All rights reserved.
 *
 * See the file "license.terms" for information on usage and redistribution 
 * of this file. 
 */

#define	ADBG(s)

#include "config.h"
#include "debug.h"
#include "config-std.h"
#include "config-mem.h"
#include "gtypes.h"
#include "access.h"
#include "object.h"
#include "constants.h"
#include "classMethod.h"
#include "lookup.h"
#include "itypes.h"
#include "baseClasses.h"
#include "errors.h"
#include "exception.h"
#include "itypes.h"
#include "md.h"
#include "external.h"
#include "gc.h"

#if GUARANA
#include "GuaraNative.h"
#endif

extern Hjava_lang_Class* ThreadClass;

extern gcFuncs gcFinalizeObject;
extern gcFuncs gcNormalObject;
extern gcFuncs gcRefArray;
extern gcFuncs gcClassObject;

/*
 * Create a new Java object.
 */
Hjava_lang_Object*
#if GUARANA
newObjectNoMessage(Hjava_lang_Class* class)
#else
newObject(Hjava_lang_Class* class)
#endif
{
	Hjava_lang_Object* obj;
	int type;

	if (class->finalizer == 0) {
		/* Treat strings specially because they're so frequent */
		if (class != StringClass) {
			type = GC_ALLOC_NORMALOBJECT;
		} else {
			type = GC_ALLOC_JAVASTRING;
		}
	} else {
		type = GC_ALLOC_FINALIZEOBJECT; 
	}

	obj = gc_malloc(CLASS_FSIZE(class), type);

        /* Fill in object information */
        obj->dtable = class->dtable;

#if GUARANA
	obj->meta_object = 0;
#endif

DBG(NEWOBJECT,
	dprintf("newObject %x class %s\n", obj,
		(class ? class->name->data : "<none>"));
    )

        return (obj);
}

/*
 * Allocate a new class object.
 * We make Class objects roots (for the moment).
 */
Hjava_lang_Class*
newClass(void)
{
	Hjava_lang_Class* cls;

	cls = gc_malloc(sizeof(Hjava_lang_Class), GC_ALLOC_CLASSOBJECT);

	/* Turn off class gc */
	if (Kaffe_JavaVMArgs[0].enableClassGC == 0) {
		gc_add_ref(cls);
	}

        /* Fill in object information */
	cls->head.dtable = ClassClass->dtable;

DBG(NEWOBJECT,
	dprintf("newClass @%p\n", cls);					
    )

        return (cls);
}

/*
 * Try to load kaffe.util.Ptr.  Ignore errors and keep trying until it
 * works.
 */
static Hjava_lang_Class *
ptrClass(void)
{
	static Hjava_lang_Class *r = 0;
	
	if (!r) {
		errorInfo einfo;
		
		r = lookupClass(PTRCLASS, &einfo);
		if (!r) discardErrorInfo(&einfo);
	}
	return r;
}

/*
 * Allocate a new array, of whatever types.
 */
Hjava_lang_Object*
#if GUARANA
newArrayNoMessage(Hjava_lang_Class* elclass, int count)
#else
newArray(Hjava_lang_Class* elclass, int count)
#endif
{
	Hjava_lang_Class* class;
	Hjava_lang_Object* obj;

	if (CLASS_IS_PRIMITIVE(elclass) || elclass == ptrClass()) {
		obj = gc_malloc((TYPE_SIZE(elclass) * count) + ARRAY_DATA_OFFSET, GC_ALLOC_PRIMARRAY);
	}
	else {
		obj = gc_malloc((PTR_TYPE_SIZE * count) + ARRAY_DATA_OFFSET, GC_ALLOC_REFARRAY);
	}
	class = lookupArray(elclass);
	obj->dtable = class->dtable;
#if GUARANA
	obj->meta_object = 0;
#endif
	ARRAY_SIZE(obj) = count;
	return (obj);
}

/*
 * Allocate a new multi-dimensional array.
 */
Hjava_lang_Object*
#if GUARANA
guarana_newMultiArray(Hjava_lang_Class *clazz, Hjava_lang_Object *creator, int *dims)
#else
newMultiArray(Hjava_lang_Class* clazz, int* dims)
#endif
{
	Hjava_lang_Object* obj;
	Hjava_lang_Object** array;
	int i;
	
#if GUARANA
	obj = guarana_newArray(CLASS_ELEMENT_TYPE(clazz), dims[0], creator);
#else
	obj = newArray(CLASS_ELEMENT_TYPE(clazz), dims[0]);
#endif
	if (dims[1] >= 0) {
		array = OBJARRAY_DATA(obj);
		for (i = 0; i < dims[0]; i++) {
#if GUARANA
		        /* FIXME: reify assignment? */
			array[i] = guarana_newMultiArray(CLASS_ELEMENT_TYPE(clazz), obj, &dims[1]);
#else
			array[i] = newMultiArray(CLASS_ELEMENT_TYPE(clazz), &dims[1]);
#endif
		}
	}

	return (obj);
}
