/*
 * locks.h
 * Manage locking system.
 *
 * Copyright (c) 1996, 1997
 *	Transvirtual Technologies, Inc.  All rights reserved.
 *
 * See the file "license.terms" for information on usage and redistribution 
 * of this file. 
 */

#ifndef __locks_h
#define __locks_h

#include "md.h"
#include "guarana.h"

#if GUARANA

/* Help catch errors */
# define lockMutex {lockMutexIsDeprecated}
# define unlockMutex {unlockMutexIsDeprecated}
# define unlockKnownMutex {unlockKnownMutexIsDeprecated}
# define unlockKnownObjMutex {unlockKnownObjMutexIsWrong}
# define unlockKnownCEntryMutex {unlockKnownCEntryMutexIsWrong}

# define lockObjMutex			guarana_reify_monitorEnter
# define unlockObjMutex			guarana_reify_monitorExit
# define unlockObjKnownMutex		guarana_reify_monitorExit_known

# define lockCEntryMutex		_lockMutex
# define unlockCEntryMutex		_unlockMutex
# define unlockCEntryKnownMutex		_unlockKnownMutex

# define lockObjMutexDirect		_lockMutex
# define unlockObjMutexDirect		_unlockMutex
# define unlockObjKnownMutexDirect	_unlockKnownMutex

#else

# define lockObjMutex			_lockMutex
# define unlockObjMutex			_unlockMutex
# define unlockObjKnownMutex		unlockKnownMutex

# define lockCEntryMutex		_lockMutex
# define unlockCEntryMutex		_unlockMutex
# define unlockCEntryKnownMutex		unlockKnownMutex

#endif

#define	waitCond			_waitCond
#define	signalCond			_signalCond
#define	broadcastCond			_broadcastCond
#define	holdMutex			_holdMutex

#if GUARANA
#define _unlockKnownMutex(THING)        _unlockMutexFree((THING))
#else
#define	unlockKnownMutex(THING)		_unlockMutexFree((THING))
#endif

#define	initStaticLock(THING)		__initLock((THING), #THING)
#define staticLockIsInitialized(THING)	((THING)->ref == -1)
#define	lockStaticMutex(THING)		__lockMutex((THING))
#define	unlockStaticMutex(THING)	__unlockMutex((THING))
#define	waitStaticCond(THING, TIME)	__waitCond((THING), (TIME))
#define	signalStaticCond(THING)		__signalCond((THING))
#define	broadcastStaticCond(THING)	__broadcastCond((THING))

struct Hjava_lang_Thread;

typedef struct _iLock {
	const void*		address;
	struct _iLock*		next;
	int			ref;
	void*			holder;
	int			count;
	void*			mux;
	void*			cv;
} iLock;

#if GUARANA
struct Hjava_lang_Object;
extern iLock *guarana_reify_monitorEnter(struct Hjava_lang_Object *o);
extern void guarana_reify_monitorExit(struct Hjava_lang_Object *o);
extern void guarana_reify_monitorExit_known(iLock *o);
#endif

extern iLock*	getLock(void*);
extern void	__initLock(iLock* lk, const char *lkname);
extern void	__lockMutex(iLock*);
extern void	__unlockMutex(iLock*);
extern int	__waitCond(iLock*, jlong);
extern void	__signalCond(iLock*);
extern void	__broadcastCond(iLock*);
extern int	__holdMutex(iLock*);

extern iLock*	_lockMutex(void*);
extern void	_unlockMutex(void*);
extern void	_unlockMutexFree(iLock*lk);
extern int	_waitCond(void*, jlong);
extern void	_signalCond(void*);
extern void	_broadcastCond(void*);
extern int	_holdMutex(void*);

typedef struct LockInterface {

	void	(*init)(iLock*);
	void	(*lock)(iLock*);
	void	(*unlock)(iLock*);
	void	(*wait)(iLock*, jlong);
	void	(*signal)(iLock*);
	void	(*broadcast)(iLock*);

	void	(*spinon)(void*);
	void	(*spinoff)(void*);

} LockInterface;

extern LockInterface Kaffe_LockInterface;

extern void dumpLocks(void);
#endif
