/*
 * Decompiled with CFR 0.152.
 */
package pizza.v39;

import java.io.FileInputStream;
import java.io.IOException;
import pizza.lang.Pair;
import pizza.util.Set;
import pizza.v39.Constants;
import pizza.v39.Name;
import pizza.v39.Position;
import pizza.v39.Switches;

class Report
implements Constants {
    static final int noPos = 0;
    private static Name sourcename;
    private static Name lastname;
    static boolean silent;
    static int nerrors;
    static int nwarnings;
    private static Set recorded;
    private static byte[] buf;
    private static int lastPos;
    private static int lastLine;
    private static int lineEnd;
    static final byte LF = 10;
    static final byte FF = 12;
    static final byte CR = 13;

    static void init() {
        lastname = sourcename = Name.fromString("<input>");
        silent = false;
        nerrors = 0;
        nwarnings = 0;
        recorded = new Set();
        buf = null;
    }

    static Name useSource(Name name) {
        Name name2 = sourcename;
        sourcename = name;
        return name2;
    }

    static void prompt() {
        if (Switches.promptOnError) {
            System.out.println("R)esume, A)bort>");
            try {
                while (true) {
                    switch (System.in.read()) {
                        case 65: 
                        case 97: {
                            System.exit(-1);
                            return;
                        }
                        case 82: 
                        case 114: {
                            return;
                        }
                        case 88: 
                        case 120: {
                            throw new InternalError("user abort");
                        }
                    }
                }
            }
            catch (IOException iOException) {
                throw new InternalError("input read error");
            }
        }
    }

    private static void printErrLine(int n, int n2) {
        try {
            Object object;
            int n3 = 0;
            if (lastname != sourcename) {
                object = new FileInputStream(sourcename.toString());
                buf = new byte[((FileInputStream)object).available() + 1];
                ((FileInputStream)object).read(buf);
                ((FileInputStream)object).close();
                lastLine = 0;
            } else if (0 < lastLine && lastLine <= n) {
                n3 = lastPos;
            } else {
                lastLine = 0;
            }
            if (buf == null) {
                return;
            }
            while (n3 < buf.length && lastLine < n) {
                lastPos = n3;
                while (n3 < buf.length && buf[n3] != 13 && buf[n3] != 10 && buf[n3] != 12) {
                    ++n3;
                }
                lineEnd = n3;
                if (n3 < buf.length) {
                    ++n3;
                }
                if (n3 < buf.length && buf[n3 - 1] == 13 && buf[n3] == 10) {
                    ++n3;
                }
                ++lastLine;
            }
            System.out.println(new String(buf, 0, lastPos, lineEnd - lastPos));
            object = new byte[n2];
            for (int i = 1; i < n2; ++i) {
                object[i - 1] = 32;
            }
            object[n2 - 1] = 94;
            System.out.println(new String((byte[])object, 0));
        }
        catch (IOException iOException) {
            System.out.println("(source unavailable)");
        }
    }

    private static void printError(int n, String string) {
        if (!Switches.errorsPossible) {
            System.out.println("Suspicious error message -- ");
            System.out.println("there might be something wrong with the Pizza->Java translation.");
            Report.inviteBugReport();
        }
        if (n == 0) {
            System.out.println(String.valueOf("error: ").concat(String.valueOf(string)));
        } else {
            int n2 = Position.line(n);
            int n3 = Position.column(n);
            System.out.print(String.valueOf(sourcename).concat(String.valueOf(":")));
            System.out.print(n2);
            System.out.print(": ");
            System.out.println(string);
            Report.printErrLine(n2, n3);
        }
    }

    static void error(int n, String string) {
        Pair pair;
        if (!silent && nerrors < 100 && !recorded.pizza$util$Set$contains(pair = new Pair(sourcename, new Integer(n)))) {
            recorded.pizza$util$Set$put(pair);
            Report.printError(n, string);
            Report.prompt();
            ++nerrors;
        }
    }

    static void warning(int n, String string) {
        if (!silent && Switches.errorsPossible && nwarnings < 100) {
            if (!Switches.nowarn) {
                Report.printError(n, String.valueOf("warning: ").concat(String.valueOf(string)));
            }
            ++nwarnings;
        }
    }

    static void inviteBugReport() {
        System.out.println("Please file a bug report by sending your program and the following diagnostic to");
        System.out.println("pizza@cis.unisa.edu.au.\n\n   Thank you.\n");
    }

    Report() {
    }

    static {
        lastPos = 0;
        lastLine = 0;
        lineEnd = 0;
    }
}

