/*
 * Decompiled with CFR 0.152.
 */
package kaffe.util.log;

import java.io.OutputStream;
import java.util.Vector;
import kaffe.util.DoubleLinkedObject;
import kaffe.util.log.LogClient;

public class LogStream
extends OutputStream {
    DoubleLinkedObject first;
    DoubleLinkedObject last;
    StringBuffer current = new StringBuffer(80);
    int nLines;
    int limit;
    Object client;

    public LogStream(int n) {
        this.limit = n;
    }

    public LogStream(int n, LogClient logClient) {
        this.limit = n;
        this.client = logClient;
    }

    public void addClient(LogClient logClient) {
        if (this.client == null) {
            this.client = logClient;
        } else if (this.client instanceof Vector) {
            ((Vector)this.client).addElement(logClient);
        } else {
            Vector vector = new Vector(2);
            vector.addElement(this.client);
            vector.addElement(logClient);
            this.client = vector;
        }
    }

    public DoubleLinkedObject getFirstLine() {
        return this.first;
    }

    public DoubleLinkedObject getLastLine() {
        return this.last;
    }

    void notifyClient() {
        if (this.client != null) {
            if (this.client instanceof LogClient) {
                ((LogClient)this.client).newLogLine(this);
            } else if (this.client instanceof Vector) {
                Vector vector = (Vector)this.client;
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    ((LogClient)vector.elementAt(i)).newLogLine(this);
                }
            }
        }
    }

    public void removeClient(LogClient logClient) {
        if (this.client != null) {
            if (this.client instanceof Vector) {
                ((Vector)this.client).removeElement(logClient);
            } else if (this.client == logClient) {
                this.client = null;
            }
        }
    }

    public void write(int n) {
        if (n == 10) {
            if (this.nLines > this.limit) {
                this.first = this.first.next;
            }
            DoubleLinkedObject doubleLinkedObject = new DoubleLinkedObject(new String(this.current), this.last, null);
            if (this.first == null) {
                this.first = this.last = doubleLinkedObject;
            } else {
                this.last = doubleLinkedObject;
            }
            this.current.setLength(0);
            ++this.nLines;
            this.notifyClient();
        } else if (n == 9 || n >= 32) {
            this.current.append((char)n);
        }
    }
}

