/*
 * Decompiled with CFR 0.152.
 */
package kaffe.util;

import java.text.DateFormatSymbols;
import java.util.TimeZone;
import kaffe.util.DateParser;

public class DateScanner {
    int si0;
    int si1;
    int sLen;
    char[] src;
    int tok;
    static final int DAY = 0;
    static final int MONTH = 1;
    static final int YEAR = 2;
    static final int HOUR = 3;
    static final int MINUTE = 4;
    static final int SECOND = 5;
    static final int WEEKDAY = 6;
    static final int ZONE = 7;
    static final int OFFSET = 8;
    static final int EOF = -1;
    static final int WDDAY = 9;
    static final int WDMONTH = 10;
    static final int AMPM = 11;
    static final int UNKNOWN = -2;
    DateFormatSymbols syms;

    public DateScanner(String string) {
        this(string, new DateFormatSymbols());
    }

    public DateScanner(String string, DateFormatSymbols dateFormatSymbols) {
        this.syms = dateFormatSymbols;
        this.src = string.toCharArray();
        this.sLen = this.src.length;
        this.si0 = 0;
        this.si1 = -1;
        this.tok = -1;
    }

    int closeToken() {
        if (this.src[this.si0] >= 'A' && this.src[this.si0] <= 'Z') {
            String string = this.stringToken();
            if (DateParser.getDayIdx(string, this.syms) > -1) {
                this.tok = 6;
                return 6;
            }
            if (DateParser.getMonthIdx(string, this.syms) > -1) {
                this.tok = 10;
                return 10;
            }
            if (TimeZone.getTimeZone(string) != null) {
                this.tok = 7;
                return 7;
            }
            if (string.equals("AM") || string.equals("PM")) {
                this.tok = 11;
                return 11;
            }
            return -2;
        }
        switch (this.tok) {
            case 3: {
                this.tok = 4;
                return 4;
            }
            case 4: {
                this.tok = 5;
                return 5;
            }
            case 1: {
                this.tok = 2;
                return 2;
            }
            case 0: {
                this.tok = 2;
                return 2;
            }
            case 6: {
                this.tok = 9;
                return 9;
            }
            case 9: {
                this.tok = 10;
                return 10;
            }
            case 10: {
                this.tok = 2;
                return 2;
            }
            case 7: {
                this.tok = 8;
                return 8;
            }
        }
        this.tok = -1;
        return -1;
    }

    public static void main(String[] stringArray) {
        int n;
        DateScanner dateScanner = new DateScanner(stringArray[0]);
        while ((n = dateScanner.nextToken()) != -1) {
            System.out.println(String.valueOf(String.valueOf(n).concat(String.valueOf(" "))).concat(String.valueOf(dateScanner.stringToken())));
        }
    }

    public int nextToken() {
        ++this.si1;
        if (this.si1 >= this.sLen) {
            this.tok = -1;
            return -1;
        }
        while (this.si1 < this.sLen && this.src[this.si1] == ' ') {
            ++this.si1;
        }
        this.si0 = this.si1;
        while (this.si1 < this.sLen) {
            char c = this.src[this.si1];
            switch (c) {
                case '/': {
                    if (this.tok == 1) {
                        this.tok = 0;
                        return 0;
                    }
                    this.tok = 1;
                    return 1;
                }
                case ' ': {
                    return this.closeToken();
                }
                case '.': {
                    if (this.tok == 0) {
                        this.tok = 1;
                        return 1;
                    }
                    this.tok = 0;
                    return 0;
                }
                case ':': {
                    if (this.tok == 3) {
                        this.tok = 4;
                        return 4;
                    }
                    this.tok = 3;
                    return 3;
                }
                case ',': {
                    if (this.tok == 10) {
                        this.tok = 0;
                        return 0;
                    }
                    this.tok = 6;
                    return 6;
                }
                case '+': 
                case '-': {
                    this.tok = 7;
                    return 7;
                }
            }
            ++this.si1;
        }
        return this.closeToken();
    }

    public String stringToken() {
        return new String(this.src, this.si0, this.si1 - this.si0);
    }
}

