/*
 * Decompiled with CFR 0.152.
 */
package kaffe.net.www.protocol.http;

import java.awt.Toolkit;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;

public class HttpURLConnection
extends java.net.HttpURLConnection {
    private static final String[] headers = new String[]{"content-encoding", "content-length", "content-type", "date", "expiration", "If-Modified-Since", "lastModified"};
    private static final int ContentEncoding = 0;
    private static final int ContentLength = 1;
    private static final int ContentType = 2;
    private static final int Date = 3;
    private static final int Expiration = 4;
    private static final int IfModifiedSince = 5;
    private static final int LastModified = 6;
    private String[] headersValue = new String[headers.length];
    private Socket sock;
    private DataInputStream in;
    private DataOutputStream out;

    public HttpURLConnection(URL uRL) {
        super(uRL);
    }

    public void connect() throws IOException {
        String string;
        int n = this.url.getPort();
        if (n == -1) {
            n = 80;
        }
        this.sock = new Socket(this.url.getHost(), n);
        this.in = new DataInputStream(this.sock.getInputStream());
        this.out = new DataOutputStream(this.sock.getOutputStream());
        String string2 = this.url.getFile();
        if (string2.equals("")) {
            string2 = "/";
        }
        this.out.writeBytes(String.valueOf(String.valueOf(String.valueOf(this.method).concat(String.valueOf(" "))).concat(String.valueOf(string2))).concat(String.valueOf(" HTTP/1.0\n\n")));
        while ((string = this.in.readLine()) != null && !string.equals("")) {
            StringTokenizer stringTokenizer;
            if (string.startsWith("HTTP")) {
                this.responseMessage = string;
                stringTokenizer = new StringTokenizer(string);
                if (stringTokenizer.countTokens() < 3) continue;
                stringTokenizer.nextToken();
                try {
                    this.responseCode = Integer.parseInt(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    this.responseCode = 500;
                }
                continue;
            }
            stringTokenizer = new StringTokenizer(string, " \t:");
            if (stringTokenizer.countTokens() != 2) continue;
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            this.setHeaderField(string3, string4);
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    public String getHeaderField(String string) {
        for (int i = 0; i < headers.length; ++i) {
            if (!headers[i].equalsIgnoreCase(string)) continue;
            return this.getHeaderField(i);
        }
        return null;
    }

    public String getHeaderField(int n) {
        if (n < 0 || n >= this.headersValue.length) {
            return null;
        }
        return this.headersValue[n];
    }

    public String getHeaderFieldKey(int n) {
        if (n < 0 || n >= headers.length) {
            return null;
        }
        return headers[n];
    }

    protected void setHeaderField(String string, String string2) {
        for (int i = 0; i < headers.length; ++i) {
            if (!headers[i].equalsIgnoreCase(string)) continue;
            this.headersValue[i] = string2;
            break;
        }
    }

    public Object getContent() throws IOException {
        if (this.headersValue[0] == null) {
            return null;
        }
        if (this.headersValue[0].startsWith("image/")) {
            return Toolkit.getDefaultToolkit().getImage(this.url).getSource();
        }
        return null;
    }

    protected void setContentTypeFromName() {
        String string;
        this.headersValue[2] = string = URLConnection.getFileNameMap().getContentTypeFor(this.url.getFile());
        this.headersValue[0] = string;
    }

    public void disconnect() {
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean usingProxy() {
        return false;
    }
}

