/*
 * Decompiled with CFR 0.152.
 */
package kaffe.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.util.Vector;
import kaffe.io.ObjectStreamClassImpl;

public class ObjectInputStreamImpl
extends DataInputStream {
    private static ObjectStreamClassImpl defaultClassDesc = new ObjectStreamClassImpl();
    private byte[] buffer = new byte[255];
    private int pos;
    private int len;
    private boolean buffering = false;
    private static int firstKey = 0x7E0000;
    private Vector objectReferences = new Vector();
    private ObjectInputStream parent;

    public ObjectInputStreamImpl(InputStream inputStream, ObjectInputStream objectInputStream) {
        super(null);
        this.in = new Input(inputStream);
        this.parent = objectInputStream;
    }

    public boolean enableBuffering(boolean bl) {
        boolean bl2 = this.buffering;
        if (bl != bl2) {
            if (this.buffering) {
                this.len = 0;
                this.pos = 0;
            }
            this.buffering = bl;
        }
        return bl2;
    }

    public Object readObject() throws OptionalDataException, ClassNotFoundException, IOException {
        boolean bl = this.enableBuffering(false);
        Object object = null;
        int n = this.readUnsignedByte();
        switch (n) {
            case 112: {
                object = null;
                break;
            }
            case 116: {
                object = this.readUTF();
                this.makeObjectReference(object);
                break;
            }
            case 113: {
                object = this.getObjectFromReference(this.readInt());
                break;
            }
            case 114: {
                object = this.getStreamClass();
                break;
            }
            case 115: {
                object = this.getObject();
                break;
            }
            case 117: {
                object = this.getArray();
                break;
            }
            case 121: {
                this.resetObjectReferences();
                break;
            }
            case 119: {
                int n2 = this.read();
                if (n2 == -1) {
                    throw new StreamCorruptedException("incomplete block count");
                }
                throw new OptionalDataException(n2);
            }
            case 122: {
                int n3 = this.read();
                int n4 = this.read();
                int n5 = this.read();
                int n6 = this.read();
                if (n3 == -1 || n4 == -1 || n5 == -1 || n6 == -1) {
                    throw new StreamCorruptedException("incomplete block count");
                }
                int n7 = n3 << 24 | n4 << 16 | n5 << 8 | n6;
                throw new OptionalDataException(n7);
            }
            default: {
                throw new StreamCorruptedException(String.valueOf("unexpected token: ").concat(String.valueOf(n)));
            }
        }
        this.enableBuffering(bl);
        return object;
    }

    public void defaultReadObject(Object object, ObjectStreamClass objectStreamClass) throws IOException, StreamCorruptedException {
        boolean bl = this.enableBuffering(false);
        objectStreamClass.defaultReadObject(object, this.parent);
        this.enableBuffering(bl);
    }

    public void readStreamHeader() throws IOException, StreamCorruptedException {
        short s = this.readShort();
        if (s != -21267) {
            throw new StreamCorruptedException(String.valueOf("bad magic nr: ").concat(String.valueOf(s)));
        }
        s = this.readShort();
        if (s != 5) {
            throw new StreamCorruptedException(String.valueOf("bad version nr: ").concat(String.valueOf(s)));
        }
    }

    private Object getObjectFromReference(int n) throws StreamCorruptedException {
        try {
            return this.objectReferences.elementAt(n - firstKey);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new StreamCorruptedException("reference to unknown object");
        }
    }

    public void makeObjectReference(Object object) {
        this.objectReferences.addElement(object);
    }

    private void resetObjectReferences() {
        this.objectReferences.removeAllElements();
    }

    private Object getObject() throws StreamCorruptedException, OptionalDataException {
        try {
            ObjectStreamClassImpl objectStreamClassImpl = (ObjectStreamClassImpl)this.parent.readObject();
            Object object = objectStreamClassImpl.getObject(this.parent, this);
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new StreamCorruptedException(String.valueOf("error getting object: ").concat(String.valueOf(classNotFoundException)));
        }
        catch (IOException iOException) {
            throw new StreamCorruptedException(String.valueOf("error getting object: ").concat(String.valueOf(iOException)));
        }
        catch (ClassCastException classCastException) {
            throw new StreamCorruptedException(String.valueOf("error getting object: ").concat(String.valueOf(classCastException)));
        }
    }

    private Object getStreamClass() throws StreamCorruptedException {
        try {
            Object object = defaultClassDesc.getClass(this.parent, this);
            return object;
        }
        catch (IOException iOException) {
            throw new StreamCorruptedException(String.valueOf("error getting class: ").concat(String.valueOf(iOException)));
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            throw new StreamCorruptedException(String.valueOf("error getting class: ").concat(String.valueOf(classCastException)));
        }
    }

    private Object getArray() throws StreamCorruptedException {
        try {
            ObjectStreamClassImpl objectStreamClassImpl = (ObjectStreamClassImpl)this.parent.readObject();
            Object object = objectStreamClassImpl.getArray(this.parent, this);
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new StreamCorruptedException(String.valueOf("bad array: ").concat(String.valueOf(classNotFoundException)));
        }
        catch (IOException iOException) {
            throw new StreamCorruptedException(String.valueOf("bad array: ").concat(String.valueOf(iOException)));
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            throw new StreamCorruptedException(String.valueOf("bad array: ").concat(String.valueOf(classCastException)));
        }
    }

    final /* synthetic */ boolean access$000() {
        return this.buffering;
    }

    final /* synthetic */ int access$200() {
        return this.len;
    }

    final /* synthetic */ int access$201(int n) {
        this.len = n;
        return this.len;
    }

    final /* synthetic */ int access$100() {
        return this.pos;
    }

    final /* synthetic */ int access$101(int n) {
        this.pos = n;
        return this.pos;
    }

    final /* synthetic */ int access$108() {
        return this.pos++;
    }

    final /* synthetic */ byte[] access$300() {
        return this.buffer;
    }

    class Input
    extends InputStream {
        private InputStream in;
        int leftinblock;

        Input(InputStream inputStream) {
            this.in = inputStream;
        }

        public void close() throws IOException {
            this.in.close();
        }

        public int read() throws IOException {
            if (!ObjectInputStreamImpl.this.access$000()) {
                int n = this.in.read();
                return n;
            }
            if (ObjectInputStreamImpl.this.access$100() < ObjectInputStreamImpl.this.access$200()) {
                return ObjectInputStreamImpl.this.access$300()[ObjectInputStreamImpl.this.access$108()] & 0xFF;
            }
            if (this.leftinblock > 0) {
                int n = ObjectInputStreamImpl.this.access$300().length;
                if (n > this.leftinblock) {
                    n = this.leftinblock;
                }
                ObjectInputStreamImpl.this.access$201(this.in.read(ObjectInputStreamImpl.this.access$300(), 0, n));
                if (ObjectInputStreamImpl.this.access$200() != n) {
                    throw new StreamCorruptedException(String.valueOf(String.valueOf(String.valueOf("bad blockdata size, read ").concat(String.valueOf(ObjectInputStreamImpl.this.access$200()))).concat(String.valueOf(" expected "))).concat(String.valueOf(n)));
                }
                ObjectInputStreamImpl.this.access$101(1);
                this.leftinblock -= ObjectInputStreamImpl.this.access$200();
                return ObjectInputStreamImpl.this.access$300()[0] & 0xFF;
            }
            int n = this.in.read();
            switch (n) {
                case 119: {
                    this.leftinblock = this.in.read();
                    return this.read();
                }
                case 122: {
                    int n2 = 0;
                    for (int i = 24; i >= 0; i -= 8) {
                        n = this.in.read();
                        if (n == -1) {
                            throw new StreamCorruptedException("reached eof while reading block size");
                        }
                        n2 |= n << i;
                    }
                    this.leftinblock = n2;
                    return this.read();
                }
            }
            new Throwable().printStackTrace();
            throw new StreamCorruptedException(String.valueOf("expected blockdata: ").concat(String.valueOf(n)));
        }
    }
}

