/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import kaffe.lang.DummyClassLoader;

public abstract class ResourceBundle {
    protected ResourceBundle parent = null;

    public static final ResourceBundle getBundle(String string) throws MissingResourceException {
        return ResourceBundle.getBundle(string, Locale.getDefault());
    }

    public static final ResourceBundle getBundle(String string, Locale locale2) throws MissingResourceException {
        ResourceBundle resourceBundle = ResourceBundle.getBundleWithLocale(string, locale2);
        if (resourceBundle == null && locale2 != Locale.getDefault()) {
            resourceBundle = ResourceBundle.getBundleWithLocale(string, Locale.getDefault());
        }
        if (resourceBundle == null) {
            throw new MissingResourceException(String.valueOf("no bundles found: ").concat(String.valueOf(string)), "ResourceBundle", string);
        }
        return resourceBundle;
    }

    private static final ResourceBundle getBundleWithLocale(String string, Locale locale2) {
        ResourceBundle resourceBundle;
        int n;
        String string2 = locale2.getLanguage();
        String string3 = locale2.getCountry();
        String string4 = locale2.getVariant();
        String string5 = null;
        if (string4 != null && (n = string4.lastIndexOf(95)) != -1) {
            string5 = string4.substring(n + 1);
            string4 = string4.substring(0, n);
        }
        if (string2 != null) {
            string2 = string2.toLowerCase();
        }
        ResourceBundle resourceBundle2 = null;
        try {
            resourceBundle = ResourceBundle.getSpecificBundle(string);
            resourceBundle.setParent(resourceBundle2);
            resourceBundle2 = resourceBundle;
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (string2 != null) {
            try {
                resourceBundle = ResourceBundle.getSpecificBundle(String.valueOf(String.valueOf(string).concat(String.valueOf("_"))).concat(String.valueOf(string2)));
                resourceBundle.setParent(resourceBundle2);
                resourceBundle2 = resourceBundle;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (string2 != null && string3 != null) {
            try {
                resourceBundle = ResourceBundle.getSpecificBundle(String.valueOf(String.valueOf(String.valueOf(String.valueOf(string).concat(String.valueOf("_"))).concat(String.valueOf(string2))).concat(String.valueOf("_"))).concat(String.valueOf(string3)));
                resourceBundle.setParent(resourceBundle2);
                resourceBundle2 = resourceBundle;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (string2 != null && string3 != null && string4 != null) {
            try {
                resourceBundle = ResourceBundle.getSpecificBundle(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(string).concat(String.valueOf("_"))).concat(String.valueOf(string2))).concat(String.valueOf("_"))).concat(String.valueOf(string3))).concat(String.valueOf("_"))).concat(String.valueOf(string4)));
                resourceBundle.setParent(resourceBundle2);
                resourceBundle2 = resourceBundle;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (string2 != null && string3 != null && string4 != null && string5 != null) {
            try {
                resourceBundle = ResourceBundle.getSpecificBundle(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(string).concat(String.valueOf("_"))).concat(String.valueOf(string2))).concat(String.valueOf("_"))).concat(String.valueOf(string3))).concat(String.valueOf("_"))).concat(String.valueOf(string4))).concat(String.valueOf("_"))).concat(String.valueOf(string5)));
                resourceBundle.setParent(resourceBundle2);
                resourceBundle2 = resourceBundle;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return resourceBundle2;
    }

    public abstract Enumeration getKeys();

    public final Object getObject(String string) throws MissingResourceException {
        try {
            Object object = this.handleGetObject(string);
            if (object != null) {
                return object;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (this.parent == null) {
            throw new MissingResourceException("resource not found", this.getClass().toString(), string);
        }
        return this.parent.getObject(string);
    }

    private static final ResourceBundle getSpecificBundle(String string) throws MissingResourceException {
        Object object;
        string = string.replace('.', '/');
        try {
            object = Class.forName(string);
            if (Class.forName("java.util.ResourceBundle").isAssignableFrom((Class)object)) {
                return (ResourceBundle)((Class)object).newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = DummyClassLoader.getCurrentClassLoader().getResourceAsStream(String.valueOf(string).concat(String.valueOf(".properties")));
        if (object != null) {
            try {
                return new PropertyResourceBundle((InputStream)object);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new MissingResourceException("bundle not found", "ResourceBundle", string);
    }

    public final String getString(String string) throws MissingResourceException {
        return (String)this.getObject(string);
    }

    public final String[] getStringArray(String string) throws MissingResourceException {
        return (String[])this.getObject(string);
    }

    protected abstract Object handleGetObject(String var1) throws MissingResourceException;

    protected void setParent(ResourceBundle resourceBundle) {
        this.parent = resourceBundle;
    }
}

