/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Hashtable;

public class ChoiceFormat
extends NumberFormat {
    private double[] limits;
    private String[] strings;
    private String pattern = null;
    private Hashtable patternNames = null;

    public ChoiceFormat(String string) {
        this.applyPattern(string);
    }

    public ChoiceFormat(double[] dArray, String[] stringArray) {
        this.setChoices(dArray, stringArray);
    }

    public void applyPattern(String string) {
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != '|') continue;
            ++n2;
        }
        this.limits = new double[n2 + 1];
        this.strings = new String[n2 + 1];
        int n3 = 0;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '#') {
                this.limits[n4] = Double.valueOf(string.substring(n3, i));
                stringBuffer.append(String.valueOf(this.limits[n4]).concat(String.valueOf("#")));
                n3 = i + 1;
                continue;
            }
            if (c == '<') {
                this.limits[n4] = ChoiceFormat.nextDouble(Double.valueOf(string.substring(n3, i)));
                stringBuffer.append(String.valueOf(Double.valueOf(string.substring(n3, i))).concat(String.valueOf("<")));
                n3 = i + 1;
                continue;
            }
            if (c != '|') continue;
            this.strings[n4] = string.substring(n3, i);
            stringBuffer.append(String.valueOf(this.strings[n4]).concat(String.valueOf("|")));
            ++n4;
            n3 = i + 1;
        }
        this.strings[n4] = string.substring(n3, n);
        stringBuffer.append(this.strings[n4]);
        this.pattern = new String(stringBuffer);
    }

    public Object clone() {
        return new ChoiceFormat(this.limits, this.strings);
    }

    public boolean equals(Object object) {
        try {
            ChoiceFormat choiceFormat = (ChoiceFormat)object;
            for (int i = 0; i < this.limits.length; ++i) {
                if (this.limits[i] == choiceFormat.limits[i] && this.strings[i].equals(choiceFormat.strings[i])) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((double)l, stringBuffer, fieldPosition);
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (d < this.limits[0] || Double.isNaN(d)) {
            stringBuffer.append(this.strings[0]);
            return stringBuffer;
        }
        int n = this.limits.length - 1;
        for (int i = 0; i < n; ++i) {
            if (!(this.limits[i] <= d) || !(d < this.limits[i + 1])) continue;
            stringBuffer.append(this.strings[i]);
            return stringBuffer;
        }
        stringBuffer.append(this.strings[n]);
        return stringBuffer;
    }

    public Object[] getFormats() {
        return this.strings;
    }

    public double[] getLimits() {
        return this.limits;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static final double nextDouble(double d) {
        if (Double.isNaN(d)) {
            return d;
        }
        if (Double.POSITIVE_INFINITY == d) {
            return d;
        }
        if (0.0 == d) {
            return Double.longBitsToDouble(1L);
        }
        long l = Double.doubleToLongBits(d);
        if (d < 0.0) {
            return Double.longBitsToDouble(l - 1L);
        }
        return Double.longBitsToDouble(l + 1L);
    }

    public static final double previousDouble(double d) {
        if (Double.isNaN(d)) {
            return d;
        }
        if (Double.NEGATIVE_INFINITY == d) {
            return d;
        }
        if (0.0 == d) {
            return Double.longBitsToDouble(-9223372036854775807L);
        }
        long l = Double.doubleToLongBits(d);
        if (d > 0.0) {
            return Double.longBitsToDouble(l - 1L);
        }
        return Double.longBitsToDouble(l + 1L);
    }

    public static double nextDouble(double d, boolean bl) {
        if (bl) {
            return ChoiceFormat.nextDouble(d);
        }
        return ChoiceFormat.previousDouble(d);
    }

    public Number parse(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        int n2 = n + 1;
        if (this.patternNames == null) {
            this.patternNames = new Hashtable();
            for (int i = 0; i < this.limits.length; ++i) {
                this.patternNames.put(this.strings[i], new Double(this.limits[i]));
            }
        }
        while (n2 <= string.length()) {
            Double d = (Double)this.patternNames.get(string.substring(n, n2));
            if (d == null) {
                ++n2;
                continue;
            }
            parsePosition.setIndex(n2);
            return d;
        }
        return new Double(Double.NaN);
    }

    public void setChoices(double[] dArray, String[] stringArray) {
        this.limits = dArray;
        this.strings = stringArray;
    }

    public String toPattern() {
        if (this.limits.length == 0) {
            return "";
        }
        if (this.pattern == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.limits.length; ++i) {
                stringBuffer.append(String.valueOf(String.valueOf(this.limits[i]).concat(String.valueOf("#"))).concat(String.valueOf(this.strings[i])));
                if (i < this.limits.length - 1) {
                    stringBuffer.append("|");
                }
                this.pattern = new String(stringBuffer);
            }
        }
        return this.pattern;
    }
}

