/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.UnknownHostException;
import kaffe.net.DefaultSocketImplFactory;
import kaffe.util.NotImplemented;

public class Socket {
    private static SocketImplFactory factory = new DefaultSocketImplFactory();
    SocketImpl impl;

    public Socket(InetAddress inetAddress, int n) throws IOException {
        this(inetAddress, n, true);
    }

    public Socket(String string, int n) throws UnknownHostException, IOException {
        this(InetAddress.getByName(string), n, true);
    }

    public Socket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        throw new NotImplemented();
    }

    public Socket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        throw new NotImplemented();
    }

    public Socket(String string, int n, boolean bl) throws IOException {
        this(InetAddress.getByName(string), n, bl);
    }

    public Socket(InetAddress inetAddress, int n, boolean bl) throws IOException {
        this.impl = factory.createSocketImpl();
        this.impl.create(bl);
        this.impl.connect(inetAddress, n);
    }

    protected Socket() {
        this.impl = factory.createSocketImpl();
    }

    public synchronized void close() throws IOException {
        this.impl.close();
    }

    public InetAddress getInetAddress() {
        return this.impl.getInetAddress();
    }

    public InputStream getInputStream() throws IOException {
        return this.impl.getInputStream();
    }

    public int getLocalPort() {
        return this.impl.getLocalPort();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.impl.getOutputStream();
    }

    public int getPort() {
        return this.impl.getPort();
    }

    public InetAddress getLocalAddress() {
        try {
            return (InetAddress)this.impl.getOption(15);
        }
        catch (SocketException socketException) {
            try {
                return InetAddress.getByName("0.0.0.0");
            }
            catch (UnknownHostException unknownHostException) {
                return null;
            }
        }
    }

    public static synchronized void setSocketImplFactory(SocketImplFactory socketImplFactory) throws IOException {
        factory = socketImplFactory;
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        if (bl) {
            this.impl.setOption(128, new Integer(n));
        } else {
            this.impl.setOption(128, new Boolean(bl));
        }
    }

    public int getSoLinger() throws SocketException {
        return (Integer)this.impl.getOption(128);
    }

    public void setSoTimeout(int n) throws SocketException {
        this.impl.setOption(4102, new Integer(n));
    }

    public int getSoTimeout() throws SocketException {
        return (Integer)this.impl.getOption(4102);
    }

    public void setSendBufferSize(int n) throws SocketException {
        this.impl.setOption(4097, new Integer(n));
    }

    public int getSendBufferSize() throws SocketException {
        return (Integer)this.impl.getOption(4097);
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        this.impl.setOption(4098, new Integer(n));
    }

    public int getReceiveBufferSize() throws SocketException {
        return (Integer)this.impl.getOption(4098);
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.impl.setOption(1, new Boolean(bl));
    }

    public boolean getTcpNoDelay() throws SocketException {
        return (Boolean)this.impl.getOption(1);
    }

    public String toString() {
        return this.impl.toString();
    }
}

