/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public class MulticastSocket
extends DatagramSocket {
    private InetAddress iface = InetAddress.getLocalHost();

    public MulticastSocket() throws IOException {
        this(0);
    }

    public MulticastSocket(int n) throws IOException {
        super(n, null);
    }

    protected void init(int n, InetAddress inetAddress) throws SocketException {
        this.impl.setOption(4, new Boolean(true));
        super.init(n, inetAddress);
    }

    public InetAddress getInterface() throws SocketException {
        return this.iface;
    }

    public byte getTTL() throws IOException {
        return this.impl.getTTL();
    }

    public void joinGroup(InetAddress inetAddress) throws IOException {
        this.impl.join(inetAddress);
    }

    public void leaveGroup(InetAddress inetAddress) throws IOException {
        this.impl.leave(inetAddress);
    }

    public synchronized void send(DatagramPacket datagramPacket, byte by) throws IOException {
        byte by2 = this.getTTL();
        this.setTTL(by);
        super.send(datagramPacket);
        this.setTTL(by2);
    }

    public void setInterface(InetAddress inetAddress) throws SocketException {
        this.iface = inetAddress;
    }

    public void setTTL(byte by) throws IOException {
        this.impl.setTTL(by);
    }
}

