/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Float
extends Number {
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float NaN = 0.0f / 0.0f;
    public static final float MIN_VALUE = Float.intBitsToFloat(1);
    public static final float MAX_VALUE = Float.intBitsToFloat(0x7F7FFFFF);
    public static final Class TYPE = Class.getPrimitiveClass("float");
    private static final int NUM_MANTISSA_BITS = 23;
    private static final int EXPONENT_MASK = 2139095040;
    private static final int MANTISSA_MASK = 0x7FFFFF;
    private final float value;
    private static final long serialVersionUID = -2671257302660747028L;

    public static native int floatToIntBits(float var0);

    public static native float intBitsToFloat(int var0);

    public Float(float f) {
        this.value = f;
    }

    public Float(double d) {
        this.value = (float)d;
    }

    public Float(String string) throws NumberFormatException {
        this.value = Float.valueOf((String)string).value;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Float) {
            int n = Float.floatToIntBits(this.value);
            int n2 = Float.floatToIntBits(((Float)object).value);
            int n3 = Float.floatToIntBits(Float.POSITIVE_INFINITY);
            int n4 = Float.floatToIntBits(Float.NEGATIVE_INFINITY);
            if (this.isNaN() && ((Float)object).isNaN()) {
                return true;
            }
            if (n == n3 && n2 == n3 || n == n4 && n2 == n4) {
                return true;
            }
            return n == n2;
        }
        return false;
    }

    public int hashCode() {
        return this.intValue();
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public static String toString(float f) {
        int n;
        if (Float.isNaN(f)) {
            return "NaN";
        }
        if (f == Float.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        int n2 = Float.floatToIntBits(f);
        if ((n2 & 0x7F800000) == 0) {
            int n3;
            for (n3 = 22; n3 > 0 && (1 << n3 & n2) == 0; --n3) {
            }
            n = Double.bitsToDecimal[n3];
        } else {
            n = Double.bitsToDecimal[22];
        }
        return Double.toStringWithPrecision(f, ++n);
    }

    public String toString() {
        return Float.toString(this.value);
    }

    public static boolean isNaN(float f) {
        int n = Float.floatToIntBits(f);
        return (n & 0x7F800000) == 2139095040 && (n & 0x7FFFFF) != 0;
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public static boolean isInfinite(float f) {
        return Float.floatToIntBits(f) == Float.floatToIntBits(Float.POSITIVE_INFINITY) || Float.floatToIntBits(f) == Float.floatToIntBits(Float.NEGATIVE_INFINITY);
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public static Float valueOf(String string) throws NumberFormatException {
        if (string == null) {
            throw new NullPointerException();
        }
        return new Float(Double.valueOf0(string));
    }

    public static float parseFloat(String string) throws NumberFormatException {
        if (string == null) {
            throw new NullPointerException();
        }
        return (float)Double.valueOf0(string);
    }
}

