/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PushbackReader;
import java.io.Reader;

public class StreamTokenizer {
    public static final int TT_EOF = -1;
    public static final int TT_EOL = 10;
    public static final int TT_NUMBER = -2;
    public static final int TT_WORD = -3;
    public int ttype;
    public String sval;
    public double nval;
    private PushbackReader pushIn;
    private LineNumberReader lineIn;
    private Reader rawIn;
    private TableEntry[] lookup = new TableEntry[256];
    private TableEntry ordinary = new TableEntry();
    private boolean pushBack = false;
    private boolean EOLSignificant;
    private boolean CComments;
    private boolean CPlusPlusComments;
    private boolean toLower;
    private StringBuffer buffer = new StringBuffer();
    private boolean endOfFile;

    public StreamTokenizer(InputStream inputStream) {
        this(new InputStreamReader(inputStream));
    }

    public StreamTokenizer(Reader reader) {
        this.rawIn = reader;
        this.lineIn = new LineNumberReader(this.rawIn);
        this.pushIn = new PushbackReader(this.lineIn);
        for (int i = 0; i < this.lookup.length; ++i) {
            this.lookup[i] = new TableEntry();
        }
        this.init();
    }

    private int chrRead() throws IOException {
        if (this.endOfFile) {
            return -1;
        }
        return this.pushIn.read();
    }

    private void unRead(int n) throws IOException {
        if (n == -1) {
            this.endOfFile = true;
        } else {
            this.pushIn.unread(n);
        }
    }

    public void commentChar(int n) {
        if (n >= 0 && n <= 255) {
            this.lookup(n).access$001(true);
        }
    }

    public void eolIsSignificant(boolean bl) {
        this.EOLSignificant = bl;
    }

    public int lineno() {
        return this.lineIn.getLineNumber();
    }

    public void lowerCaseMode(boolean bl) {
        this.toLower = bl;
    }

    public int nextToken() throws IOException {
        if (this.pushBack) {
            this.pushBack = false;
            return this.ttype;
        }
        return this.nextTokenType();
    }

    private int nextTokenType() throws IOException {
        int n = this.chrRead();
        if (n == 47 && (this.CComments || this.CPlusPlusComments)) {
            int n2 = this.chrRead();
            if (n2 == 47 && this.CPlusPlusComments) {
                this.skipLine();
                this.nextTokenType();
                return this.ttype;
            }
            if (n2 == 42 && this.CComments) {
                this.skipCComment();
                this.nextTokenType();
                return this.ttype;
            }
            this.unRead(n2);
        }
        if (n == 10 && this.EOLSignificant) {
            this.sval = null;
            this.ttype = 10;
            return this.ttype;
        }
        TableEntry tableEntry = this.lookup(n);
        if (tableEntry.access$100()) {
            while (this.lookup(n).access$100()) {
                n = this.chrRead();
                if (n != 10 || !this.EOLSignificant) continue;
                this.ttype = 10;
                return this.ttype;
            }
            this.unRead(n);
            this.ttype = this.nextTokenType();
        } else if (tableEntry.access$200()) {
            this.buffer.setLength(0);
            while (this.lookup(n).access$200()) {
                this.buffer.append((char)n);
                n = this.chrRead();
                if (n != 10 || !this.EOLSignificant) continue;
                break;
            }
            this.unRead(n);
            try {
                this.nval = new Double(this.buffer.toString());
                this.ttype = -2;
            }
            catch (NumberFormatException numberFormatException) {
                this.ttype = -3;
                this.sval = this.buffer.toString();
                if (this.toLower) {
                    this.sval = this.sval.toLowerCase();
                }
            }
        } else if (tableEntry.access$300()) {
            this.buffer.setLength(0);
            while (this.lookup(n).access$300() || this.lookup(n).access$200()) {
                this.buffer.append((char)n);
                n = this.chrRead();
                if (n != 10 || !this.EOLSignificant) continue;
                break;
            }
            this.unRead(n);
            this.ttype = -3;
            this.sval = this.buffer.toString();
            if (this.toLower) {
                this.sval = this.sval.toLowerCase();
            }
        } else if (tableEntry.access$400()) {
            int n3 = n;
            this.buffer.setLength(0);
            n = this.chrRead();
            while (n != n3) {
                if (n == 92) {
                    n = this.chrRead();
                    switch (n) {
                        case 97: {
                            n = 7;
                            break;
                        }
                        case 98: {
                            n = 8;
                            break;
                        }
                        case 102: {
                            n = 12;
                            break;
                        }
                        case 110: {
                            n = 10;
                            break;
                        }
                        case 114: {
                            n = 13;
                            break;
                        }
                        case 116: {
                            n = 9;
                            break;
                        }
                        case 118: {
                            n = 11;
                        }
                    }
                }
                this.buffer.append((char)n);
                n = this.chrRead();
                if (n != -1) continue;
                break;
            }
            this.ttype = n3;
            this.sval = this.buffer.toString();
        } else if (tableEntry.access$000()) {
            this.skipLine();
            this.ttype = this.nextTokenType();
        } else {
            this.sval = null;
            this.ttype = n == -1 ? -1 : n;
        }
        return this.ttype;
    }

    public void ordinaryChar(int n) {
        if (n >= 0 && n <= 255) {
            TableEntry tableEntry = this.lookup(n);
            tableEntry.access$301(false);
            tableEntry.access$401(false);
            tableEntry.access$201(false);
            tableEntry.access$001(false);
            tableEntry.access$101(false);
        }
    }

    public void ordinaryChars(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this.ordinaryChar(i);
        }
    }

    public void parseNumbers() {
        for (int i = 48; i <= 57; ++i) {
            this.lookup(i).access$201(true);
        }
        this.lookup(46).access$201(true);
        this.lookup(45).access$201(true);
    }

    public void pushBack() {
        this.pushBack = true;
    }

    public void quoteChar(int n) {
        if (n >= 0 && n <= 255) {
            this.lookup(n).access$401(true);
        }
    }

    private void init() {
        this.wordChars(65, 90);
        this.wordChars(97, 122);
        this.wordChars(160, 255);
        this.whitespaceChars(0, 32);
        this.parseNumbers();
        this.commentChar(47);
        this.quoteChar(39);
        this.quoteChar(34);
        this.EOLSignificant = false;
        this.CComments = false;
        this.CPlusPlusComments = false;
        this.toLower = false;
    }

    public void resetSyntax() {
        this.ordinaryChars(0, 255);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void skipCComment() throws IOException {
        while (true) {
            int n;
            if ((n = this.chrRead()) == 42) {
                int n2 = this.chrRead();
                if (n2 == 47) return;
                this.unRead(n2);
                continue;
            }
            if (n == -1) return;
        }
    }

    private void skipLine() throws IOException {
        while (this.chrRead() != 10) {
        }
        if (this.EOLSignificant) {
            this.unRead(10);
        }
    }

    public void slashSlashComments(boolean bl) {
        this.CPlusPlusComments = bl;
    }

    public void slashStarComments(boolean bl) {
        this.CComments = bl;
    }

    public String toString() {
        if (this.ttype == -1) {
            return "EOF";
        }
        if (this.ttype == 10) {
            return "EOL";
        }
        if (this.ttype == -2) {
            return String.valueOf(String.valueOf(String.valueOf("Token[n=").concat(String.valueOf(this.nval))).concat(String.valueOf("], line "))).concat(String.valueOf(this.lineno()));
        }
        return String.valueOf(String.valueOf(String.valueOf("Token[s=").concat(String.valueOf(this.sval))).concat(String.valueOf("], line "))).concat(String.valueOf(this.lineno()));
    }

    public void whitespaceChars(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            TableEntry tableEntry = this.lookup(i);
            tableEntry.access$101(true);
            tableEntry.access$301(false);
            tableEntry.access$201(false);
        }
    }

    public void wordChars(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this.lookup(i).access$301(true);
        }
    }

    private TableEntry lookup(int n) {
        if (n < 0 || n > 255) {
            return this.ordinary;
        }
        return this.lookup[n];
    }

    class TableEntry {
        private boolean isNumeric = false;
        private boolean isWhitespace = false;
        private boolean isAlphabetic = false;
        private boolean isStringQuote = false;
        private boolean isComment = false;

        TableEntry() {
        }

        final /* synthetic */ boolean access$000() {
            return this.isComment;
        }

        final /* synthetic */ boolean access$001(boolean bl) {
            this.isComment = bl;
            return this.isComment;
        }

        final /* synthetic */ boolean access$400() {
            return this.isStringQuote;
        }

        final /* synthetic */ boolean access$401(boolean bl) {
            this.isStringQuote = bl;
            return this.isStringQuote;
        }

        final /* synthetic */ boolean access$300() {
            return this.isAlphabetic;
        }

        final /* synthetic */ boolean access$301(boolean bl) {
            this.isAlphabetic = bl;
            return this.isAlphabetic;
        }

        final /* synthetic */ boolean access$100() {
            return this.isWhitespace;
        }

        final /* synthetic */ boolean access$101(boolean bl) {
            this.isWhitespace = bl;
            return this.isWhitespace;
        }

        final /* synthetic */ boolean access$200() {
            return this.isNumeric;
        }

        final /* synthetic */ boolean access$201(boolean bl) {
            this.isNumeric = bl;
            return this.isNumeric;
        }
    }
}

