/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import kaffe.io.ObjectInputStreamImpl;
import kaffe.util.NotImplemented;

public class ObjectInputStream
extends InputStream
implements ObjectInput,
ObjectStreamConstants {
    private ObjectInputStreamImpl in;
    private boolean enableResolve = false;
    private Object currentObject;
    private ObjectStreamClass currentStreamClass;

    public ObjectInputStream(InputStream inputStream) throws IOException, StreamCorruptedException {
        this.in = ObjectStreamClass.factory.newObjectInputStreamImpl(inputStream, this);
        this.readStreamHeader();
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    protected final boolean enableResolveObject(boolean bl) throws SecurityException {
        boolean bl2 = this.enableResolve;
        this.enableResolve = bl;
        return bl2;
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.in.read(byArray, n, n2);
    }

    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    public char readChar() throws IOException {
        return this.in.readChar();
    }

    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.in.readFully(byArray, n, n2);
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public String readLine() throws IOException {
        return this.in.readLine();
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    public short readShort() throws IOException {
        return this.in.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    public String readUTF() throws IOException {
        return this.in.readUTF();
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        this.in.readStreamHeader();
    }

    public synchronized void registerValidation(ObjectInputValidation objectInputValidation, int n) throws NotActiveException, InvalidObjectException {
        throw new NotImplemented();
    }

    protected Object resolveObject(Object object) throws IOException {
        return object;
    }

    public int skipBytes(int n) throws IOException {
        return this.in.skipBytes(n);
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        return Class.forName(objectStreamClass.getName());
    }

    public final Class resolveClassInternal(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        return this.resolveClass(objectStreamClass);
    }

    public final Object readObject() throws OptionalDataException, ClassNotFoundException, IOException {
        Object object = this.in.readObject();
        if (this.enableResolve) {
            object = this.resolveObject(object);
        }
        return object;
    }

    public final void defaultReadObject() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.currentObject == null || this.currentStreamClass == null) {
            throw new NotActiveException();
        }
        this.in.defaultReadObject(this.currentObject, this.currentStreamClass);
    }
}

