/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;

public class BufferedWriter
extends Writer {
    private static final int DEFAULTBUFFERSIZE = 1024;
    private static final String newline = System.getProperty("line.separator");
    private Writer wr;
    private char[] wrbuf;
    private int pos;
    private int size;

    public BufferedWriter(Writer writer) {
        this(writer, 1024);
    }

    public BufferedWriter(Writer writer, int n) {
        this.wr = writer;
        this.wrbuf = new char[n];
        this.pos = 0;
        this.size = n;
    }

    public void write(int n) throws IOException {
        char[] cArray = new char[]{(char)n};
        this.write(cArray, 0, 1);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                while (true) {
                    int n3;
                    for (n3 = 0; n3 < this.size && n3 < n2; ++n3) {
                        this.wrbuf[this.pos++] = cArray[n++];
                    }
                    this.size -= n3;
                    if (n3 == n2) {
                        Object var7_6 = null;
                        return;
                    }
                    n2 -= n3;
                    this.flush();
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                throw throwable;
            }
        }
    }

    public void write(String string, int n, int n2) throws IOException {
        this.write(string.toCharArray(), n, n2);
    }

    public void newLine() throws IOException {
        this.write(newline);
    }

    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.wr.write(this.wrbuf, 0, this.pos);
                this.wr.flush();
                this.pos = 0;
                this.size = this.wrbuf.length;
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }
    }

    public void close() throws IOException {
        this.flush();
        this.wr.close();
    }
}

