/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.ShortcutConsumer;
import java.awt.event.KeyEvent;
import java.util.Hashtable;

class ShortcutHandler {
    static MenuShortcut[] codeTable = new MenuShortcut[160];
    static Hashtable tgtTable = new Hashtable();

    static void addShortcut(MenuShortcut menuShortcut, Component component, ShortcutConsumer shortcutConsumer) {
        menuShortcut.consumer = shortcutConsumer;
        menuShortcut.next = null;
        MenuShortcut menuShortcut2 = (MenuShortcut)tgtTable.get(component);
        if (menuShortcut2 == null) {
            tgtTable.put(component, menuShortcut);
        } else {
            while (menuShortcut2.next != null) {
                menuShortcut2 = menuShortcut2.next;
            }
            menuShortcut2.next = menuShortcut;
        }
    }

    static void buildCodeTable(Component component) {
        int n = codeTable.length;
        for (int i = 0; i < n; ++i) {
            ShortcutHandler.codeTable[i] = null;
        }
        if (component == null) {
            return;
        }
        Component component2 = component;
        while (component2 != null) {
            MenuShortcut menuShortcut = (MenuShortcut)tgtTable.get(component2);
            while (menuShortcut != null) {
                menuShortcut.nextMod = null;
                MenuShortcut menuShortcut2 = codeTable[menuShortcut.keyCode];
                if (menuShortcut2 == null) {
                    ShortcutHandler.codeTable[menuShortcut.keyCode] = menuShortcut;
                } else {
                    while (menuShortcut2.nextMod != null) {
                        menuShortcut2 = menuShortcut2.nextMod;
                    }
                    menuShortcut2.nextMod = menuShortcut;
                }
                menuShortcut = menuShortcut.next;
            }
            component2 = component2.parent;
        }
    }

    static void focusNext(Container container) {
        Component component = null;
        Component component2 = AWTEvent.keyTgt;
        if (component2 == null || component2 == container) {
            component = ShortcutHandler.focusNext(container, null);
        } else {
            Component component3 = component2;
            while (component3.parent != null && (component = ShortcutHandler.focusNext(component3.parent, component3)) == null) {
                component3 = component3.parent;
            }
            if (component == null) {
                component = ShortcutHandler.focusNext(container, null);
            }
        }
        if (component != null) {
            component.requestFocus();
        }
    }

    static Component focusNext(Container container, Component component) {
        int n = -1;
        if (component != null) {
            for (n = 0; n < container.nChildren && container.children[n] != component; ++n) {
            }
        }
        ++n;
        while (n < container.nChildren) {
            Component component2;
            Component component3 = container.children[n];
            if (component3 instanceof Container && ((component3.flags & 0x100) == 0 || component3 instanceof Panel) && (component2 = ShortcutHandler.focusNext((Container)component3, null)) != null) {
                return component2;
            }
            if (component3.isFocusTraversable()) {
                return component3;
            }
            ++n;
        }
        return container.isFocusTraversable() && component == null ? container : null;
    }

    static void focusPrev(Container container) {
        Component component = null;
        Component component2 = AWTEvent.keyTgt;
        if (component2 == null || component2 == container) {
            component = ShortcutHandler.focusPrev(container, null);
        } else {
            Component component3 = component2;
            while (component3.parent != null && (component = ShortcutHandler.focusPrev(component3.parent, component3)) == null) {
                component3 = component3.parent;
            }
            if (component == null) {
                component = ShortcutHandler.focusPrev(container, null);
            }
        }
        if (component != null) {
            component.requestFocus();
        }
    }

    static Component focusPrev(Container container, Component component) {
        int n = container.nChildren;
        if (component != null) {
            for (n = container.nChildren - 1; n >= 0 && container.children[n] != component; --n) {
            }
        }
        --n;
        while (n >= 0) {
            Component component2;
            Component component3 = container.children[n];
            if (component3 instanceof Container && ((component3.flags & 0x100) == 0 || component3 instanceof Panel) && (component2 = ShortcutHandler.focusPrev((Container)component3, null)) != null) {
                return component2;
            }
            if (component3.isFocusTraversable()) {
                return component3;
            }
            --n;
        }
        return container.isFocusTraversable() && component == null ? container : null;
    }

    static boolean handle(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        int n2 = keyEvent.getKeyCode();
        if ((n & 2) > 0 && n2 >= 1 && n2 <= 26) {
            n2 += 64;
        }
        if (n2 >= codeTable.length) {
            return false;
        }
        MenuShortcut menuShortcut = codeTable[n2];
        while (menuShortcut != null) {
            if (menuShortcut.mods == n) {
                menuShortcut.process();
                return true;
            }
            menuShortcut = menuShortcut.nextMod;
        }
        char c = keyEvent.getKeyChar();
        Component component = (Component)keyEvent.getSource();
        boolean bl = keyEvent.isShiftDown();
        Container container = (Container)AWTEvent.keyTgt.getToplevel();
        switch (c) {
            case '\t': {
                if (bl) {
                    ShortcutHandler.focusPrev(container);
                } else {
                    ShortcutHandler.focusNext(container);
                }
                return true;
            }
        }
        return false;
    }

    static void removeFromOwner(Component component, MenuShortcut menuShortcut) {
        MenuShortcut menuShortcut2 = null;
        MenuShortcut menuShortcut3 = (MenuShortcut)tgtTable.get(component);
        while (menuShortcut3 != null) {
            if (menuShortcut == menuShortcut3) {
                if (menuShortcut2 == null) {
                    if (menuShortcut.next == null) {
                        tgtTable.remove(component);
                    } else {
                        tgtTable.put(component, menuShortcut.next);
                    }
                } else {
                    menuShortcut2.next = menuShortcut.next;
                }
                return;
            }
            menuShortcut2 = menuShortcut3;
            menuShortcut3 = menuShortcut3.next;
        }
    }

    static void removeFromOwner(Component component, ShortcutConsumer shortcutConsumer) {
        MenuShortcut menuShortcut = null;
        MenuShortcut menuShortcut2 = (MenuShortcut)tgtTable.get(component);
        while (menuShortcut2 != null) {
            if (menuShortcut2.consumer == shortcutConsumer) {
                if (menuShortcut == null) {
                    if (menuShortcut2.next == null) {
                        tgtTable.remove(component);
                        return;
                    }
                    tgtTable.put(component, menuShortcut2.next);
                } else {
                    menuShortcut.next = menuShortcut2.next;
                }
            }
            menuShortcut = menuShortcut2;
            menuShortcut2 = menuShortcut2.next;
        }
    }

    static void removeShortcuts(Component component) {
        tgtTable.remove(component);
    }

    static int size() {
        return tgtTable.size();
    }

    ShortcutHandler() {
    }
}

