/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.NativeGraphics;

class PaintEvent
extends AWTEvent {
    long issued;
    long ms;
    int x;
    int y;
    int width;
    int height;
    static PaintEvent cache;
    public static final int PAINT_FIRST = 800;
    public static final int PAINT = 800;
    public static final int UPDATE = 801;
    public static final int REPAINT = 802;
    public static final int PAINT_LAST = 802;

    PaintEvent(Component component, int n, long l, int n2, int n3, int n4, int n5) {
        super(component, n);
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
        this.ms = l;
        this.issued = -1L;
    }

    protected void dispatch() {
        Component component = (Component)this.source;
        NativeGraphics nativeGraphics = NativeGraphics.getClippedGraphics(null, component, 0, 0, this.x, this.y, this.width, this.height, true);
        if (nativeGraphics != null) {
            component.update(nativeGraphics);
            nativeGraphics.dispose();
        }
        this.recycle();
    }

    static synchronized PaintEvent getEvent(Component component, int n, long l, int n2, int n3, int n4, int n5) {
        if (cache == null) {
            return new PaintEvent(component, n, l, n2, n3, n4, n5);
        }
        PaintEvent paintEvent = cache;
        cache = (PaintEvent)paintEvent.next;
        paintEvent.next = null;
        paintEvent.source = component;
        paintEvent.id = n;
        paintEvent.x = n2;
        paintEvent.y = n3;
        paintEvent.width = n4;
        paintEvent.height = n5;
        paintEvent.ms = l;
        paintEvent.issued = -1L;
        return paintEvent;
    }

    static synchronized PaintEvent getEvent(int n, int n2, int n3, int n4, int n5, int n6) {
        Component component = AWTEvent.sources[n];
        n3 += component.deco.x;
        n4 += component.deco.y;
        if (cache == null) {
            return new PaintEvent(component, n2, 0L, n3, n4, n5, n6);
        }
        PaintEvent paintEvent = cache;
        cache = (PaintEvent)paintEvent.next;
        paintEvent.next = null;
        paintEvent.source = component;
        paintEvent.id = n2;
        paintEvent.ms = 0L;
        paintEvent.issued = -1L;
        paintEvent.x = n3;
        paintEvent.y = n4;
        paintEvent.width = n5;
        paintEvent.height = n6;
        return paintEvent;
    }

    public String paramString() {
        String string;
        switch (this.id) {
            case 800: {
                string = "PAINT";
                break;
            }
            case 801: {
                string = "UPDATE";
                break;
            }
            case 802: {
                string = "REPAINT";
                break;
            }
            default: {
                string = String.valueOf("unknown paint ").concat(String.valueOf(this.id));
            }
        }
        string = String.valueOf(string).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(" [").concat(String.valueOf(this.x))).concat(String.valueOf(','))).concat(String.valueOf(this.y))).concat(String.valueOf(','))).concat(String.valueOf(this.width))).concat(String.valueOf(','))).concat(String.valueOf(this.height))).concat(String.valueOf(']'))));
        return string;
    }

    protected void recycle() {
        Class clazz = Class.forName("java.awt.PaintEvent");
        synchronized (clazz) {
            try {
                this.source = null;
                this.next = cache;
                cache = this;
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }
    }

    boolean solicitRepaint(Component component, int n, int n2, int n3, int n4) {
        if (component != this.source) {
            return false;
        }
        int n5 = this.x + this.width;
        int n6 = this.x + this.height;
        int n7 = n + n3;
        int n8 = n2 + n4;
        if (n < this.x) {
            this.x = n;
        }
        if (n2 < this.y) {
            this.y = n2;
        }
        this.width = (n7 > n5 ? n7 : n5) - this.x;
        this.height = (n8 > n6 ? n8 : n6) - this.y;
        return true;
    }
}

