/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.ActionEvt;
import java.awt.Color;
import java.awt.Defaults;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuShortcut;
import java.awt.ShortcutConsumer;
import java.awt.ShortcutHandler;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class MenuItem
extends MenuComponent
implements ShortcutConsumer {
    MenuShortcut shortcut;
    String label;
    ActionListener aListener;
    String aCmd;
    int eventMask;
    static MenuItem separator = new MenuItem("-");
    private static final long serialVersionUID = -21757335363267194L;

    public MenuItem() {
        this(null, null);
    }

    public MenuItem(String string) {
        this(string, null);
    }

    public MenuItem(String string, MenuShortcut menuShortcut) {
        this.setShortcut(menuShortcut);
        this.setLabel(string);
        this.setFont(MenuComponent.defFnt);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (!this.isSeparator()) {
            this.aListener = AWTEventMulticaster.add(this.aListener, actionListener);
        }
    }

    public void addNotify() {
        if ((this.flags & 0x400) == 0) {
            if (this.shortcut != null) {
                ShortcutHandler.addShortcut(this.shortcut, this.owner, this);
            }
            this.flags |= 0x400;
        }
    }

    Vector addShortcuts(Vector vector) {
        if (this.shortcut != null) {
            vector.addElement(this.shortcut);
        }
        return vector;
    }

    public void deleteShortcut() {
        if ((this.flags & 0x400) > 0 && this.shortcut != null) {
            ShortcutHandler.removeFromOwner(this.owner, this.shortcut);
        }
        this.shortcut = null;
    }

    public synchronized void disable() {
        this.setEnabled(false);
    }

    public void disableEvents(long l) {
        this.eventMask = (int)((long)this.eventMask & (l ^ 0L - 1L));
    }

    public synchronized void enable() {
        this.setEnabled(true);
    }

    public void enable(boolean bl) {
        this.setEnabled(bl);
    }

    public void enableEvents(long l) {
        this.eventMask = (int)((long)this.eventMask | l);
    }

    public String getActionCommand() {
        return this.aCmd != null ? this.aCmd : this.label;
    }

    int getHeight() {
        return this.isSeparator() ? 4 : this.fm.getHeight() + 4;
    }

    public String getLabel() {
        return this.label;
    }

    public MenuShortcut getShortcut() {
        return this.shortcut;
    }

    MenuItem getShortcutMenuItem(MenuShortcut menuShortcut) {
        if (menuShortcut.equals(this.shortcut)) {
            return this;
        }
        return null;
    }

    int getWidth() {
        return this.fm.stringWidth(this.label);
    }

    public void handleShortcut(MenuShortcut menuShortcut) {
        int n;
        int n2 = n = menuShortcut != null ? menuShortcut.mods : 0;
        if (this.aListener != null || (this.eventMask & 0x80000080) == 128 || (this.flags & 0x20) > 0) {
            Toolkit.eventQueue.postEvent(ActionEvt.getEvent(this, 1001, this.getActionCommand(), n));
            return;
        }
        MenuContainer menuContainer = this.parent;
        while (menuContainer instanceof Menu) {
            Menu menu = (Menu)menuContainer;
            if (menu.aListener != null || (menu.eventMask & 0x80000080) == 128) {
                Toolkit.eventQueue.postEvent(ActionEvt.getEvent(menu, 1001, this.getActionCommand(), n));
                return;
            }
            menuContainer = menu.parent;
        }
    }

    public boolean isEnabled() {
        return (this.eventMask & Integer.MIN_VALUE) == 0;
    }

    public boolean isSeparator() {
        return separator == this;
    }

    int paint(Graphics graphics, int n, int n2, int n3, Color color, Color color2, boolean bl) {
        int n4 = this.getHeight();
        int n5 = this.fm.getAscent();
        if (separator == this) {
            int n6 = n2 + n4 / 2;
            graphics.setColor(color);
            graphics.draw3DRect(5, n6 - 1, n3 - 10, 1, false);
        } else {
            graphics.setFont(this.fnt);
            if ((this.eventMask & Integer.MIN_VALUE) == 0) {
                if (Defaults.MenuTxtCarved) {
                    graphics.setColor(Color.white);
                    graphics.drawString(this.label, n + 1, n2 + n5 + 1);
                }
                graphics.setColor(bl ? Defaults.MenuSelTxtClr : color2);
            } else {
                graphics.setColor(color.darker());
            }
            graphics.drawString(this.label, n, n2 + n5);
        }
        return n4;
    }

    public String paramString() {
        return String.valueOf(String.valueOf(String.valueOf(this.getClass().getName()).concat(String.valueOf("[Label: "))).concat(String.valueOf(this.label))).concat(String.valueOf("]"));
    }

    void process(ActionEvent actionEvent) {
        if (this.aListener != null || (this.eventMask & 0x80000080) == 128) {
            this.processEvent(actionEvent);
        }
        if ((this.flags & 0x20) > 0) {
            this.postEvent(Event.getEvent(actionEvent));
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.aListener != null) {
            this.aListener.actionPerformed(actionEvent);
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent.id == 1001) {
            this.processActionEvent((ActionEvent)aWTEvent);
        }
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.aListener = AWTEventMulticaster.remove(this.aListener, actionListener);
    }

    public void removeNotify() {
        if ((this.flags & 0x400) > 0) {
            if (this.shortcut != null) {
                ShortcutHandler.removeFromOwner(this.owner, this.shortcut);
            }
            this.flags &= 0xFFFFFBFF;
            this.owner = null;
            this.parent = null;
        }
    }

    public void setActionCommand(String string) {
        this.aCmd = string;
    }

    public synchronized void setEnabled(boolean bl) {
        this.eventMask = bl ? (this.eventMask &= Integer.MAX_VALUE) : (this.eventMask |= Integer.MIN_VALUE);
    }

    public synchronized void setLabel(String string) {
        this.label = string;
    }

    public void setShortcut(MenuShortcut menuShortcut) {
        MenuShortcut menuShortcut2;
        MenuShortcut menuShortcut3 = menuShortcut2 = menuShortcut != null ? new MenuShortcut(menuShortcut) : null;
        if ((this.flags & 0x400) > 0) {
            if (this.shortcut != null) {
                ShortcutHandler.removeFromOwner(this.owner, this.shortcut);
            }
            if (menuShortcut2 != null) {
                ShortcutHandler.addShortcut(menuShortcut2, this.owner, this);
            }
        }
        this.shortcut = menuShortcut2;
    }
}

