/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.ActionEvt;
import java.awt.ClassAnalyzer;
import java.awt.ClassProperties;
import java.awt.Color;
import java.awt.Container;
import java.awt.Defaults;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.ItemEvt;
import java.awt.ItemSelectable;
import java.awt.PopupMenu;
import java.awt.RowCanvas;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.BitSet;
import java.util.Vector;

public class List
extends Container
implements ItemSelectable {
    private static final long serialVersionUID = -3304312411574666869L;
    ActionListener aListener;
    ItemListener iListener;
    ItemPane ip = new ItemPane();
    Vector selections = new Vector(1);
    boolean multipleMode = false;
    boolean selMouse;
    int sel = -1;
    BitSet multiSel;
    int nSel;

    public List() {
        this(3, false);
    }

    public List(int n) {
        this(n, false);
    }

    public List(int n, boolean bl) {
        this.setMultipleMode(bl);
        this.setLayout(null);
        this.setForeground(Defaults.ListTxtClr);
        this.setBackground(Defaults.ListBgClr);
        this.setFont(Defaults.ListFont);
        this.ip.vScroll = new Scrollbar(1);
        this.add(this.ip.vScroll);
        this.ip.hScroll = new Scrollbar(0);
        this.add(this.ip.hScroll);
        this.add(this.ip);
        this.ip.setListeners();
    }

    public void add(PopupMenu popupMenu) {
        this.ip.add(popupMenu);
    }

    public void add(String string) {
        this.addElement(string, -1);
    }

    public synchronized void add(String string, int n) {
        this.addElement(string, n);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.aListener = AWTEventMulticaster.add(this.aListener, actionListener);
    }

    void addElement(String string, int n) {
        if (n == -1) {
            this.ip.rows.addElement(string);
        } else {
            this.ip.rows.insertElementAt(string, n);
        }
        this.ip.updateHScroll(string);
        this.ip.updateVScroll();
        if (this.isShowing()) {
            this.ip.repaint();
        }
    }

    public void addItem(String string) {
        this.addElement(string, -1);
    }

    public synchronized void addItem(String string, int n) {
        this.addElement(string, n);
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.iListener = AWTEventMulticaster.add(this.iListener, itemListener);
    }

    public boolean allowsMultipleSelections() {
        return this.multipleMode;
    }

    public synchronized void clear() {
        this.clearSelections();
        this.ip.rows.removeAllElements();
        this.ip.first = 0;
        this.ip.updateVScroll();
        this.ip.repaint();
    }

    void clearSelection(int n) {
        if (this.sel == n) {
            this.sel = -1;
        }
        if (this.multipleMode && this.multiSel.get(n)) {
            this.multiSel.clear(n);
            --this.nSel;
        }
    }

    void clearSelections() {
        this.sel = -1;
        this.nSel = 0;
        if (this.multipleMode) {
            this.nSel = 0;
            this.multiSel = new BitSet(this.ip.rows.size());
        }
    }

    public int countItems() {
        return this.ip.rows.size();
    }

    public synchronized void delItem(int n) {
        this.removeElement(n);
    }

    public synchronized void delItems(int n, int n2) {
        for (int i = n2; i >= n; --i) {
            this.remove(i);
        }
    }

    public synchronized void deselect(int n) {
        this.deselectElement(n, true);
    }

    void deselectElement(int n, boolean bl) {
        try {
            Object object = this.ip.rows.elementAt(n);
            this.clearSelection(n);
            if (bl) {
                this.ip.repaintRows(n, 1);
            }
            this.notifyItem(new Integer(n), 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doLayout() {
        this.ip.innerLayout();
    }

    public Color getBackground() {
        return this.ip.getBackground();
    }

    ClassProperties getClassProperties() {
        return ClassAnalyzer.analyzeAll(this.getClass(), true);
    }

    public Color getForeground() {
        return this.ip.getForeground();
    }

    public String getItem(int n) {
        return (String)this.ip.rows.elementAt(n);
    }

    public int getItemCount() {
        return this.countItems();
    }

    public synchronized String[] getItems() {
        String[] stringArray = new String[this.ip.rows.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)this.ip.rows.elementAt(i);
        }
        return stringArray;
    }

    public int getRows() {
        return this.ip.rows.size();
    }

    public synchronized int getSelectedIndex() {
        return this.sel;
    }

    public synchronized int[] getSelectedIndexes() {
        if (this.multipleMode) {
            if (this.nSel == 0) {
                return new int[0];
            }
            if (this.nSel == 1 && this.sel >= 0) {
                int[] nArray = new int[]{this.sel};
                return nArray;
            }
            int[] nArray = new int[this.nSel];
            int n = Math.min(this.ip.rows.size(), this.multiSel.size());
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (!this.multiSel.get(i)) continue;
                nArray[n2++] = i;
                if (n2 == this.nSel) break;
            }
            return nArray;
        }
        if (this.sel >= 0) {
            int[] nArray = new int[]{this.sel};
            return nArray;
        }
        return new int[0];
    }

    public synchronized String getSelectedItem() {
        if (this.sel >= 0) {
            return (String)this.ip.rows.elementAt(this.sel);
        }
        if (this.nSel > 0) {
            int n = Math.min(this.multiSel.size(), this.ip.rows.size());
            for (int i = 0; i < n; ++i) {
                if (!this.multiSel.get(i)) continue;
                return (String)this.ip.rows.elementAt(i);
            }
        }
        return null;
    }

    public synchronized String[] getSelectedItems() {
        if (this.multipleMode) {
            if (this.nSel == 0) {
                return new String[0];
            }
            if (this.nSel == 1 && this.sel >= 0) {
                String[] stringArray = new String[]{(String)this.ip.rows.elementAt(this.sel)};
                return stringArray;
            }
            String[] stringArray = new String[this.nSel];
            int n = Math.min(this.ip.rows.size(), this.multiSel.size());
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (!this.multiSel.get(i)) continue;
                stringArray[n2++] = (String)this.ip.rows.elementAt(i);
                if (n2 == this.nSel) break;
            }
            return stringArray;
        }
        if (this.sel >= 0) {
            String[] stringArray = new String[]{(String)this.ip.rows.elementAt(this.sel)};
            return stringArray;
        }
        return new String[0];
    }

    public Object[] getSelectedObjects() {
        int[] nArray = this.getSelectedIndexes();
        Object[] objectArray = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = this.ip.rows.elementAt(nArray[i]);
        }
        return objectArray;
    }

    public int getVisibleIndex() {
        return this.ip.first;
    }

    void hPosChange() {
        this.ip.repaint();
    }

    public boolean isIndexSelected(int n) {
        return this.isSelected(n);
    }

    public boolean isMultipleMode() {
        return this.allowsMultipleSelections();
    }

    public boolean isSelected(int n) {
        if (this.sel == n) {
            return true;
        }
        if (this.multipleMode) {
            return this.multiSel.get(n);
        }
        return false;
    }

    public void makeVisible(int n) {
        this.ip.makeVisible(n);
    }

    public Dimension minimumSize() {
        return this.minimumSize(0);
    }

    public Dimension minimumSize(int n) {
        return this.preferredSize(n);
    }

    void notifyAction() {
        String string;
        String string2 = string = this.sel >= 0 ? (String)this.ip.rows.elementAt(this.sel) : null;
        if (string != null && (this.aListener != null || (this.eventMask & 0x80) != 0)) {
            Toolkit.eventQueue.postEvent(ActionEvt.getEvent(this, 1001, string, 0));
        }
    }

    void notifyItem(Object object, int n) {
        if (this.iListener != null || (this.eventMask & 0x200) != 0 || (this.flags & 0x20) != 0) {
            Toolkit.eventQueue.postEvent(ItemEvt.getEvent(this, 701, object, n));
        }
    }

    public void paint(Graphics graphics) {
        graphics.paintChild(this.ip, false);
        if (this.ip.hScroll != null && (this.ip.hScroll.flags & 1) != 0) {
            graphics.paintChild(this.ip.hScroll, true);
        }
        if (this.ip.vScroll != null && (this.ip.vScroll.flags & 1) != 0) {
            graphics.paintChild(this.ip.vScroll, true);
        }
    }

    protected String paramString() {
        return super.paramString();
    }

    public Dimension preferredSize() {
        int n = this.ip.rows.size();
        if (n < 5) {
            n = 5;
        } else if (n > 10) {
            n = 10;
        }
        return this.preferredSize(n);
    }

    public Dimension preferredSize(int n) {
        int n2 = n * this.ip.rowHeight;
        int n3 = 25 * this.ip.fm.charWidth('x');
        return new Dimension(n3, n2);
    }

    void process(ActionEvent actionEvent) {
        if (this.aListener != null || (this.eventMask & 0x80) != 0) {
            this.processEvent(actionEvent);
        }
    }

    void process(ItemEvent itemEvent) {
        if (this.iListener != null || (this.eventMask & 0x200) != 0) {
            this.processEvent(itemEvent);
        }
        if ((this.flags & 0x20) != 0) {
            this.postEvent(Event.getEvent(itemEvent));
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.aListener != null) {
            this.aListener.actionPerformed(actionEvent);
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.iListener != null) {
            this.iListener.itemStateChanged(itemEvent);
        }
    }

    public synchronized void remove(String string) {
        this.removeElement(this.ip.rows.indexOf(string));
    }

    public synchronized void remove(int n) {
        this.removeElement(n);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.aListener = AWTEventMulticaster.remove(this.aListener, actionListener);
    }

    public synchronized void removeAll() {
        this.clear();
    }

    void removeElement(int n) {
        try {
            this.deselectElement(n, false);
            this.ip.rows.removeElementAt(n);
            this.ip.updateVScroll();
            this.ip.repaintRows(n, this.ip.getVisibleRows());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void removeHScroll() {
        this.ip.hScroll = null;
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.iListener = AWTEventMulticaster.remove(this.iListener, itemListener);
    }

    public synchronized void repaintRow(int n) {
        this.ip.repaintItem(n);
    }

    public synchronized void replaceItem(String string, int n) {
        try {
            Object object = this.ip.rows.elementAt(n);
            this.ip.rows.setElementAt(string, n);
            this.ip.repaintRows(n, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void requestFocus() {
        this.ip.requestFocus();
    }

    public void select(int n) {
        if (n < 0 || n > this.ip.rows.size() - 1) {
            return;
        }
        if (this.isIndexSelected(n)) {
            return;
        }
        if (this.multipleMode) {
            this.sel = n;
            this.multiSel.set(n);
            ++this.nSel;
        } else if (this.sel >= 0) {
            int n2 = this.sel;
            this.sel = n;
            this.ip.repaintRows(n2, 1);
            this.notifyItem(new Integer(n2), 2);
        } else {
            this.sel = n;
        }
        this.ip.makeVisible(n);
        this.ip.repaintRows(n, 1);
        this.notifyItem(new Integer(n), 1);
    }

    public void setBackground(Color color) {
        this.ip.setBackground(color);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.ip.updateVScroll();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.ip.setEnabled(bl);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.ip.setFont(font);
        this.ip.updateVScroll();
    }

    public void setForeground(Color color) {
        this.ip.setForeground(color);
    }

    public synchronized void setMultipleMode(boolean bl) {
        this.setMultipleSelections(bl);
    }

    public synchronized void setMultipleSelections(boolean bl) {
        if (this.multipleMode == bl) {
            return;
        }
        if (this.multipleMode) {
            this.multiSel = null;
            this.nSel = 0;
            this.multipleMode = false;
        } else {
            this.multiSel = new BitSet();
            this.nSel = 0;
            this.multipleMode = true;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    void vPosChange(int n) {
    }

    class ItemPane
    extends RowCanvas
    implements MouseListener,
    MouseMotionListener,
    KeyListener {
        StringBuffer lnsBuf = new StringBuffer();
        int idxFlyOver = -1;

        public ItemPane() {
            this.addKeyListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addFocusListener(this);
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getModifiers();
            if (this.parent.keyListener != null) {
                this.redirectKeyEvent(keyEvent);
            }
            if (n != 0) {
                return;
            }
            List.this.selMouse = false;
            switch (keyEvent.getKeyCode()) {
                case 40: {
                    int n2 = List.this.getSelectedIndex() + 1;
                    this.makeVisible(n2);
                    List.this.select(n2);
                    break;
                }
                case 38: {
                    int n3 = List.this.getSelectedIndex() - 1;
                    this.makeVisible(n3);
                    List.this.select(n3);
                    break;
                }
                case 10: {
                    List.this.notifyAction();
                    break;
                }
                case 33: {
                    this.makeVisible(this.first - this.getVisibleRows());
                    break;
                }
                case 34: {
                    this.makeVisible(this.first + 2 * this.getVisibleRows() - 1);
                    break;
                }
                case 27: {
                    List.this.clearSelections();
                    this.repaint();
                    break;
                }
                default: {
                    return;
                }
            }
            keyEvent.consume();
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (this.parent.keyListener != null) {
                this.redirectKeyEvent(keyEvent);
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            int n = keyEvent.getModifiers();
            if (n == 0 || n == 1) {
                this.letterNav(keyEvent.getKeyChar(), keyEvent.isShiftDown());
            }
            if (this.parent.keyListener != null) {
                this.redirectKeyEvent(keyEvent);
            }
        }

        void letterNav(char c, boolean bl) {
            int n = this.rows.size();
            if (!bl) {
                this.lnsBuf.setLength(0);
            }
            this.lnsBuf.append(c);
            for (int i = 0; i < n; ++i) {
                String string = (String)this.rows.elementAt(i);
                if (!string.regionMatches(true, 0, this.lnsBuf.toString(), 0, this.lnsBuf.length())) continue;
                List.this.select(i);
                return;
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 1) {
                int n = this.getRowIdx(mouseEvent.getY());
                if (n > -1) {
                    List.this.selMouse = true;
                    if (List.this.isIndexSelected(n)) {
                        if (List.this.multipleMode) {
                            List.this.deselect(n);
                        }
                    } else {
                        List.this.select(n);
                    }
                }
            } else {
                List.this.notifyAction();
            }
            this.redirectMouseEvent(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.parent.motionListener != null) {
                this.redirectMotionEvent(mouseEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.redirectMouseEvent(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (this.rgr != null) {
                this.updateFlyOver(-1);
            }
            this.redirectMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = this.getRowIdx(mouseEvent.getY());
            if (n != this.idxFlyOver) {
                this.updateFlyOver(n);
            }
            if (this.parent.motionListener != null) {
                this.redirectMotionEvent(mouseEvent);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (AWTEvent.keyTgt != List.this.ip) {
                List.this.ip.requestFocus();
            }
            if (mouseEvent.isPopupTrigger()) {
                this.triggerPopup(mouseEvent.getX(), mouseEvent.getY());
            }
            this.redirectMouseEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.redirectMouseEvent(mouseEvent);
        }

        public void paint(Graphics graphics) {
            this.repaintRows(graphics, this.first, this.getVisibleRows());
            this.paintBorder(graphics);
        }

        void repaintItem(Graphics graphics, int n) {
            if (graphics == null) {
                return;
            }
            int n2 = 2;
            int n3 = this.xOffs + n2 + 2;
            int n4 = n2 + (n - this.first) * this.rowHeight;
            int n5 = n4 + this.rowHeight - (this.rowHeight - this.fm.getHeight()) / 2 - this.fm.getDescent();
            String string = (String)this.rows.elementAt(n);
            if (List.this.isIndexSelected(n)) {
                graphics.setColor(Defaults.ListSelBgClr);
                graphics.fill3DRect(n2, n4, this.width - 2 * n2, this.rowHeight, true);
                graphics.setColor(Defaults.ListSelTxtClr);
            } else if (n == this.idxFlyOver) {
                graphics.setColor(Defaults.ListFlyOverBgClr);
                graphics.fill3DRect(n2, n4, this.width - 2 * n2, this.rowHeight, !Defaults.ListFlyOverInset);
                graphics.setColor(Defaults.ListFlyOverTxtClr);
            } else {
                graphics.setColor(this.bgClr);
                graphics.fillRect(n2, n4, this.width - 2 * n2, this.rowHeight);
                graphics.setColor(this.fgClr);
            }
            graphics.drawString(string, n3, n5);
        }

        void repaintItem(int n) {
            this.repaintItem(this.rgr, n);
        }

        void repaintRow(Graphics graphics, int n) {
            this.repaintItem(graphics, n);
        }

        public void setFont(Font font) {
            this.fm = this.getFontMetrics(font);
            this.rowHeight = this.fm.getHeight() + 1;
            super.setFont(font);
        }

        void updateFlyOver(int n) {
            int n2 = this.idxFlyOver;
            this.idxFlyOver = n;
            if (n2 == n) {
                return;
            }
            int n3 = this.rows.size();
            if (n2 > -1 && n2 < n3) {
                this.repaintItem(n2);
            }
            if (n > -1 && n < n3) {
                this.repaintItem(n);
            }
        }

        void updateHScroll(String string) {
            int n = this.fm.stringWidth(string);
            if (this.hScroll != null && this.hScroll.getMaximum() < n) {
                this.hScroll.setMaximum(n);
            }
        }
    }
}

