/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.ContainerEvt;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.NativeGraphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;

public abstract class Container
extends Component {
    private static final long serialVersionUID = 4613797578919906343L;
    Component[] children;
    int nChildren;
    LayoutManager layoutm;
    ContainerListener cntrListener;
    Insets insets = Insets.noInsets;

    protected Container() {
    }

    public Component add(Component component) {
        this.add(component, null, -1);
        return component;
    }

    public void add(Component component, Object object) {
        this.add(component, object, -1);
    }

    public void add(Component component, Object object, int n) {
        this.addImpl(component, object, n);
    }

    public Component add(Component component, int n) {
        this.add(component, null, n);
        return component;
    }

    public Component add(String string, Component component) {
        this.add(component, string, -1);
        return component;
    }

    public void addContainerListener(ContainerListener containerListener) {
        this.cntrListener = AWTEventMulticaster.add(this.cntrListener, containerListener);
    }

    protected void addImpl(Component component, Object object, int n) {
        Object object2 = Component.treeLock;
        synchronized (object2) {
            try {
                if (n < -1 || n > this.nChildren) {
                    throw new IllegalArgumentException(String.valueOf("bad index: ").concat(String.valueOf(n)));
                }
                if (component instanceof Container && this.parent == component) {
                    throw new IllegalArgumentException("child is a bad container");
                }
                if (component.parent != null) {
                    component.parent.remove(component);
                }
                if (this.children == null) {
                    this.children = new Component[3];
                } else if (this.nChildren == this.children.length) {
                    Component[] componentArray = this.children;
                    this.children = new Component[this.nChildren * 2];
                    System.arraycopy(componentArray, 0, this.children, 0, this.nChildren);
                }
                if (n < 0 || this.nChildren == 0 || n == this.nChildren) {
                    this.children[this.nChildren] = component;
                } else if (n < this.nChildren) {
                    System.arraycopy(this.children, n, this.children, n + 1, this.nChildren - n);
                    this.children[n] = component;
                }
                ++this.nChildren;
                component.parent = this;
                if ((this.flags & 2) != 0) {
                    this.invalidate();
                }
                if ((this.flags & 0x400) != 0) {
                    component.addNotify();
                    if ((component.flags & 0x100) != 0) {
                        component.repaint();
                    }
                }
                if ((this.flags & 5) == 5) {
                    component.flags |= 4;
                    component.propagateParentShowing();
                }
                if ((component.flags & 0x1000) == 0) {
                    component.propagateBgClr(this.bgClr);
                }
                if ((component.flags & 0x800) == 0) {
                    component.propagateFgClr(this.fgClr);
                }
                if ((component.flags & 0x2000) == 0) {
                    component.propagateFont(this.font);
                }
                if (this.layoutm != null) {
                    if (this.layoutm instanceof LayoutManager2) {
                        ((LayoutManager2)this.layoutm).addLayoutComponent(component, object);
                    }
                    if (object instanceof String) {
                        this.layoutm.addLayoutComponent((String)object, component);
                    }
                }
                if (this.cntrListener != null || (this.eventMask & 2) != 0) {
                    AWTEvent.sendEvent(ContainerEvt.getEvent(this, 300, component), false);
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                throw throwable;
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        for (int i = 0; i < this.nChildren; ++i) {
            this.children[i].addNotify();
        }
    }

    Graphics clipSiblings(Component component, NativeGraphics nativeGraphics) {
        int n;
        int n2 = nativeGraphics.xClip + nativeGraphics.xOffset;
        int n3 = nativeGraphics.yClip + nativeGraphics.yOffset;
        int n4 = n2 + nativeGraphics.wClip;
        int n5 = n3 + nativeGraphics.hClip;
        for (n = this.nChildren - 1; n >= 0 && this.children[n] != component; --n) {
        }
        --n;
        while (n >= 0) {
            Component component2 = this.children[n];
            int n6 = component2.x + component2.width;
            int n7 = component2.y + component2.height;
            if (component2.x > n4 || component2.y > n5 || n6 < n2 || n7 < n3) {
                // empty if block
            }
            --n;
        }
        return nativeGraphics;
    }

    public int countComponents() {
        return this.nChildren;
    }

    public void doLayout() {
        this.layout();
    }

    void dump(String string) {
        String string2 = String.valueOf(string).concat(String.valueOf("  "));
        super.dump(string);
        for (int i = 0; i < this.nChildren; ++i) {
            this.children[i].dump(String.valueOf(String.valueOf(string2).concat(String.valueOf(i))).concat(String.valueOf(" ")));
        }
    }

    void emitRepaints(int n, int n2, int n3, int n4) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        for (int i = 0; i < this.nChildren; ++i) {
            int n7;
            Component component = this.children[i];
            if ((component.flags & 1) == 0) continue;
            int n8 = component.x + component.width;
            int n9 = component.y + component.height;
            int n10 = n < component.x ? 0 : n - component.x;
            int n11 = n2 < component.y ? 0 : n2 - component.y;
            int n12 = n5 < n8 ? n5 - component.x - n10 : component.width;
            int n13 = n7 = n6 < n9 ? n6 - component.y - n11 : component.height;
            if ((component.flags & 0x8000) != 0) {
                Toolkit.eventQueue.repaint((component.flags & 0x4000) != 0 ? 800 : 801, component, n10, n11, n12, n7);
            }
            if (!(component instanceof Container)) continue;
            ((Container)component).emitRepaints(n10, n11, n12, n7);
        }
    }

    public float getAlignmentX() {
        if (this.layoutm instanceof LayoutManager2) {
            return ((LayoutManager2)this.layoutm).getLayoutAlignmentX(this);
        }
        return super.getAlignmentX();
    }

    public float getAlignmentY() {
        if (this.layoutm instanceof LayoutManager2) {
            return ((LayoutManager2)this.layoutm).getLayoutAlignmentY(this);
        }
        return super.getAlignmentY();
    }

    public Component getComponent(int n) {
        return this.children[n];
    }

    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    public Component getComponentAt(int n, int n2) {
        return this.locate(n, n2);
    }

    public int getComponentCount() {
        return this.countComponents();
    }

    public Component[] getComponents() {
        Component[] componentArray = new Component[this.nChildren];
        if (this.nChildren > 0) {
            System.arraycopy(this.children, 0, componentArray, 0, this.nChildren);
        }
        return componentArray;
    }

    public Insets getInsets() {
        return this.insets();
    }

    public LayoutManager getLayout() {
        return this.layoutm;
    }

    public Dimension getMaximumSize() {
        if (this.layoutm instanceof LayoutManager2) {
            return ((LayoutManager2)this.layoutm).maximumLayoutSize(this);
        }
        return super.getMaximumSize();
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    boolean hasDirties() {
        for (int i = 0; i < this.nChildren; ++i) {
            Component component = this.children[i];
            if ((component.flags & 0x8000) != 0) {
                return true;
            }
            if (!(component instanceof Container) || !((Container)component).hasDirties()) continue;
            return true;
        }
        return false;
    }

    public void hide() {
        if ((this.flags & 4) != 0) {
            for (int i = 0; i < this.nChildren; ++i) {
                Component component = this.children[i];
                component.flags &= 0xFFFFFFFB;
                if ((component.flags & 1) == 0) continue;
                component.propagateParentShowing();
            }
        }
        super.hide();
    }

    public Insets insets() {
        return new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
    }

    public void invalidate() {
        Object object = Component.treeLock;
        synchronized (object) {
            try {
                if ((this.flags & 2) != 0) {
                    if (this.layoutm instanceof LayoutManager2) {
                        ((LayoutManager2)this.layoutm).invalidateLayout(this);
                    }
                    this.flags &= 0xFFFFFFFD;
                    if (this.parent != null && (this.parent.flags & 2) != 0) {
                        this.parent.invalidate();
                    }
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }
    }

    public boolean isAncestorOf(Component component) {
        component = component.parent;
        while (component != null) {
            if (component == this) {
                return true;
            }
            component = component.parent;
        }
        return false;
    }

    public void layout() {
        Object object = Component.treeLock;
        synchronized (object) {
            try {
                if (this.layoutm != null && this.nChildren > 0 && (this.flags & 8) == 0) {
                    this.flags |= 8;
                    this.layoutm.layoutContainer(this);
                    this.flags &= 0xFFFFFFF7;
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }
    }

    public Component locate(int n, int n2) {
        if (!this.isShowing() || n < 0 || n > this.x + this.width || n2 < 0 || n2 > this.y + this.height) {
            return null;
        }
        for (int i = 0; i < this.nChildren; ++i) {
            Component component = this.children[i];
            if (!component.contains(n - component.x, n2 - component.y)) continue;
            return component.isShowing() ? component : this;
        }
        return this;
    }

    void markRepaints(int n, int n2, int n3, int n4) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        for (int i = 0; i < this.nChildren; ++i) {
            Component component = this.children[i];
            if ((component.flags & 1) == 0) continue;
            int n7 = component.x + component.width;
            int n8 = component.y + component.height;
            if (n >= n7 || n2 >= n8 || component.x >= n5 || component.y >= n6) continue;
            if ((component.flags & 0x100) != 0) {
                component.flags |= 0x8000;
            }
            if (!(component instanceof Container)) continue;
            int n9 = n < component.x ? 0 : n - component.x;
            int n10 = n2 < component.y ? 0 : n2 - component.y;
            int n11 = n5 < n7 ? n5 - component.x - n9 : component.width;
            int n12 = n6 < n8 ? n6 - component.y - n10 : component.height;
            ((Container)component).markRepaints(n9, n10, n11, n12);
        }
    }

    public Dimension minimumSize() {
        if (this.layoutm != null) {
            return this.layoutm.minimumLayoutSize(this);
        }
        return super.minimumSize();
    }

    public void paint(Graphics graphics) {
        for (int i = this.nChildren - 1; i >= 0; --i) {
            Component component = this.children[i];
            if ((component.flags & 1) == 0) continue;
            graphics.paintChild(component, (this.flags & 0x10) != 0);
        }
    }

    public Dimension preferredSize() {
        if (this.layoutm != null) {
            return this.layoutm.preferredLayoutSize(this);
        }
        return super.preferredSize();
    }

    public void printComponents(Graphics graphics) {
    }

    void process(ContainerEvent containerEvent) {
        if (this.cntrListener != null || (this.eventMask & 2) != 0) {
            this.processEvent(containerEvent);
        }
    }

    public void processContainerEvent(ContainerEvent containerEvent) {
        if (this.cntrListener != null) {
            switch (containerEvent.getID()) {
                case 300: {
                    this.cntrListener.componentAdded(containerEvent);
                    break;
                }
                case 301: {
                    this.cntrListener.componentRemoved(containerEvent);
                }
            }
        }
    }

    void processPaintEvent(int n, int n2, int n3, int n4, int n5) {
        NativeGraphics nativeGraphics = NativeGraphics.getClippedGraphics(null, this, 0, 0, n2, n3, n4, n5, false);
        if (nativeGraphics != null) {
            this.markRepaints(n2, n3, n4, n5);
            if (n == 801) {
                this.update(nativeGraphics);
            } else {
                this.paint(nativeGraphics);
            }
            nativeGraphics.dispose();
            if (this.hasDirties()) {
                this.emitRepaints(n2, n3, n4, n5);
            }
        }
    }

    void propagateBgClr(Color color) {
        this.bgClr = color;
        for (int i = 0; i < this.nChildren; ++i) {
            Component component = this.children[i];
            if ((component.flags & 0x1000) != 0) continue;
            component.propagateBgClr(color);
        }
    }

    void propagateFgClr(Color color) {
        this.fgClr = color;
        for (int i = 0; i < this.nChildren; ++i) {
            Component component = this.children[i];
            if ((component.flags & 0x800) != 0) continue;
            component.propagateFgClr(color);
        }
    }

    void propagateFont(Font font) {
        this.font = font;
        for (int i = 0; i < this.nChildren; ++i) {
            Component component = this.children[i];
            if ((component.flags & 0x2000) != 0) continue;
            component.propagateFont(font);
        }
    }

    void propagateParentShowing() {
        if ((this.flags & 1) == 0) {
            return;
        }
        if ((this.flags & 4) != 0) {
            for (int i = 0; i < this.nChildren; ++i) {
                this.children[i].flags |= 4;
                this.children[i].propagateParentShowing();
            }
        } else {
            for (int i = 0; i < this.nChildren; ++i) {
                this.children[i].flags &= 0xFFFFFFFB;
                this.children[i].propagateParentShowing();
            }
        }
    }

    public void remove(Component component) {
        for (int i = this.nChildren - 1; i >= 0; --i) {
            if (this.children[i] != component) continue;
            this.remove(i);
            break;
        }
    }

    public void remove(int n) {
        Object object = Component.treeLock;
        synchronized (object) {
            block9: {
                try {
                    int n2 = this.nChildren - 1;
                    if (n < 0 && n > n2) {
                        Object var6_4 = null;
                        return;
                    }
                    Component component = this.children[n];
                    if ((component.flags & 0x400) != 0) {
                        component.removeNotify();
                    }
                    if (this.layoutm != null) {
                        this.layoutm.removeLayoutComponent(component);
                    }
                    component.parent = null;
                    if (n > -1 && n < n2) {
                        System.arraycopy(this.children, n + 1, this.children, n, n2 - n);
                    }
                    this.children[n2] = null;
                    --this.nChildren;
                    if (this.cntrListener != null || (this.eventMask & 2) != 0) {
                        AWTEvent.sendEvent(ContainerEvt.getEvent(this, 301, component), false);
                    }
                    if ((this.flags & 2) != 0) {
                        this.invalidate();
                    }
                    component.flags &= 0xFFFFFFFB;
                    component.propagateParentShowing();
                    if ((component.flags & 0x100) == 0) break block9;
                    this.repaint(component.x, component.y, component.width, component.height);
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    throw throwable;
                }
            }
            Object var6_5 = null;
            {
            }
        }
    }

    public void removeAll() {
        if (this.nChildren > 3) {
            int n = this.flags;
            this.flags &= 0xFFFFFFFE;
            for (int i = this.nChildren - 1; i >= 0; --i) {
                this.remove(i);
            }
            this.flags = n;
            this.repaint();
        } else {
            for (int i = this.nChildren - 1; i >= 0; --i) {
                this.remove(i);
            }
        }
    }

    public void removeContainerListener(ContainerListener containerListener) {
        this.cntrListener = AWTEventMulticaster.remove(this.cntrListener, containerListener);
    }

    public void removeNotify() {
        for (int i = 0; i < this.nChildren; ++i) {
            if ((this.children[i].flags & 0x400) == 0) continue;
            this.children[i].removeNotify();
        }
        super.removeNotify();
    }

    public void setLayout(LayoutManager layoutManager) {
        this.layoutm = layoutManager;
        if ((this.flags & 2) != 0) {
            this.invalidate();
        }
    }

    public void show() {
        if ((this.flags & 4) != 0) {
            for (int i = 0; i < this.nChildren; ++i) {
                Component component = this.children[i];
                component.flags |= 4;
                if ((component.flags & 1) == 0) continue;
                component.propagateParentShowing();
            }
        }
        super.show();
    }

    public void update(Graphics graphics) {
        this.flags |= 0x10;
        graphics.clearRect(0, 0, this.width, this.height);
        this.paint(graphics);
        this.flags &= 0xFFFFFFEF;
    }

    public void validate() {
        Object object = Component.treeLock;
        synchronized (object) {
            try {
                if ((this.flags & 0x402) == 1024) {
                    this.validateTree();
                    this.flags |= 2;
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }
    }

    protected void validateTree() {
        this.doLayout();
        for (int i = 0; i < this.nChildren; ++i) {
            this.children[i].validate();
        }
    }
}

