/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.ClassAnalyzer;
import java.awt.ClassProperties;
import java.awt.Color;
import java.awt.ComponentEvt;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Defaults;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FocusEvt;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MouseEvt;
import java.awt.NativeGraphics;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.PaintEvent;
import java.awt.event.TextEvent;
import java.awt.event.WindowEvent;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ComponentPeer;
import java.io.Serializable;
import java.util.Locale;

public abstract class Component
implements ImageObserver,
MenuContainer,
Serializable {
    private static final long serialVersionUID = -7644114512714619750L;
    Container parent;
    int x;
    int y;
    int width;
    int height;
    Color fgClr;
    Color bgClr;
    Font font;
    Cursor cursor;
    ComponentListener cmpListener;
    KeyListener keyListener;
    FocusListener focusListener;
    MouseListener mouseListener;
    MouseMotionListener motionListener;
    String name;
    int eventMask;
    Locale locale;
    PopupMenu popup;
    Rectangle deco = noDeco;
    int flags = 1;
    public static final float TOP_ALIGNMENT = 0.0f;
    public static final float CENTER_ALIGNMENT = 0.5f;
    public static final float BOTTOM_ALIGNMENT = 1.0f;
    public static final float LEFT_ALIGNMENT = 0.0f;
    public static final float RIGHT_ALIGNMENT = 1.0f;
    static final int BORDER_WIDTH = 2;
    static Object treeLock = new TreeLock();
    static Rectangle noDeco = new Rectangle();
    static final int IS_VISIBLE = 1;
    static final int IS_VALID = 2;
    static final int IS_PARENT_SHOWING = 4;
    static final int IS_LAYOUTING = 8;
    static final int IS_IN_UPDATE = 16;
    static final int IS_OLD_EVENT = 32;
    static final int IS_RESIZABLE = 64;
    static final int IS_MODAL = 128;
    static final int IS_NATIVE_LIKE = 256;
    static final int IS_OPENED = 512;
    static final int IS_ADD_NOTIFIED = 1024;
    static final int IS_FG_COLORED = 2048;
    static final int IS_BG_COLORED = 4096;
    static final int IS_FONTIFIED = 8192;
    static final int IS_ASYNC_UPDATED = 16384;
    static final int IS_DIRTY = 32768;
    static final int IS_MOUSE_AWARE = 65536;
    static final int IS_SHOWING = 1029;

    protected Component() {
        this.cursor = Cursor.defaultCursor;
    }

    public boolean action(Event event, Object object) {
        return false;
    }

    public void add(PopupMenu popupMenu) {
        if (popupMenu.parent != null) {
            popupMenu.parent.remove(popupMenu);
        }
        if ((this.flags & 0x400) > 0) {
            popupMenu.parent = this;
            popupMenu.owner = this;
            popupMenu.addNotify();
        }
        if (this.popup == null) {
            this.popup = popupMenu;
        } else {
            this.popup.addSeparator();
            this.popup.addAll(popupMenu);
        }
    }

    public void addComponentListener(ComponentListener componentListener) {
        this.cmpListener = AWTEventMulticaster.add(this.cmpListener, componentListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.focusListener = AWTEventMulticaster.add(this.focusListener, focusListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, keyListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, mouseListener);
        this.flags |= 0x10000;
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.motionListener = AWTEventMulticaster.add(this.motionListener, mouseMotionListener);
        this.flags |= 0x10000;
    }

    public void addNotify() {
        if ((this.flags & 0x400) == 0) {
            this.flags |= 0x400;
            ClassProperties classProperties = this.getClassProperties();
            if (classProperties.isNativeLike) {
                this.flags |= 0x100;
            }
            if (this.parent != null) {
                if ((this.parent.flags & 0x20) != 0 || classProperties.useOldEvents) {
                    this.flags |= 0x10020;
                }
            } else if (classProperties.useOldEvents) {
                this.flags |= 0x10020;
            }
            if (this.popup != null) {
                this.popup.parent = this;
                this.popup.owner = this;
                this.popup.addNotify();
            }
        }
    }

    public Rectangle bounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public int checkImage(Image image, ImageObserver imageObserver) {
        return image.checkImage(-1, -1, imageObserver, false);
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return image.checkImage(n, n2, imageObserver, false);
    }

    void checkMouseAware() {
        this.flags = (this.eventMask & Integer.MIN_VALUE) == 0 && (this.mouseListener != null || this.motionListener != null || (this.eventMask & 0x30) != 0 || (this.flags & 0x20) != 0) ? (this.flags |= 0x10000) : (this.flags &= 0xFFFEFFFF);
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(int n, int n2) {
        return this.inside(n, n2);
    }

    public Image createImage(ImageProducer imageProducer) {
        return new Image(imageProducer);
    }

    public Image createImage(int n, int n2) {
        return new Image(n, n2);
    }

    public final void deliverEvent(Event event) {
        this.postEvent(event);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void disableEvents(long l) {
        this.eventMask = (int)((long)this.eventMask & (l ^ 0L - 1L));
        this.checkMouseAware();
    }

    public final void dispatchEvent(AWTEvent aWTEvent) {
        this.dispatchEventImpl(aWTEvent);
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        aWTEvent.dispatch();
    }

    public void doLayout() {
        this.layout();
    }

    void dump(String string) {
        System.out.print(string);
        System.out.println(this);
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void enable(boolean bl) {
        this.setEnabled(bl);
    }

    public void enableEvents(long l) {
        this.eventMask = (int)((long)this.eventMask | l);
        this.checkMouseAware();
    }

    public float getAlignmentX() {
        return 0.5f;
    }

    public float getAlignmentY() {
        return 0.5f;
    }

    public Color getBackground() {
        return this.bgClr;
    }

    public Rectangle getBounds() {
        return this.bounds();
    }

    ClassProperties getClassProperties() {
        return ClassAnalyzer.analyzeProcessEvent(this.getClass(), false);
    }

    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    public Component getComponentAt(int n, int n2) {
        return this.locate(n, n2);
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return FontMetrics.getFontMetrics(font);
    }

    public Color getForeground() {
        return this.fgClr;
    }

    public Graphics getGraphics() {
        if ((this.flags & 0x400) != 0) {
            return NativeGraphics.getClippedGraphics(null, this, 0, 0, 0, 0, this.width, this.height, false);
        }
        return null;
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        if (this.parent != null) {
            return this.parent.getLocale();
        }
        return Locale.getDefault();
    }

    public Point getLocation() {
        return this.location();
    }

    public Point getLocationOnScreen() {
        int n = 0;
        int n2 = 0;
        Component component = this;
        while (component != null) {
            n += component.x;
            n2 += component.y;
            component = component.parent;
        }
        return new Point(n, n2);
    }

    public Dimension getMaximumSize() {
        return Toolkit.singleton.getScreenSize();
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public String getName() {
        return this.name == null ? this.getClass().getName() : this.name;
    }

    public Container getParent() {
        return this.parent;
    }

    public ComponentPeer getPeer() {
        return (this.flags & 0x400) != 0 ? Toolkit.lightweightPeer : null;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Dimension getSize() {
        return this.size();
    }

    public Toolkit getToolkit() {
        return Toolkit.singleton;
    }

    Component getToplevel() {
        Component component = this;
        while (!(component instanceof Window) && component != null) {
            component = component.parent;
        }
        return component;
    }

    public final Object getTreeLock() {
        return treeLock;
    }

    public boolean gotFocus(Event event, Object object) {
        return false;
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 1001: {
                return this.action(event, event.arg);
            }
            case 1004: {
                return this.gotFocus(event, event.arg);
            }
            case 401: {
                return this.keyDown(event, event.key);
            }
            case 402: {
                return this.keyUp(event, event.key);
            }
            case 1005: {
                return this.lostFocus(event, event.arg);
            }
            case 501: {
                return this.mouseDown(event, event.x, event.y);
            }
            case 506: {
                return this.mouseDrag(event, event.x, event.y);
            }
            case 504: {
                return this.mouseEnter(event, event.x, event.y);
            }
            case 505: {
                return this.mouseExit(event, event.x, event.y);
            }
            case 503: {
                return this.mouseMove(event, event.x, event.y);
            }
            case 502: {
                return this.mouseUp(event, event.x, event.y);
            }
        }
        return false;
    }

    public void hide() {
        if ((this.flags & 1) != 0) {
            this.flags &= 0xFFFFFFFE;
            if (this.parent != null && (this.parent.flags & 8) == 0) {
                if ((this.flags & 4) != 0) {
                    this.parent.repaint(this.x, this.y, this.width, this.height);
                }
                if ((this.parent.flags & 2) != 0) {
                    this.parent.invalidate();
                }
            }
            if (this.cmpListener != null || (this.eventMask & 1) != 0) {
                AWTEvent.sendEvent(ComponentEvt.getEvent(this, 103), true);
            }
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x30) != 0 && (this.flags & 0x405) == 1029) {
            this.repaint();
        }
        return (n & 0xE0) == 0;
    }

    public boolean inside(int n, int n2) {
        if ((this.flags & 0x405) != 1029) {
            return false;
        }
        return n >= 0 && n2 >= 0 && n <= this.width && n2 <= this.height;
    }

    boolean intersects(Component component) {
        return this.intersects(component.x, component.y, component.width, component.height);
    }

    boolean intersects(Rectangle rectangle) {
        return this.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    boolean intersects(int n, int n2, int n3, int n4) {
        return this.x <= n + n3 && this.y <= n2 + n4 && n <= this.x + this.width && n2 <= this.y + this.height;
    }

    public void invalidate() {
        Object object = treeLock;
        synchronized (object) {
            try {
                if ((this.flags & 2) != 0) {
                    this.flags &= 0xFFFFFFFD;
                    if ((this.parent.flags & 2) != 0) {
                        this.parent.invalidate();
                    }
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }
    }

    public boolean isDoubleBuffered() {
        return false;
    }

    public boolean isEnabled() {
        return (this.eventMask & Integer.MIN_VALUE) == 0;
    }

    public boolean isFocusTraversable() {
        return (this.flags & 0x505) == 1285 && (this.eventMask & Integer.MIN_VALUE) == 0;
    }

    public boolean isShowing() {
        return (this.flags & 0x405) == 1029;
    }

    public boolean isValid() {
        return (this.flags & 2) != 0;
    }

    public boolean isVisible() {
        return (this.flags & 1) != 0;
    }

    public boolean keyDown(Event event, int n) {
        return false;
    }

    public boolean keyUp(Event event, int n) {
        return false;
    }

    public void layout() {
    }

    public Component locate(int n, int n2) {
        return this.contains(n, n2) ? this : null;
    }

    public Point location() {
        return new Point(this.x, this.y);
    }

    public boolean lostFocus(Event event, Object object) {
        return false;
    }

    public Dimension minimumSize() {
        return new Dimension(this.width, this.height);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        return false;
    }

    public void move(int n, int n2) {
        this.setBounds(n, n2, this.width, this.height);
    }

    public void nextFocus() {
        this.transferFocus();
    }

    public void paint(Graphics graphics) {
    }

    public void paintAll(Graphics graphics) {
        this.paint(graphics);
    }

    void paintBorder() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paintBorder(graphics);
            graphics.dispose();
        }
    }

    void paintBorder(Graphics graphics) {
        this.paintBorder(graphics, 0, 0, 0, 0);
    }

    void paintBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = this.width - (n + n3);
        int n6 = this.height - (n2 + n4);
        if (this == AWTEvent.keyTgt) {
            graphics.setColor(Defaults.FocusClr);
        } else {
            graphics.setColor(Defaults.BorderClr);
        }
        if (n5 - 1 > 0 && n6 - 1 > 0) {
            graphics.draw3DRect(n, n2, n5 - 1, n6 - 1, true);
        }
        if (n5 - 3 > 0 && n6 - 3 > 0) {
            graphics.draw3DRect(n + 1, n2 + 1, n5 - 3, n6 - 3, false);
        }
    }

    protected String paramString() {
        String string = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("").concat(String.valueOf(this.name))).concat(String.valueOf(','))).concat(String.valueOf(' '))).concat(String.valueOf(this.x))).concat(String.valueOf(','))).concat(String.valueOf(this.y))).concat(String.valueOf(','))).concat(String.valueOf(this.width))).concat(String.valueOf(','))).concat(String.valueOf(this.height));
        string = String.valueOf(string).concat(String.valueOf(String.valueOf(" flags: ").concat(String.valueOf(Integer.toHexString(this.flags)))));
        if (!this.isValid()) {
            string = String.valueOf(string).concat(String.valueOf(" invalid"));
        }
        if (!this.isVisible()) {
            string = String.valueOf(string).concat(String.valueOf(" hidden"));
        }
        if (!this.isEnabled()) {
            string = String.valueOf(string).concat(String.valueOf(" disabled"));
        }
        return string;
    }

    public boolean postEvent(Event event) {
        if (event != null) {
            Component component = this;
            while (component != null) {
                if (component.handleEvent(event)) {
                    event.recycle();
                    return true;
                }
                event.x += component.x;
                event.y += component.y;
                component = component.parent;
            }
            event.recycle();
        }
        return false;
    }

    public Dimension preferredSize() {
        return this.getMinimumSize();
    }

    public boolean prepareImage(Image image, ImageObserver imageObserver) {
        return this.prepareImage(image, -1, -1, imageObserver);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return image.loadImage(n, n2, imageObserver);
    }

    public void print(Graphics graphics) {
    }

    public void printAll(Graphics graphics) {
    }

    void process(ActionEvent actionEvent) {
    }

    void process(AdjustmentEvent adjustmentEvent) {
    }

    void process(ComponentEvent componentEvent) {
        if (this.cmpListener != null || (this.eventMask & 1) != 0) {
            this.processEvent(componentEvent);
        }
    }

    void process(ContainerEvent containerEvent) {
    }

    void process(FocusEvent focusEvent) {
        if (this.focusListener != null || (this.eventMask & 4) != 0) {
            this.processEvent(focusEvent);
        }
        if ((this.flags & 0x20) != 0) {
            this.postEvent(Event.getEvent(focusEvent));
        }
    }

    void process(ItemEvent itemEvent) {
    }

    void process(KeyEvent keyEvent) {
        if (this.keyListener != null || (this.eventMask & 8) != 0) {
            this.processEvent(keyEvent);
        }
        if ((this.flags & 0x20) != 0) {
            this.postEvent(Event.getEvent(keyEvent));
        }
    }

    void process(TextEvent textEvent) {
    }

    void process(WindowEvent windowEvent) {
    }

    protected void processActionEvent(ActionEvent actionEvent) {
    }

    protected void processAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        if (this.cmpListener != null) {
            switch (componentEvent.getID()) {
                case 101: {
                    this.cmpListener.componentResized(componentEvent);
                    break;
                }
                case 100: {
                    this.cmpListener.componentMoved(componentEvent);
                    break;
                }
                case 102: {
                    this.cmpListener.componentShown(componentEvent);
                    break;
                }
                case 103: {
                    this.cmpListener.componentHidden(componentEvent);
                }
            }
        }
    }

    protected void processContainerEvent(ContainerEvent containerEvent) {
    }

    protected void processEvent(AWTEvent aWTEvent) {
        switch (aWTEvent.id) {
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 505: {
                this.processMouseEvent((MouseEvent)aWTEvent);
                break;
            }
            case 503: 
            case 506: {
                this.processMouseMotionEvent((MouseEvent)aWTEvent);
                break;
            }
            case 400: 
            case 401: 
            case 402: {
                this.processKeyEvent((KeyEvent)aWTEvent);
                break;
            }
            case 1004: 
            case 1005: {
                this.processFocusEvent((FocusEvent)aWTEvent);
                break;
            }
            case 800: 
            case 801: {
                Rectangle rectangle = ((PaintEvent)aWTEvent).getUpdateRect();
                this.processPaintEvent(aWTEvent.id, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                this.processComponentEvent((ComponentEvent)aWTEvent);
                break;
            }
            case 300: 
            case 301: {
                this.processContainerEvent((ContainerEvent)aWTEvent);
                break;
            }
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: {
                this.processWindowEvent((WindowEvent)aWTEvent);
                break;
            }
            case 900: {
                this.processTextEvent((TextEvent)aWTEvent);
                break;
            }
            case 701: {
                this.processItemEvent((ItemEvent)aWTEvent);
                break;
            }
            case 1001: {
                this.processActionEvent((ActionEvent)aWTEvent);
                break;
            }
            case 601: {
                this.processAdjustmentEvent((AdjustmentEvent)aWTEvent);
            }
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        if (this.focusListener != null) {
            switch (focusEvent.getID()) {
                case 1004: {
                    this.focusListener.focusGained(focusEvent);
                    break;
                }
                case 1005: {
                    this.focusListener.focusLost(focusEvent);
                }
            }
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (this.keyListener != null) {
            switch (keyEvent.id) {
                case 400: {
                    this.keyListener.keyTyped(keyEvent);
                    break;
                }
                case 401: {
                    this.keyListener.keyPressed(keyEvent);
                    break;
                }
                case 402: {
                    this.keyListener.keyReleased(keyEvent);
                }
            }
        }
    }

    void processMotion(MouseEvent mouseEvent) {
        if (this.motionListener != null || (this.eventMask & 0x20) != 0) {
            this.processEvent(mouseEvent);
        }
        if ((this.flags & 0x20) != 0) {
            this.postEvent(Event.getEvent(mouseEvent));
        }
    }

    void processMouse(MouseEvent mouseEvent) {
        if (this.mouseListener != null || (this.eventMask & 0x10) != 0) {
            this.processEvent(mouseEvent);
        }
        if ((this.flags & 0x20) != 0) {
            this.postEvent(Event.getEvent(mouseEvent));
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.mouseListener != null) {
            switch (mouseEvent.id) {
                case 501: {
                    this.mouseListener.mousePressed(mouseEvent);
                    break;
                }
                case 502: {
                    this.mouseListener.mouseReleased(mouseEvent);
                    break;
                }
                case 500: {
                    this.mouseListener.mouseClicked(mouseEvent);
                    break;
                }
                case 505: {
                    this.mouseListener.mouseExited(mouseEvent);
                    break;
                }
                case 504: {
                    this.mouseListener.mouseEntered(mouseEvent);
                }
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.motionListener != null) {
            switch (mouseEvent.id) {
                case 503: {
                    this.motionListener.mouseMoved(mouseEvent);
                    return;
                }
                case 506: {
                    this.motionListener.mouseDragged(mouseEvent);
                    return;
                }
            }
        }
    }

    void processPaintEvent(int n, int n2, int n3, int n4, int n5) {
        NativeGraphics nativeGraphics = NativeGraphics.getClippedGraphics(null, this, 0, 0, n2, n3, n4, n5, false);
        if (nativeGraphics != null) {
            if (n == 801) {
                this.update(nativeGraphics);
            } else {
                this.paint(nativeGraphics);
            }
            nativeGraphics.dispose();
        }
    }

    protected void processTextEvent(TextEvent textEvent) {
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
    }

    void propagateBgClr(Color color) {
        this.bgClr = color;
    }

    void propagateFgClr(Color color) {
        this.fgClr = color;
    }

    void propagateFont(Font font) {
        this.font = font;
    }

    void propagateParentShowing() {
    }

    public void remove(MenuComponent menuComponent) {
        menuComponent.removeNotify();
        menuComponent.parent = null;
        menuComponent.owner = null;
        if (this.popup != null) {
            this.popup.remove(menuComponent);
        }
    }

    public void removeComponentListener(ComponentListener componentListener) {
        this.cmpListener = AWTEventMulticaster.remove(this.cmpListener, componentListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.focusListener = AWTEventMulticaster.remove(this.focusListener, focusListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, keyListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, mouseListener);
        this.checkMouseAware();
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.motionListener = AWTEventMulticaster.remove(this.motionListener, mouseMotionListener);
        this.checkMouseAware();
    }

    public void removeNotify() {
        this.flags &= 0xFFFFFBFF;
        if (this.popup != null) {
            this.popup.removeNotify();
        }
        if (this == AWTEvent.mouseTgt) {
            AWTEvent.mouseTgt = null;
        }
        if (this == AWTEvent.keyTgt) {
            AWTEvent.keyTgt = null;
        }
        if (this == AWTEvent.activeWindow) {
            AWTEvent.activeWindow = null;
        }
        if (this == FocusEvt.keyTgtRequest) {
            FocusEvt.keyTgtRequest = null;
        }
        if (Toolkit.eventQueue.localQueue != null) {
            Toolkit.eventQueue.dropLiveEvents(this);
        }
    }

    public void repaint() {
        this.repaint(0L, 0, 0, this.width, this.height);
    }

    public void repaint(int n, int n2, int n3, int n4) {
        this.repaint(0L, n, n2, n3, n4);
    }

    public void repaint(long l) {
        this.repaint(l, 0, 0, this.width, this.height);
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        if ((this.flags & 0x405) == 1029) {
            Toolkit.eventQueue.repaint(801, this, n, n2, n3, n4);
        }
    }

    public void requestFocus() {
        Component component = null;
        if (AWTEvent.keyTgt == this) {
            return;
        }
        Component component2 = this.getToplevel();
        if (component2 == null) {
            FocusEvt.keyTgtRequest = this;
        } else {
            if (AWTEvent.keyTgt != null) {
                component = AWTEvent.keyTgt.getToplevel();
            }
            if (component2 != component) {
                FocusEvt.keyTgtRequest = this;
                component2.requestFocus();
            } else {
                AWTEvent.sendEvent(FocusEvt.getEvent(this, 1004), false);
            }
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        boolean bl = this.width != n3 || this.height != n4;
        boolean bl2 = !bl && (this.x != n || this.y != n2);
        int n10 = n5 = bl ? 101 : 100;
        if (bl || bl2) {
            if (this.parent != null) {
                if (MouseEvt.mouseDragged) {
                    Component component = AWTEvent.mouseTgt;
                    while (component != null) {
                        if (component == this) {
                            MouseEvt.moveMouseTgt(n - this.x, n2 - this.y);
                            break;
                        }
                        component = component.parent;
                    }
                }
                if ((this.flags & 0x405) == 1029) {
                    n6 = n < this.x ? n : this.x;
                    n8 = n2 < this.y ? n2 : this.y;
                    int n11 = n + n3;
                    int n12 = this.x + this.width;
                    n7 = n11 > n12 ? n11 : n12;
                    n11 = n2 + n4;
                    n12 = this.y + this.height;
                    n9 = n11 > n12 ? n11 : n12;
                    this.x = n;
                    this.y = n2;
                    this.width = n3;
                    this.height = n4;
                    this.invalidate();
                    if (this.cmpListener != null || (this.eventMask & 1) != 0) {
                        AWTEvent.sendEvent(ComponentEvt.getEvent(this, n5), false);
                    }
                    this.parent.repaint(n6, n8, n7 - n6, n9 - n8);
                    return;
                }
            }
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.invalidate();
            if (this.cmpListener != null || (this.eventMask & 1) != 0) {
                AWTEvent.sendEvent(ComponentEvt.getEvent(this, n5), false);
            }
        }
    }

    public void resize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void resize(int n, int n2) {
        this.setBounds(this.x, this.y, n, n2);
    }

    public void setBackground(Color color) {
        if (color == this.bgClr) {
            return;
        }
        if (color != null) {
            this.flags |= 0x1000;
        } else {
            this.flags &= 0xFFFFEFFF;
            if (this.parent != null) {
                color = this.parent.bgClr;
            }
        }
        this.propagateBgClr(color);
        if ((this.flags & 0x505) == 1029) {
            this.repaint();
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.reshape(n, n2, n3, n4);
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
        Component component = this;
        while (component.parent != null) {
            component = component.parent;
        }
        component.setNativeCursor(this.cursor);
    }

    public void setEnabled(boolean bl) {
        this.eventMask = bl ? (this.eventMask &= Integer.MAX_VALUE) : (this.eventMask |= Integer.MIN_VALUE);
        this.checkMouseAware();
    }

    public void setFont(Font font) {
        if (font == this.font) {
            return;
        }
        if (font != null) {
            this.flags |= 0x2000;
        } else {
            this.flags &= 0xFFFFDFFF;
            if (this.parent != null) {
                font = this.parent.font;
            }
        }
        this.propagateFont(font);
        if ((this.flags & 0x505) == 1029) {
            this.repaint();
        }
    }

    public void setForeground(Color color) {
        if (color == this.fgClr) {
            return;
        }
        if (color != null) {
            this.flags |= 0x800;
        } else {
            this.flags &= 0xFFFFF7FF;
            if (this.parent != null) {
                color = this.parent.fgClr;
            }
        }
        this.propagateFgClr(color);
        if ((this.flags & 0x505) == 1029) {
            this.repaint();
        }
    }

    public void setLocale(Locale locale2) {
        this.locale = locale2;
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public void setLocation(int n, int n2) {
        this.move(n, n2);
    }

    public void setName(String string) {
        this.name = string;
    }

    void setNativeCursor(Cursor cursor) {
    }

    public void setSize(Dimension dimension) {
        this.resize(dimension);
    }

    public void setSize(int n, int n2) {
        this.resize(n, n2);
    }

    public void setVisible(boolean bl) {
        this.show(bl);
    }

    public void show() {
        if ((this.flags & 1) == 0) {
            this.flags |= 1;
            if (this.parent != null && (this.parent.flags & 8) == 0) {
                if ((this.flags & 0x404) == 1028) {
                    this.repaint();
                }
                if ((this.parent.flags & 2) != 0) {
                    this.parent.invalidate();
                }
            }
            if (this.cmpListener != null || (this.eventMask & 1) != 0) {
                AWTEvent.sendEvent(ComponentEvt.getEvent(this, 102), true);
            }
        }
    }

    public void show(boolean bl) {
        if (bl) {
            this.show();
        } else {
            this.hide();
        }
    }

    public Dimension size() {
        return new Dimension(this.width, this.height);
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(this.getClass().getName()).concat(String.valueOf(" ["))).concat(String.valueOf(this.paramString()))).concat(String.valueOf(']'));
    }

    public void transferFocus() {
        Component component = this;
        while (component.parent != null) {
            Component component2;
            int n;
            Container container = component.parent;
            int n2 = container.getComponentCount();
            for (n = 0; n < n2 && (component2 = container.getComponent(n)) != component; ++n) {
            }
            if (n == n2) {
                return;
            }
            ++n;
            while (n < n2) {
                component2 = container.getComponent(n);
                if (component2.isEnabled() && (component2.flags & 1) != 0 && component2.isFocusTraversable()) {
                    if (!(component2 instanceof Container)) {
                        component2.requestFocus();
                        return;
                    }
                    container = (Container)component2;
                    n2 = container.getComponentCount();
                    n = -1;
                }
                ++n;
            }
            component = container;
        }
    }

    PopupMenu triggerPopup(int n, int n2) {
        if (this.popup != null) {
            this.popup.show(this, n, n2);
            return this.popup;
        }
        return null;
    }

    public void update(Graphics graphics) {
        graphics.clearRect(0, 0, this.width, this.height);
        this.paint(graphics);
    }

    public void validate() {
        if ((this.flags & 0x400) != 0) {
            this.flags |= 2;
        }
    }

    static class TreeLock {
        TreeLock() {
        }
    }
}

