// $Id: test_ops.java,v 1.2 1998/05/08 22:02:43 oliva Exp $

/* Copyright 1997,1998 Alexandre Oliva <oliva@dcc.unicamp.br>
 *
 * See the files "COPYING" and "README" for information on usage and
 * redistribution of this file.  */

/** Test all operation types.
 *
 * @author Alexandre Oliva
 * @version $Revision: 1.2 $ */
abstract class test_ops_base implements test_ops_i {
    static boolean sz;
    static byte sb;
    static short ss;
    static int si;
    static long sj;
    static char sc;
    static float sf;
    static double sd;
    static Object sl;

    boolean lz;
    byte lb;
    short ls;
    int li;
    long lj;
    char lc;
    float lf;
    double ld;
    Object ll;

    static boolean z(boolean z) { return !z; }
    static byte b(byte b) { return ++b; }
    static short s(short s) { return ++s; }
    static int i(int i) { return ++i; }
    static long j(long j) { return ++j; }
    static char c(char c) { return ++c; }
    static float f(float f) { return ++f; }
    static double d(double d) { return ++d; }
    static Object l(Object[] l) { return l[0]; }

    void callvirt() {
	System.out.println(Lz(lz));
	System.out.println(Lb(lb));
	System.out.println(Ls(ls));
	System.out.println(Li(li));
	System.out.println(Lj(lj));
	System.out.println(Lc(lc));
	System.out.println(Lf(lf));
	System.out.println(Ld(ld));
	System.out.println("" + ll + " == " + Ll((Object[])ll));
    }
}

final public class test_ops extends test_ops_base {
    public boolean Lz(boolean b) { return !b; }
    public byte Lb(byte b) { return ++b; }
    public short Ls(short s) { return ++s; }
    public int Li(int i) { return ++i; }
    public long Lj(long j) { return ++j; }
    public char Lc(char c) { return ++c; }
    public float Lf(float f) { return ++f; }
    public double Ld(double d) { return ++d; }
    public Object Ll(Object[] l) { return l[0]; }

    public static void main(String[] argv) {
	initstatic();
	callstatic();
	new test_ops();
	testarrays();
    }

    static void testarrays() {
	boolean[] zs = new boolean[3];
	zs[0] = false;
	zs[1] = true;
	zs[2] = !zs[0];
	byte[] bs = new byte[3];
	bs[0] = 0;
	bs[1] = 1;
	bs[2] = (byte)~bs[0];
	char[] cs = new char[3];
	cs[0] = 'a';
	cs[1] = 'b';
	cs[2] = (char)(cs[0] + 2);
	short[] ss = new short[3];
	ss[0] = 0;
	ss[1] = 1;
	ss[2] = (short)~ss[0];
	int[] is = new int[3];
	is[0] = 0;
	is[1] = 1;
	is[2] = ~is[0];
	long[] ls = new long[3];
	ls[0] = 0;
	ls[1] = 1;
	ls[2] = ~ls[0];
	float[] fs = new float[3];
	fs[0] = 0;
	fs[1] = 1;
	fs[2] = fs[0]+2;
	double[] ds = new double[3];
	ds[0] = 0;
	ds[1] = 1;
	ds[2] = ds[0]+2;
	Object[] os = new Object[] { zs, bs, cs, ss, is, ls, fs, ds,
				     new Object(), new Object[3],
				     new Object[3][4][5] };
	System.out.println(os);
    }

    test_ops() {
	lz = sz;
	lb = sb;
	ls = ss;
	li = si;
	lj = sj;
	lc = sc;
	lf = sf;
	ld = sd;
	ll = sl;
	callspec();
	callvirt();
	callintr(this);
    }

    static void initstatic() {
	sz = false;
	sb = 0;
	ss = 1;
	si = 2;
	sj = 3;
	sc = 'R';
	sf = 5;
	sd = 6;
	sl = new Object[1];
	((Object[])sl)[0] = sl;
    }

    static void callstatic() {
	System.out.println(z(sz));
	System.out.println(b(sb));
	System.out.println(s(ss));
	System.out.println(i(si));
	System.out.println(j(sj));
	System.out.println(c(sc));
	System.out.println(f(sf));
	System.out.println(d(sd));
	System.out.println("" + sl + " == " + l((Object[])sl));
    }

    void callspec() {
	System.out.println(Lz(lz));
	System.out.println(Lb(lb));
	System.out.println(Ls(ls));
	System.out.println(Li(li));
	System.out.println(Lj(lj));
	System.out.println(Lc(lc));
	System.out.println(Lf(lf));
	System.out.println(Ld(ld));
	System.out.println("" + ll + " == " + Ll((Object[])ll));
    }

    void callintr(test_ops_i I) {
	System.out.println(I.Lz(lz));
	System.out.println(I.Lb(lb));
	System.out.println(I.Ls(ls));
	System.out.println(I.Li(li));
	System.out.println(I.Lj(lj));
	System.out.println(I.Lc(lc));
	System.out.println(I.Lf(lf));
	System.out.println(I.Ld(ld));
	System.out.println("" + ll + " == " + I.Ll((Object[])ll));
    }
}

interface test_ops_i {
    boolean Lz(boolean b);
    byte Lb(byte b);
    short Ls(short s);
    int Li(int i);
    long Lj(long j);
    char Lc(char c);
    float Lf(float f);
    double Ld(double d);
    Object Ll(Object[] l);
}
