// $Id: HashWrapper.java,v 1.3 1998/06/08 10:14:06 oliva Exp $

/* Copyright 1997,1998 Alexandre Oliva <oliva@dcc.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package BR.unicamp.Guarana;

/** This class is to be used for wrapping base-level Objects, when
    they are used as keys in meta-level HashTables.  The memory
    address of the Object is used as its hashCode, and only references
    are compared for equality.

    @author Alexandre Oliva
    @version $Revision: 1.3 $  */
public class HashWrapper {
    /** The Object wrapped by this HashWrapper.  */
    public final Object object;
    
    /** Constructs a HashWrapper object that wraps the given Object.

	@param the base-level Object to be wrapped.  */
    public HashWrapper(final Object object) {
	this.object = object;
    }

    /** Returns the memory address of the Object.

	@return the result of <tt>Guarana.hashCode(this.object)</tt>.

	@see Guarana#hashCode */
    public int hashCode() {
	return Guarana.hashCode(object);
    }

    /** Returns a String representing the base-level Object.

	@return the result of <tt>Guarana.toString(this.object)</tt>.

	@see Guarana#toString */
    public String toString() {
	return Guarana.toString(object);
    }

    /** Compares the references of the wrapped Object with the given
	Object, assuming it may be a HashWrapper too.

	@param wrapper a HashWrapper or any Object

	@return true if the given Object is either the wrapped Object
	or a HashWrapper that wraps it.  */
    public boolean equals(final Object wrapper) {
	return object == wrapper ||
	    (wrapper instanceof HashWrapper &&
	     ((HashWrapper)wrapper).object == object);
    }
}
