// $Id: AreYouThere.java,v 1.1 1998/06/05 12:22:40 oliva Exp $

/* Copyright 1998 Alexandre Oliva <oliva@dcc.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

import BR.unicamp.Guarana.*;

/**
 * This program shows how messages can be used to check whether
 * reconfigurations succeeded.
 *
 * @author Alexandre Oliva
 * @version $Revision: 1.1 $
 */
public class AreYouThere implements Message {
    private boolean wasThere = false;
    private final MetaObject mo;
    public AreYouThere(final MetaObject mo) {
	this.mo = mo;
    }
    public void IamHere(final MetaObject mo) {
	if (this.mo == mo)
	    wasThere = true;
    }
    public boolean wasThere() { return wasThere; }
    public static boolean lookFor(final MetaObject mo, final Object o) {
	AreYouThere m = new AreYouThere(mo);
	Guarana.broadcast(m, o);
	return m.wasThere();
    }
    public static void main(String[ ] argv) {
	final MetaObject mo = new MetaObject() {
	    public void handle(final Message m, final Object o) {
		if (m instanceof AreYouThere)
		    ((AreYouThere)m).IamHere(this);
	    }
	};
	Object o = new Object();
	System.out.println(lookFor(mo, o));
	Guarana.reconfigure(o, null, mo);
	System.out.println(lookFor(mo, o));
	Guarana.reconfigure(o, mo, null);
	System.out.println(lookFor(mo, o));
    }
}
