// $Id: performance.java,v 1.2 1998/06/13 21:48:26 oliva Exp $

/* Copyright 1998 Alexandre Oliva <oliva@dcc.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

/**
 * This program times several Java operations.
 *
 * @author Alexandre Oliva
 * @version $Revision: 1.2 $
 */
public class performance {
    static finaltest object = statictest.createFinal();
    static int[] array = statictest.createArray();
    static long gettime() {
	return java.util.Calendar.getInstance().getTime().getTime();
    }
    static class statictest {
	static int i;
	static void test() {}
	static finaltest createFinal() { return new finaltest(); }
	static Object createObject() { return new Object(); }
	static int[] createArray() { return new int[1]; }
	static long createObject(int count) {
	    Object o = new Object();
	    long start = gettime();
	    while(count-- > 0) {
		o = new Object();
	    }
	    return gettime()-start;
	}
	static long createArray(int count) {
	    Object o = new int[1];
	    long start = gettime();
	    while(count-- > 0) {
		o = new int[1];
	    }
	    return gettime()-start;
	}
	static long createMultiArray(int count) {
	    Object o = new int[1][1];
	    long start = gettime();
	    while(count-- > 0) {
		o = new int[1][1];
	    }
	    return gettime()-start;
	}
    }
    static interface interfacetest {
	void test();
    }
    static class virtualtest implements interfacetest {
	int i;
	public void test() {}
    }
    static class finaltest extends virtualtest {
	private void ftest() {}
	static long finalMethodRun(int count) {
	    finaltest o = object;
	    o.ftest();
	    long start = gettime();
	    while(count-- > 0)
		o.ftest();
	    return gettime()-start;
	}
    }
    static interface test { long run(int count); }
    public static void main(String [ ] argv) {
	test[] tests = new test[] {
	    new test() {
		public String toString() { return "emptyloop"; }
		public long run(int count) {
		    gettime();
		    long start = gettime();
		    while(count-- > 0) {
			;
		    }
		    return gettime()-start;
		}
	    }, new test() {
		public String toString() { return "synchronization"; }
		public long run(int count) {
		    Class c = statictest.class;
		    synchronized(c) {}
		    long start = gettime();
		    while(count-- > 0) {
			synchronized(c) {}
		    }
		    return gettime()-start;
		}
	    }, new test() {
		public String toString() { return "staticMethodRun"; }
		public long run(int count) {
		    statictest.test();
		    long start = gettime();
		    while(count-- > 0) {
			statictest.test();
		    }
		    return gettime()-start;
		}
	    }, new test() {
		public String toString() { return "finalMethodRun"; }
		public long run(int count) {
		    return finaltest.finalMethodRun(count);
		}
	    }, new test() {
		public String toString() { return "virtualMethodRun"; }
		public long run(int count) {
		    virtualtest o = object;
		    o.test();
		    long start = gettime();
		    while(count-- > 0) {
			o.test();
		    }
		    return gettime()-start;
		}
	    }, new test() {
		public String toString() { return "interfaceMethodRun"; }
		public long run(int count) {
		    interfacetest o = object;
		    o.test();
		    long start = gettime();
		    while(count-- > 0) {
			o.test();
		    }
		    return gettime()-start;
		}
	    }, new test() {
		public String toString() { return "staticFieldLoad"; }
		public long run(int count) {
		    int j = statictest.i;
		    long start = gettime();
		    while(count-- > 0) {
			j = statictest.i;
		    }
		    return gettime()-start;
		}
	    }, new test() {
		public String toString() { return "staticFieldStore"; }
		public long run(int count) {
		    statictest.i = 0;
		    long start = gettime();
		    while(count-- > 0) {
			statictest.i = 0;
		    }
		    return gettime()-start;
		}
	    }, new test() {
		public String toString() { return "fieldLoad"; }
		public long run(int count) {
		    virtualtest o = object;
		    int j = o.i;
		    long start = gettime();
		    while(count-- > 0) {
			j = o.i;
		    }
		    return gettime()-start;
		}
	    }, new test() {
		public String toString() { return "fieldStore"; }
		public long run(int count) {
		    virtualtest o = object;
		    o.i = 0;
		    long start = gettime();
		    while(count-- > 0) {
			o.i = 0;
		    }
		    return gettime()-start;
		}
	    }, new test() {
		public String toString() { return "arrayLength"; }
		public long run(int count) {
		    int[] a = array;
		    int j = a.length;
		    long start = gettime();
		    while(count-- > 0) {
			j = a.length;
		    }
		    return gettime()-start;
		}
	    }, new test() {
		public String toString() { return "arrayLoad"; }
		public long run(int count) {
		    int[] a = array;
		    int j = a[0];
		    long start = gettime();
		    while(count-- > 0) {
			j = a[0];
		    }
		    return gettime()-start;
		}
	    }, new test() {
		public String toString() { return "arrayStore"; }
		public long run(int count) {
		    int[] a = array;
		    a[0] = 0;
		    long start = gettime();
		    while(count-- > 0) {
			a[0] = 0;
		    }
		    return gettime()-start;
		}
	    }, new test() {
		public String toString() { return "createObject"; }
		public long run(int count) {
		    return statictest.createObject(count);
		}
	    }, new test() {
		public String toString() { return "createArray"; }
		public long run(int count) {
		    return statictest.createArray(count);
		}
	    }, new test() {
		public String toString() { return "createMultiArray"; }
		public long run(int count) {
		    return statictest.createMultiArray(count);
		}
	    }
	};
	for(int i = 0, e = tests.length; i < e; ++i) {
	    runtest(tests[i]);
	}
    }
    static void runtest(test t) {
	System.out.print(t + ": ");
	System.out.flush();
	int count = 1000;
	long time = 0;
	while((time = t.run(count)) < 2000) {
	    if (time == 0)
		count *= 10;
	    else
		count = (int)(count * 2.5e3 / time);
	}
	System.out.println(t.run(count)*1e-3/count);
    }
}
