// $Id: NewObject.java,v 1.4 1998/02/05 14:05:03 oliva Exp $

package BR.unicamp.Guarana;

/** This Message is implicitly Broadcast to a Class' MetaObject after
    an instance of the Class is allocated and the creator's MetaObject
    is given the opportunity to associate it with a MetaObject, but
    before the object is actually initialized.

    <p>It allows the Class' meta-configuration to try to reconfigure
    its instances' meta-configurations.

    @see Guarana#broadcast
    @see Guarana#reconfigure
    @see MetaObject#configure

    @author Alexandre Oliva
    @version $Revision: 1.4 $  */
public class NewObject implements Message {
  /** The Object that was allocated but was not initialized yet.  */
  public final Object object;
  
  /** Creates a Message that informs a class that a new instance of it
      has been allocated, and it to be initialized soon.

      @param object the newly-allocated Object.  */
  public NewObject(Object object) {
    this.object = object;
  }

  /** Obtains a reference to the allocated Object.

      @return a reference to the allocated Object.  */
  public Object getObject() {
    return object;
  }
}
