/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio.util;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.util.UtilitariosString;

public class Validador {
    private static final String NOME_BRANCO = "Nome em branco";
    private static final String NOME_MAIS_60 = "Nome tem mais que 60 caracteres";
    private static final String NOME_MENOS_2 = "Nome tem menos de 2 partes";
    private static final String NOME_MAIS_15 = "Nome tem mais de 15 partes";
    private static final String NOME_1_CARACTER = "Primeira parte do nome tem somente um caracter";
    private static final String NOME_MAIS_20 = "Parte do nome tem mais de 20 caracteres";
    private static final String NOME_3_CONSECUTIVOS = "Nome com 3 caracteres iguais consecutivos";
    private static final String NOME_NUMERICO = "Nome n\u00e3o pode ter n\u00fameros";
    private static final String NOME_INVALIDO = "Nome tem caracteres inv\u00e1lidos";
    private static final String NOME_ESPOLIO = "Na declara\u00e7\u00e3o de esp\u00f3lio,deve ser informado o nome do contribuinte,sem a palavra ESP\u00d3LIO";
    public static final String DATA_INVALIDO = "Data inv\u00e1lida ou em branco";
    public static final String DATA_DIA_INVALIDO = "Data com dia inv\u00e1lido";
    public static final String DATA_MES_INVALIDO = "Data com m\u00eas inv\u00e1lido";
    public static final String DATA_ANO_INVALIDO = "Data com ano inv\u00e1lido";
    private static final String VALOR_GRANDE = "Valor informado excede o tamanho do campo";
    private static final String VALOR_NEGATIVO = "Valor n\u00e3o pode ser negativo";
    private static final String EMAIL_INVALIDO = "Correio eletr\u00f4nico inv\u00e1lido ou em branco";
    private static final String NI_INVALIDO = "CNPJ/CPF inv\u00e1lido ou em branco";
    private static final String CNPJ_INVALIDO = "CNPJ inv\u00e1lido ou em branco";
    private static final String CPF_INVALIDO = "CPF inv\u00e1lido ou em branco";
    private static final String DDD_DDI_INVALIDO = "DDD/DDI inv\u00e1lido ou em branco";
    private static final String DDD_DDI_2_DIGITOS = "O campo DDD/DDI deve ter 2 d\u00edgitos";
    private static final String CEP_INVALIDO = "CEP inv\u00e1lido.Informe-o com oito d\u00edgitos num\u00e9ricos";
    private static final String NIRF_INVALIDO = "N\u00famero do Im\u00f3vel na Receita inv\u00e1lido.";
    private static final String NIT_INVALIDO = "NIT inv\u00e1lido ou em branco";
    public static final int DATA_OK = 0;
    public static final int DATA_INVALIDA_FORMATO_INVALIDO = 1;
    public static final int DATA_INVALIDA_DIA_INVALIDO = 2;
    public static final int DATA_INVALIDA_MES_INVALIDO = 3;
    public static final int DATA_INVALIDA_ANO_INVALIDO = 4;
    public static final int MOD11_CASO_0 = 0;
    public static final int MOD11_CASO_1 = 1;
    public static final int MOD11_CASO_2 = 2;

    public static int calcularModulo11(String string, String string2, int n) {
        int n2;
        int n3 = 0;
        if (string2 == null) {
            n2 = 0;
            while (n2 < string.length()) {
                n3 += (string.length() + 1 - n2) * Character.getNumericValue(string.charAt(n2));
                ++n2;
            }
        } else {
            n2 = 0;
            while (n2 < string.length()) {
                n3 += Character.getNumericValue(string2.charAt(n2)) * Character.getNumericValue(string.charAt(n2));
                ++n2;
            }
        }
        n2 = n3 - n3 / 11 * 11;
        int n4 = 11 - n2;
        if (n == 2) {
            if (n4 > 9) {
                n4 = 0;
            }
        } else if (n == 1) {
            if (n4 == 10) {
                n4 = 0;
            }
            if (n4 == 11) {
                n4 = 1;
            }
        }
        return n4;
    }

    public static boolean validarModulo11(String string, String string2, int n) {
        String string3;
        int n2;
        String string4 = string.substring(0, string.length() - 1);
        int n3 = Validador.calcularModulo11(string4, string2, n);
        return n3 == (n2 = Integer.valueOf(string3 = string.substring(string.length() - 1, string.length())).intValue());
    }

    public static RetornoValidacao validarCPF(String string) {
        if (string == null || string.equals("")) {
            return new RetornoValidacao(CPF_INVALIDO);
        }
        String string2 = "00000000000 00000000191 99999999999 11111111111 22222222222 33333333333 44444444444 55555555555 66666666666 77777777777 88888888888 99999999999";
        if (string2.indexOf(string) != -1) {
            return new RetornoValidacao(CPF_INVALIDO);
        }
        if (!UtilitariosString.isNumeric(string)) {
            return new RetornoValidacao(CPF_INVALIDO);
        }
        if (string.length() != 11) {
            return new RetornoValidacao(CPF_INVALIDO);
        }
        if (!Validador.validarModulo11(string.substring(0, 10), null, 2) || !Validador.validarModulo11(string, null, 2)) {
            return new RetornoValidacao(CPF_INVALIDO);
        }
        return null;
    }

    public static RetornoValidacao validarNIRF(String string) {
        if (string.trim().length() < 8) {
            return new RetornoValidacao(NIRF_INVALIDO, 2);
        }
        if (string.trim().equals("00000000")) {
            return new RetornoValidacao(NIRF_INVALIDO, 2);
        }
        if (!Validador.validarModulo11(string, null, 2)) {
            return new RetornoValidacao(NIRF_INVALIDO, 2);
        }
        return null;
    }

    public static RetornoValidacao validarCNPJ(String string) {
        if (string == null || string.equals("")) {
            return new RetornoValidacao(CNPJ_INVALIDO);
        }
        if (!UtilitariosString.isNumeric(string)) {
            return new RetornoValidacao(CNPJ_INVALIDO);
        }
        if (string.length() != 14) {
            return new RetornoValidacao(CNPJ_INVALIDO);
        }
        if (string.equals("11111111000191") || string.equals("00000000000000") || string.equals("22222222000191") || string.equals("33333333000191") || string.equals("44444444000191") || string.equals("55555555000191") || string.equals("66666666000191") || string.equals("77777777000191") || string.equals("88888888000191") || string.equals("99999999000191")) {
            return new RetornoValidacao(CNPJ_INVALIDO);
        }
        if (!Validador.validarModulo11(string.substring(0, 13), "543298765432", 2) || !Validador.validarModulo11(string, "6543298765432", 2)) {
            return new RetornoValidacao(CNPJ_INVALIDO);
        }
        return null;
    }

    public static RetornoValidacao validarNI(String string) {
        if (string == null || string.equals("")) {
            return new RetornoValidacao(NI_INVALIDO);
        }
        if (string.length() == 11) {
            return Validador.validarCPF(string);
        }
        if (string.length() == 14) {
            return Validador.validarCNPJ(string);
        }
        return new RetornoValidacao(NI_INVALIDO);
    }

    public static int verificaData(String string) {
        int n;
        int n2;
        int n3;
        if (string == null || string.equals("  /  /    ")) {
            return 1;
        }
        int n4 = 31;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        if (stringTokenizer.countTokens() != 3) {
            return 1;
        }
        String string2 = stringTokenizer.nextToken();
        try {
            n3 = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return 2;
        }
        string2 = stringTokenizer.nextToken();
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return 3;
        }
        string2 = stringTokenizer.nextToken();
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return 4;
        }
        if (n2 <= 0 || n2 >= 13) {
            return 3;
        }
        n4 = Validador.calculaDiasMes(n2, n);
        if (n3 <= 0 || n3 > n4) {
            return 2;
        }
        return 0;
    }

    public static RetornoValidacao validarDataComCriterio(String string, String string2) {
        int n;
        int n2;
        if (string == null || string.equals("  /  /    ")) {
            return new RetornoValidacao(DATA_INVALIDO);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        if (stringTokenizer.countTokens() != 3) {
            return new RetornoValidacao(DATA_INVALIDO);
        }
        String string3 = stringTokenizer.nextToken();
        try {
            Integer.parseInt(string3);
        }
        catch (Exception exception) {
            return new RetornoValidacao(DATA_DIA_INVALIDO);
        }
        string3 = stringTokenizer.nextToken();
        try {
            n2 = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            return new RetornoValidacao(DATA_MES_INVALIDO);
        }
        string3 = stringTokenizer.nextToken();
        try {
            n = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            return new RetornoValidacao(DATA_ANO_INVALIDO);
        }
        if (n2 <= 0 || n2 >= 13) {
            return new RetornoValidacao(DATA_MES_INVALIDO);
        }
        int n3 = Integer.parseInt(ConstantesGlobais.EXERCICIO);
        if (string2.equals("<") ? n <= 0 || n >= n3 || n < n3 - 133 && n != 0 : (string2.equals("=") ? n <= 0 || n != n3 || n < n3 - 133 && n != 0 : string2.equals(">") && (n <= 0 || n <= n3 || n < n3 - 133 && n != 0))) {
            return new RetornoValidacao(DATA_ANO_INVALIDO);
        }
        return null;
    }

    public static RetornoValidacao validarData(String string, int n) {
        int n2;
        int n3;
        int n4;
        if (string == null || string.equals("  /  /    ")) {
            return new RetornoValidacao(DATA_INVALIDO);
        }
        int n5 = 31;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        if (stringTokenizer.countTokens() != 3) {
            return new RetornoValidacao(DATA_INVALIDO);
        }
        String string2 = stringTokenizer.nextToken();
        try {
            n4 = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return new RetornoValidacao(DATA_DIA_INVALIDO);
        }
        string2 = stringTokenizer.nextToken();
        try {
            n3 = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return new RetornoValidacao(DATA_MES_INVALIDO);
        }
        string2 = stringTokenizer.nextToken();
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return new RetornoValidacao(DATA_ANO_INVALIDO);
        }
        if (n3 <= 0 || n3 >= 13) {
            return new RetornoValidacao(DATA_MES_INVALIDO);
        }
        int n6 = Integer.parseInt(ConstantesGlobais.EXERCICIO);
        if (n2 <= 0 || n2 >= n || n2 < n6 - 131 && n2 != 0) {
            return new RetornoValidacao(DATA_ANO_INVALIDO);
        }
        n5 = Validador.calculaDiasMes(n3, n2);
        if (n4 <= 0 || n4 > n5) {
            return new RetornoValidacao(DATA_DIA_INVALIDO);
        }
        return null;
    }

    public static RetornoValidacao validarData(String string) {
        int n;
        int n2;
        int n3;
        if (string == null || string.equals("  /  /    ")) {
            return new RetornoValidacao(DATA_INVALIDO);
        }
        int n4 = 31;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        if (stringTokenizer.countTokens() != 3) {
            return new RetornoValidacao(DATA_INVALIDO);
        }
        String string2 = stringTokenizer.nextToken();
        try {
            n3 = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return new RetornoValidacao(DATA_DIA_INVALIDO);
        }
        string2 = stringTokenizer.nextToken();
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return new RetornoValidacao(DATA_MES_INVALIDO);
        }
        string2 = stringTokenizer.nextToken();
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return new RetornoValidacao(DATA_ANO_INVALIDO);
        }
        if (n2 <= 0 || n2 >= 13) {
            return new RetornoValidacao(DATA_MES_INVALIDO);
        }
        int n5 = Integer.parseInt(ConstantesGlobais.EXERCICIO);
        if (n <= 0 || n >= n5 || n < n5 - 133 && n != 0) {
            return new RetornoValidacao(DATA_ANO_INVALIDO);
        }
        n4 = Validador.calculaDiasMes(n2, n);
        if (n3 <= 0 || n3 > n4) {
            return new RetornoValidacao(DATA_DIA_INVALIDO);
        }
        if (n > Integer.parseInt(ConstantesGlobais.ANO_BASE)) {
            return new RetornoValidacao(DATA_ANO_INVALIDO);
        }
        return null;
    }

    public static RetornoValidacao validarEmail(String string) {
        if (string == null || string.equals("")) {
            return new RetornoValidacao(EMAIL_INVALIDO);
        }
        int n = 0;
        int n2 = 0;
        n = UtilitariosString.ContaPalavras(string);
        if (n > 1) {
            return new RetornoValidacao(EMAIL_INVALIDO);
        }
        n = UtilitariosString.ContaPalavras(string, "@");
        if (n != 2) {
            return new RetornoValidacao(EMAIL_INVALIDO);
        }
        if (string.length() > 50) {
            return new RetornoValidacao(EMAIL_INVALIDO);
        }
        if (string.charAt(0) == '@') {
            return new RetornoValidacao(EMAIL_INVALIDO);
        }
        int n3 = 1;
        while (n3 <= string.length() - 1) {
            if (string.charAt(n3) == '@') {
                ++n2;
            }
            if (string.charAt(n3) == '.' && string.charAt(n3 - 1) == '.') {
                return new RetornoValidacao(EMAIL_INVALIDO);
            }
            if (string.charAt(n3) == ' ') {
                return new RetornoValidacao(EMAIL_INVALIDO);
            }
            ++n3;
        }
        if (n2 != 1) {
            return new RetornoValidacao(EMAIL_INVALIDO);
        }
        return null;
    }

    public static RetornoValidacao validarNomeCompleto(String string) {
        if (string == null || string.equals("")) {
            return new RetornoValidacao(NOME_BRANCO);
        }
        if (string.length() > 60) {
            return new RetornoValidacao(NOME_MAIS_60);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() < 2) {
            return new RetornoValidacao(NOME_MENOS_2);
        }
        if (stringTokenizer.countTokens() > 15) {
            return new RetornoValidacao(NOME_MAIS_15);
        }
        RetornoValidacao retornoValidacao = null;
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (bl) {
                if (string2.length() < 2) {
                    return new RetornoValidacao(NOME_1_CARACTER);
                }
                bl = false;
            }
            if ((retornoValidacao = Validador.validarNome(string2)) != null) break;
        }
        return retornoValidacao;
    }

    private static RetornoValidacao validarNome(String string) {
        if (string == null || string.equals("")) {
            return new RetornoValidacao(NOME_BRANCO);
        }
        if (string.length() > 20) {
            return new RetornoValidacao(NOME_MAIS_20);
        }
        int n = 1;
        int n2 = 1;
        while (n2 < string.length()) {
            n = string.charAt(n2) == string.charAt(n2 - 1) ? ++n : 1;
            if (n == 3 && !string.equals("III")) {
                return new RetornoValidacao(NOME_3_CONSECUTIVOS);
            }
            if (Character.isDigit(string.charAt(n2 - 1))) {
                return new RetornoValidacao(NOME_NUMERICO);
            }
            if (!Character.isLetter(string.charAt(n2 - 1))) {
                return new RetornoValidacao(NOME_INVALIDO);
            }
            ++n2;
        }
        if (Character.isDigit(string.charAt(string.length() - 1))) {
            return new RetornoValidacao(NOME_NUMERICO);
        }
        if (!Character.isLetter(string.charAt(string.length() - 1))) {
            return new RetornoValidacao(NOME_INVALIDO);
        }
        if ("ESP\u00d3LIO".equals(string.toUpperCase())) {
            return new RetornoValidacao(NOME_ESPOLIO);
        }
        return null;
    }

    public static RetornoValidacao validarDataDecisaoJudicialPartilha(Date date) {
        if (date == null || date.equals("")) {
            return new RetornoValidacao(DATA_INVALIDO);
        }
        return null;
    }

    public static RetornoValidacao validarDataNaoResidente(Date date) {
        if (date == null || date.equals("")) {
            return new RetornoValidacao(DATA_INVALIDO);
        }
        return null;
    }

    public static RetornoValidacao validarDataResidente(Date date) {
        if (date == null || date.equals("")) {
            return new RetornoValidacao(DATA_INVALIDO);
        }
        return null;
    }

    public static RetornoValidacao validarDataTransitoJulgado(Date date) {
        if (date == null || date.equals("")) {
            return new RetornoValidacao(DATA_INVALIDO);
        }
        return null;
    }

    public static RetornoValidacao validarDDD_DDI(String string) {
        if (string == null || string.equals("")) {
            return new RetornoValidacao(DDD_DDI_INVALIDO);
        }
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return new RetornoValidacao(DDD_DDI_INVALIDO);
        }
        if (string.length() != 2) {
            return new RetornoValidacao(DDD_DDI_2_DIGITOS);
        }
        return null;
    }

    public static RetornoValidacao validarCEP(String string) {
        if (string == null || string.trim().equals("-")) {
            return new RetornoValidacao(CEP_INVALIDO);
        }
        if (string.trim().length() != 8) {
            return new RetornoValidacao(CEP_INVALIDO);
        }
        return null;
    }

    private static int calculaDiasMes(int n, int n2) {
        int n3 = 31;
        switch (n) {
            case 1: {
                n3 = 31;
                break;
            }
            case 2: {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                if (gregorianCalendar.isLeapYear(n2)) {
                    n3 = 29;
                    break;
                }
                n3 = 28;
                break;
            }
            case 3: {
                n3 = 31;
                break;
            }
            case 4: {
                n3 = 30;
                break;
            }
            case 5: {
                n3 = 31;
                break;
            }
            case 6: {
                n3 = 30;
                break;
            }
            case 7: {
                n3 = 31;
                break;
            }
            case 8: {
                n3 = 31;
                break;
            }
            case 9: {
                n3 = 30;
                break;
            }
            case 10: {
                n3 = 31;
                break;
            }
            case 11: {
                n3 = 30;
                break;
            }
            case 12: {
                n3 = 31;
            }
        }
        return n3;
    }

    public static RetornoValidacao validarElementoTabela(String string, List list, String string2) {
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                ElementoTabela elementoTabela = (ElementoTabela)list.get(n);
                if (elementoTabela.getConteudo(0).compareTo(string) == 0) {
                    return new RetornoValidacao(0);
                }
                ++n;
            }
        }
        return new RetornoValidacao(string2);
    }

    public static boolean validarNrRecibo(String string) {
        int n;
        int n2;
        if ((string = string.trim()).length() == 0 || string.length() != 12 && string.length() != 9 || !UtilitariosString.isNumeric(string)) {
            return false;
        }
        return !(string.length() == 9 ? (n2 = Validador.calculaDVRecibo9Digitos(string)) != (n = Integer.parseInt(string.substring(string.length() - 1))) : !Validador.validarModulo11(string.substring(0, 11), null, 2) || !Validador.validarModulo11(string, null, 2));
    }

    private static int calculaDVRecibo9Digitos(String string) {
        int n = 0;
        int[] nArray = new int[]{8, 6, 4, 2, 3, 5, 9, 7};
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4 = Integer.parseInt(string.substring(n3, n3 + 1));
            n2 += n4 * nArray[n3];
            ++n3;
        }
        n = (n2 %= 11) == 0 ? 5 : (n2 == 1 ? 0 : 11 - n2);
        return n;
    }

    public static boolean validarString(String string, String string2) {
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    public static boolean validarCodImovelIncra(String string) {
        if (!Validador.validarModulo11(string, "765432765432", 2)) {
            return false;
        }
        if (!Validador.validarModulo11(string.substring(0, 6), "65432", 2)) {
            return false;
        }
        return Validador.validarModulo11(string.substring(6, 12), "65432", 2);
    }

    public static RetornoValidacao validarNIT(String string) {
        int n;
        int n2;
        if ((string = string.trim()).length() == 0 || string.length() != 11 || !UtilitariosString.isNumeric(string)) {
            return new RetornoValidacao(NIT_INVALIDO);
        }
        if (string.length() == 11 && (n2 = Validador.calculaDVNIT(string)) != (n = Integer.parseInt(string.substring(string.length() - 1)))) {
            return new RetornoValidacao(NIT_INVALIDO);
        }
        return null;
    }

    private static int calculaDVNIT(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[]{3, 2, 9, 8, 7, 6, 5, 4, 3, 2};
        int n4 = 0;
        while (n4 < nArray.length) {
            int n5 = Integer.parseInt(string.substring(n4, n4 + 1));
            n2 += n5 * nArray[n4];
            ++n4;
        }
        n3 = n2 % 11;
        n = 11 - n3;
        return n;
    }

    public static void main(String[] stringArray) {
    }
}

